/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorDescription
implements Comparable<OperatorDescription> {
    private String name;
    private Class<?> clazz;
    private String shortDescription;
    private String longDescription;
    private String group;
    private ImageIcon icon = null;
    private String iconPath;
    private String deprecationInfo = null;

    public OperatorDescription(ClassLoader classLoader, String name, String className, String shortDescription, String longDescription, String group, String iconName, String deprecationInfo) throws ClassNotFoundException {
        this.name = name;
        this.clazz = Class.forName(className, true, classLoader);
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.group = group;
        this.deprecationInfo = deprecationInfo;
        if (this.deprecationInfo != null && this.deprecationInfo.trim().length() == 0) {
            this.deprecationInfo = null;
        }
        this.reloadIcon(iconName);
    }

    public void reloadIcon(String iconName) {
        if (this.iconPath == null) {
            if (iconName != null && iconName.length() > 0) {
                this.icon = SwingTools.createIcon("operators/24/" + iconName + ".png");
                this.iconPath = "operators/24/" + iconName + ".png";
            } else {
                String groupIconName = this.group.toLowerCase();
                this.icon = SwingTools.createIcon("groups/24/" + groupIconName + ".png");
                while (this.icon == null && groupIconName.length() > 0) {
                    if (groupIconName.indexOf(".") >= 0) {
                        groupIconName = groupIconName.substring(0, groupIconName.lastIndexOf(".")).toLowerCase();
                        this.icon = SwingTools.createIcon("groups/24/" + groupIconName + ".png");
                        continue;
                    }
                    groupIconName = "";
                }
                this.iconPath = "groups/24/" + groupIconName + ".png";
            }
        } else {
            this.icon = SwingTools.createIcon(this.iconPath);
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getOperatorClass() {
        return this.clazz;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescriptionHTML() {
        return this.longDescription;
    }

    public String getGroup() {
        return this.group;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getDeprecationInfo() {
        return this.deprecationInfo;
    }

    public String toString() {
        return "operator '" + this.name + "' loaded from " + this.clazz + ", description: " + this.shortDescription + ", group: " + this.group + ", icon: " + this.iconPath;
    }

    @Override
    public int compareTo(OperatorDescription d) {
        return this.name.compareTo(d.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OperatorDescription)) {
            return false;
        }
        return this.name.equals(((OperatorDescription)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Operator createOperatorInstance() throws OperatorCreationException {
        Operator operator = null;
        try {
            Constructor<?> constructor = this.clazz.getConstructor(OperatorDescription.class);
            operator = (Operator)constructor.newInstance(this);
            if (this.name.startsWith("W-")) {
                operator.getParameterTypes();
            }
        }
        catch (InstantiationException e) {
            throw new OperatorCreationException(0, String.valueOf(this.name) + "(" + this.clazz.getName() + ")", e);
        }
        catch (IllegalAccessException e) {
            throw new OperatorCreationException(1, String.valueOf(this.name) + "(" + this.clazz.getName() + ")", e);
        }
        catch (NoSuchMethodException e) {
            throw new OperatorCreationException(2, String.valueOf(this.name) + "(" + this.clazz.getName() + ")", e);
        }
        catch (InvocationTargetException e) {
            throw new OperatorCreationException(3, String.valueOf(this.name) + "(" + this.clazz.getName() + ")", e);
        }
        return operator;
    }
}

