/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;

public class LinearRegressionModel
extends PredictionModel {
    private static final long serialVersionUID = 8381268071090932037L;
    private String[] attributeNames;
    private String[] attributeConstructions;
    private boolean[] selectedAttributes;
    private double[] coefficients;
    private boolean useIntercept = true;
    private String firstClassName = null;
    private String secondClassName = null;

    public LinearRegressionModel(ExampleSet exampleSet, boolean[] selectedAttributes, double[] coefficients, boolean useIntercept, String firstClassName, String secondClassName) {
        super(exampleSet);
        this.attributeNames = Tools.getRegularAttributeNames(exampleSet);
        this.attributeConstructions = Tools.getRegularAttributeConstructions(exampleSet);
        this.selectedAttributes = selectedAttributes;
        this.coefficients = coefficients;
        this.useIntercept = useIntercept;
        this.firstClassName = firstClassName;
        this.secondClassName = secondClassName;
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        Attribute[] attributes = new Attribute[this.attributeNames.length];
        int i = 0;
        while (i < this.attributeNames.length) {
            attributes[i] = exampleSet.getAttributes().get(this.attributeNames[i]);
            if (attributes[i] == null && this.selectedAttributes[i]) {
                throw new UserError(null, 111, this.attributeNames[i]);
            }
            ++i;
        }
        for (Example example : exampleSet) {
            double prediction = 0.0;
            int index = 0;
            int attributeCounter = 0;
            Attribute[] attributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                if (this.selectedAttributes[attributeCounter]) {
                    prediction += this.coefficients[index] * example.getValue(attribute);
                    ++index;
                }
                ++attributeCounter;
                ++n2;
            }
            if (this.useIntercept) {
                prediction += this.coefficients[index];
            }
            if (predictedLabel.isNominal()) {
                int predictionIndex = prediction > 0.5 ? predictedLabel.getMapping().getIndex(this.secondClassName) : predictedLabel.getMapping().getIndex(this.firstClassName);
                example.setValue(predictedLabel, predictionIndex);
                example.setConfidence(this.secondClassName, 1.0 / (1.0 + Math.exp(-prediction)));
                example.setConfidence(this.firstClassName, 1.0 / (1.0 + Math.exp(prediction)));
                continue;
            }
            example.setValue(predictedLabel, prediction);
        }
        return exampleSet;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        int index = 0;
        int i = 0;
        while (i < this.selectedAttributes.length) {
            if (this.selectedAttributes[i]) {
                result.append(String.valueOf(this.getCoefficientString(this.coefficients[index], first)) + " * " + this.attributeConstructions[i] + com.rapidminer.tools.Tools.getLineSeparator());
                ++index;
                first = false;
            }
            ++i;
        }
        if (this.useIntercept) {
            result.append(this.getCoefficientString(this.coefficients[this.coefficients.length - 1], first));
        }
        return result.toString();
    }

    private String getCoefficientString(double coefficient, boolean first) {
        if (!first) {
            if (coefficient >= 0.0) {
                return "+ " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
            }
            return "- " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
        }
        if (coefficient >= 0.0) {
            return "  " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
        }
        return "- " + com.rapidminer.tools.Tools.formatNumber(Math.abs(coefficient));
    }
}

