/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.evosvm;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.FormulaProvider;
import com.rapidminer.operator.learner.functions.kernel.KernelModel;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.DotKernel;
import com.rapidminer.tools.math.kernels.Kernel;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvoSVMModel
extends KernelModel
implements FormulaProvider {
    private static final long serialVersionUID = 2848059541066828127L;
    private Kernel kernel;
    private List<SupportVector> supportVectors;
    private double bias;
    private double[] weights = null;

    public EvoSVMModel(ExampleSet exampleSet, List<SupportVector> supportVectors, Kernel kernel, double bias) {
        super(exampleSet);
        this.supportVectors = supportVectors;
        if (supportVectors == null || supportVectors.size() == 0) {
            throw new IllegalArgumentException("Null or empty support vector collection: not possible to predict values!");
        }
        this.kernel = kernel;
        this.bias = bias;
        if (this.kernel instanceof DotKernel) {
            this.weights = new double[this.getNumberOfAttributes()];
            int i = 0;
            while (i < this.getNumberOfSupportVectors()) {
                SupportVector sv = this.getSupportVector(i);
                if (sv != null) {
                    double[] x = sv.getX();
                    double alpha = sv.getAlpha();
                    double y = sv.getY();
                    int j = 0;
                    while (j < this.weights.length) {
                        int n = j;
                        this.weights[n] = this.weights[n] + y * alpha * x[j];
                        ++j;
                    }
                } else {
                    this.weights = null;
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isClassificationModel() {
        return this.getLabel().isNominal();
    }

    @Override
    public double getAlpha(int index) {
        return this.supportVectors.get(index).getAlpha();
    }

    @Override
    public String getId(int index) {
        return null;
    }

    @Override
    public double getBias() {
        return this.bias;
    }

    @Override
    public SupportVector getSupportVector(int index) {
        return this.supportVectors.get(index);
    }

    @Override
    public int getNumberOfSupportVectors() {
        return this.supportVectors.size();
    }

    @Override
    public int getNumberOfAttributes() {
        return this.supportVectors.get(0).getX().length;
    }

    @Override
    public double getAttributeValue(int exampleIndex, int attributeIndex) {
        return this.supportVectors.get(exampleIndex).getX()[attributeIndex];
    }

    @Override
    public String getClassificationLabel(int index) {
        double y = this.getRegressionLabel(index);
        if (y < 0.0) {
            return this.getLabel().getMapping().getNegativeString();
        }
        return this.getLabel().getMapping().getPositiveString();
    }

    @Override
    public double getRegressionLabel(int index) {
        return this.supportVectors.get(index).getY();
    }

    @Override
    public double getFunctionValue(int index) {
        double[] values = this.supportVectors.get(index).getX();
        return this.bias + this.kernel.getSum(this.supportVectors, values);
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predLabel) {
        if (exampleSet.getAttributes().size() != this.getNumberOfAttributes()) {
            throw new RuntimeException("Cannot apply model: incompatible numbers of attributes (" + exampleSet.getAttributes().size() + " != " + this.getNumberOfAttributes() + ")!");
        }
        if (this.kernel instanceof DotKernel && this.weights != null) {
            for (Example example : exampleSet) {
                double sum = this.getBias();
                int a = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    sum += this.weights[a] * example.getValue(attribute);
                    ++a;
                }
                if (this.getLabel().isNominal()) {
                    int index = sum > 0.0 ? this.getLabel().getMapping().getPositiveIndex() : this.getLabel().getMapping().getNegativeIndex();
                    example.setValue(predLabel, index);
                    example.setConfidence(predLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-sum)));
                    example.setConfidence(predLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(sum)));
                    continue;
                }
                example.setValue(predLabel, sum);
            }
            return exampleSet;
        }
        for (Example current : exampleSet) {
            double[] currentX = new double[exampleSet.getAttributes().size()];
            int x = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                currentX[x++] = current.getValue(attribute);
            }
            double sum = this.bias + this.kernel.getSum(this.supportVectors, currentX);
            if (this.getLabel().isNominal()) {
                int index = sum > 0.0 ? this.getLabel().getMapping().getPositiveIndex() : this.getLabel().getMapping().getNegativeIndex();
                current.setValue(predLabel, index);
                current.setConfidence(predLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-sum)));
                current.setConfidence(predLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(sum)));
                continue;
            }
            current.setValue(predLabel, sum);
        }
        return exampleSet;
    }

    @Override
    public String getFormula() {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < this.getNumberOfSupportVectors()) {
            double alpha;
            SupportVector sv = this.getSupportVector(i);
            if (sv != null && !Tools.isZero(alpha = sv.getAlpha())) {
                result.append(Tools.getLineSeparator());
                double[] x = sv.getX();
                double y = sv.getY();
                double factor = y * alpha;
                if (factor < 0.0) {
                    if (first) {
                        result.append("- " + Math.abs(factor));
                    } else {
                        result.append("- " + Math.abs(factor));
                    }
                } else if (first) {
                    result.append("  " + factor);
                } else {
                    result.append("+ " + factor);
                }
                result.append(" * (" + this.kernel.getDistanceFormula(x, this.getAttributeConstructions()) + ")");
                first = false;
            }
            ++i;
        }
        double bias = this.getBias();
        if (!Tools.isZero(bias)) {
            result.append(Tools.getLineSeparator());
            if (bias < 0.0) {
                if (first) {
                    result.append("- " + Math.abs(bias));
                } else {
                    result.append("- " + Math.abs(bias));
                }
            } else if (first) {
                result.append(bias);
            } else {
                result.append("+ " + bias);
            }
        }
        return result.toString();
    }
}

