/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;

public class MultiModel
extends PredictionModel {
    private static final long serialVersionUID = -8483834213562711715L;
    private Model[] models;

    public MultiModel(ExampleSet exampleSet, Model[] models) {
        super(exampleSet);
        this.models = models;
    }

    public int getNumberOfModels() {
        return this.models.length;
    }

    public Model getModel(int index) {
        return this.models[index];
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        ExampleSet[] eSet = new ExampleSet[this.getNumberOfModels()];
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            eSet[i] = (ExampleSet)exampleSet.clone();
            eSet[i] = model.apply(eSet[i]);
            ++i;
        }
        ArrayList reader = new ArrayList(eSet.length);
        int r = 0;
        while (r < eSet.length) {
            reader.add(eSet[r].iterator());
            ++r;
        }
        Iterator originalReader = exampleSet.iterator();
        while (originalReader.hasNext()) {
            double bestLabel = Double.NaN;
            double highestFunctionValue = Double.NEGATIVE_INFINITY;
            int k = 0;
            while (k < reader.size()) {
                double functionValue = ((Example)((Iterator)reader.get(k)).next()).getPredictedLabel();
                if (functionValue > highestFunctionValue) {
                    highestFunctionValue = functionValue;
                    bestLabel = k;
                }
                ++k;
            }
            ((Example)originalReader.next()).setPredictedLabel(bestLabel);
        }
        return exampleSet;
    }

    public Component getVisualizationComponent(IOContainer container) {
        ExtendedJTabbedPane tabPane = new ExtendedJTabbedPane();
        int i = 0;
        while (i < this.getNumberOfModels()) {
            Model model = this.getModel(i);
            tabPane.add("Model " + (i + 1), model.getVisualizationComponent(container));
            ++i;
        }
        return tabPane;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparator());
        int i = 0;
        while (i < this.models.length) {
            result.append(String.valueOf(i > 0 ? Tools.getLineSeparator() : "") + this.models[i].toString());
            ++i;
        }
        return result.toString();
    }
}

