/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.weka;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.weka.WekaClassifier;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.WekaLearnerCapabilities;
import com.rapidminer.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnassignedClassException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericWekaLearner
extends AbstractLearner
implements TechnicalInformationHandler {
    public static final String[] WEKA_CLASSIFIERS = WekaTools.getWekaClasses(Classifier.class, ".meta.", false);
    private List<ParameterType> wekaParameters = new LinkedList<ParameterType>();

    public GenericWekaLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Classifier classifier = this.getWekaClassifier(WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        this.log("Converting to Weka instances.");
        Instances instances = WekaTools.toWekaInstances(exampleSet, "LearningInstances", 0);
        try {
            this.log("Building Weka classifier.");
            classifier.buildClassifier(instances);
        }
        catch (UnassignedClassException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, new Object[]{this.getOperatorClassName(), e});
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UserError((Operator)this, (Throwable)e, 105, this.getOperatorClassName(), e);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, this.getOperatorClassName(), e.getMessage());
        }
        return new WekaClassifier(exampleSet, this.getOperatorClassName(), classifier);
    }

    private Classifier getWekaClassifier(String[] parameters) throws OperatorException {
        String classifierName = this.getWekaClassPath();
        Classifier classifier = null;
        try {
            Class<?> clazz = Class.forName(classifierName);
            classifier = (Classifier)clazz.newInstance();
            if (parameters != null && classifier instanceof OptionHandler) {
                ((OptionHandler)classifier).setOptions(parameters);
            }
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, classifierName, e);
        }
        return classifier;
    }

    public TechnicalInformation getTechnicalInformation() {
        try {
            Classifier classifier = this.getWekaClassifier(null);
            if (classifier instanceof TechnicalInformationHandler) {
                return ((TechnicalInformationHandler)classifier).getTechnicalInformation();
            }
            return null;
        }
        catch (OperatorException e) {
            return null;
        }
    }

    public String getWekaClassPath() {
        String prefixName = this.getOperatorClassName();
        String actualName = prefixName.substring("W-".length());
        int i = 0;
        while (i < WEKA_CLASSIFIERS.length) {
            if (WEKA_CLASSIFIERS[i].endsWith(actualName)) {
                return WEKA_CLASSIFIERS[i];
            }
            ++i;
        }
        return null;
    }

    public List getWekaParameterList() {
        return this.wekaParameters;
    }

    @Override
    public boolean onlyWarnForNonSufficientCapabilities() {
        return true;
    }

    @Override
    public boolean supportsCapability(LearnerCapability capability) {
        Classifier classifier;
        try {
            classifier = this.getWekaClassifier(WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        }
        catch (OperatorException e) {
            return true;
        }
        if (classifier != null) {
            try {
                return WekaLearnerCapabilities.supportsCapability(classifier, capability);
            }
            catch (Throwable t) {
                return true;
            }
        }
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Classifier classifier = null;
        try {
            classifier = this.getWekaClassifier(null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka classifier " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList<ParameterType>();
        if (classifier != null && classifier instanceof OptionHandler) {
            WekaTools.addParameterTypes((OptionHandler)classifier, types, this.wekaParameters, false, null);
        }
        return types;
    }
}

