/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.meta.ParameterIteratingOperatorChain;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.operator.performance.PerformanceVector;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterOptimizationOperator
extends ParameterIteratingOperatorChain {
    public ParameterOptimizationOperator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("performance", "currently best performance"){

            public double getDoubleValue() {
                return ParameterOptimizationOperator.this.getCurrentBestPerformance();
            }
        });
    }

    public abstract double getCurrentBestPerformance();

    protected PerformanceVector getPerformance(IOContainer input, Collection<Operator> operators) {
        try {
            for (Operator operator : operators) {
                input = operator.apply(input);
            }
            return input.remove(PerformanceVector.class);
        }
        catch (OperatorException e) {
            this.logWarning("Cannot evaluate performance for current parameter combination: " + e.getMessage());
            return null;
        }
    }

    protected PerformanceVector getPerformance() {
        IOContainer resultContainer = this.getInput();
        try {
            int i = 0;
            while (i < this.getNumberOfOperators()) {
                resultContainer = this.getOperator(i).apply(resultContainer);
                ++i;
            }
            return resultContainer.remove(PerformanceVector.class);
        }
        catch (OperatorException e) {
            this.logWarning("Cannot evaluate performance for current parameter combination: " + e.getMessage());
            return null;
        }
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{PerformanceVector.class});
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ParameterSet.class, PerformanceVector.class};
    }
}

