/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.painters;

import com.rapidminer.gui.look.RapidLookTools;
import com.rapidminer.gui.look.painters.AbstractCachedPainter;
import com.rapidminer.gui.look.painters.ButtonBorderPainter;
import com.rapidminer.gui.look.painters.ButtonPainter;
import com.rapidminer.gui.look.painters.CheckboxPainter;
import com.rapidminer.gui.look.painters.ComboBoxPainter;
import com.rapidminer.gui.look.painters.DeterminateProgressBarPainter;
import com.rapidminer.gui.look.painters.InDeterminateProgressBarPainter;
import com.rapidminer.gui.look.painters.MenuBackgroundPainter;
import com.rapidminer.gui.look.painters.MenuBarBackgroundPainter;
import com.rapidminer.gui.look.painters.MenuItemFadingPainter;
import com.rapidminer.gui.look.painters.MenuSeparatorPainter;
import com.rapidminer.gui.look.painters.RadioButtonPainter;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;

public class CashedPainter {
    public static void clearMenuCache() {
        AbstractCachedPainter.clearCache();
    }

    public static void clearCashedImages() {
        AbstractCachedPainter.clearCache();
    }

    public static boolean drawMenuBackground(Component c, Graphics g, int x, int y, int w, int h) {
        if (h < 0 || w < 0) {
            return true;
        }
        MenuBackgroundPainter.SINGLETON.paint(c, g, x, y, w, h);
        return true;
    }

    public static boolean drawMenuBarBackground(Component c, Graphics g, int x, int y, int w, int h) {
        if (h < 0 || w < 0) {
            return true;
        }
        MenuBarBackgroundPainter.SINGLETON.paint(c, g, x, y, w, h);
        return true;
    }

    public static boolean drawProgressBar(Component c, Graphics g, boolean vertical, boolean indeterminate, int x, int y, int w, int h) {
        if (h < 0 || w < 0) {
            return true;
        }
        if (!indeterminate) {
            DeterminateProgressBarPainter.SINGLETON.paint(c, g, x, y, w, h, new Object[]{vertical});
        } else {
            InDeterminateProgressBarPainter.SINGLETON.paint(c, g, x, y, w, h, new Object[]{vertical});
        }
        return true;
    }

    public static boolean drawRadioButton(Component c, Graphics g) {
        JRadioButton radioButton = (JRadioButton)c;
        ButtonModel bm = radioButton.getModel();
        int w = c.getWidth();
        int h = c.getHeight();
        if (h < 0 || w < 0) {
            return true;
        }
        RadioButtonPainter.SINGLETON.paint(c, g, c.getX(), c.getY(), w, h, new Object[]{bm.isSelected(), bm.isEnabled(), bm.isPressed() || bm.isSelected(), bm.isArmed(), new Boolean(bm.isRollover() && radioButton.isRolloverEnabled())});
        return true;
    }

    public static boolean drawMenuSeparator(Component c, Graphics g) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (h < 0 || w < 0) {
            return true;
        }
        MenuSeparatorPainter.SINGLETON.paint(c, g, c.getX(), c.getY(), w, h);
        return true;
    }

    public static boolean drawCheckBoxIcon(Component c, Graphics g) {
        JCheckBox checkbox = (JCheckBox)c;
        ButtonModel bm = checkbox.getModel();
        int w = c.getWidth();
        int h = c.getHeight();
        if (h < 0 || w < 0) {
            return true;
        }
        CheckboxPainter.SINGLETON.paint(c, g, c.getX(), c.getY(), w, h, new Object[]{bm.isSelected(), bm.isEnabled(), bm.isPressed(), bm.isArmed(), new Boolean(bm.isRollover() && checkbox.isRolloverEnabled())});
        return true;
    }

    public static boolean drawMenuItemFading(Component c, Graphics g) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (h < 0 || w < 0) {
            return true;
        }
        g.setColor(RapidLookTools.getColors().getMenuItemBackground());
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        if (!RapidLookTools.getColors().getMenuItemFadingColor().equals(RapidLookTools.getColors().getMenuItemBackground())) {
            MenuItemFadingPainter.SINGLETON.paint(c, g, c.getX(), c.getY(), w, h);
        }
        return true;
    }

    public static boolean drawComboBox(Component c, Graphics g, boolean down) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        JComboBox comboBox = (JComboBox)c;
        ComboBoxPainter.SINGLETON.paint(c, g, 0, 0, w, h, new Object[]{down, comboBox.isEnabled()});
        return true;
    }

    public static boolean drawComboBoxBorder(Component c, Graphics g, boolean down, boolean round) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        JComboBox comboBox = (JComboBox)c;
        String type = null;
        type = comboBox.isEnabled() ? (comboBox.hasFocus() ? "ROLLOVER" : "NORMAL") : "DISABLE";
        ButtonBorderPainter.SINGLETON.paint(c, g, 0, 0, w, h, new Object[]{down, round, type});
        return true;
    }

    public static boolean drawButtonBorder(Component c, Graphics g, String prefix) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        AbstractButton b = (AbstractButton)c;
        ButtonModel bm = ((AbstractButton)c).getModel();
        boolean down = false;
        boolean draw = false;
        String type = "";
        if (b.isContentAreaFilled() && !(b.getParent() instanceof JToolBar)) {
            draw = true;
            boolean bl = down = bm.isArmed() && bm.isPressed() || bm.isSelected();
            type = bm.isEnabled() ? (bm.isRollover() && b.isRolloverEnabled() ? "ROLLOVER" : (b.hasFocus() && b.isFocusPainted() ? "FOCUS" : "NORMAL")) : "DISABLE";
        }
        if (draw) {
            ButtonBorderPainter.SINGLETON.paint(c, g, 0, 0, w, h, new Object[]{down, false, type});
        }
        return true;
    }

    public static boolean drawButton(Component c, Graphics g) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w <= 0 || h <= 0) {
            return true;
        }
        ButtonModel bm = ((AbstractButton)c).getModel();
        ButtonPainter.SINGLETON.paint(c, g, 0, 0, w, h, new Object[]{bm.isEnabled(), bm.isPressed(), bm.isSelected()});
        return true;
    }
}

