/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.Process;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJList;
import com.rapidminer.gui.tools.ExtendedListModel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.meta.ParameterIteratingOperatorChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeValue;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.value.ParameterValueGrid;
import com.rapidminer.parameter.value.ParameterValueList;
import com.rapidminer.parameter.value.ParameterValueRange;
import com.rapidminer.parameter.value.ParameterValues;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfigureParameterOptimizationDialog
extends JDialog {
    private static final long serialVersionUID = 187660784321413390L;
    private static final String ADD_ICON_NAME = "add2.png";
    private static final String LEFT_ICON_NAME = "arrow_left_green.png";
    private static final String RIGHT_ICON_NAME = "arrow_right_green.png";
    private static final String UP_ICON_NAME = "arrow_up_green.png";
    private static final String DOWN_ICON_NAME = "arrow_down_green.png";
    private static Icon ADD_ICON = SwingTools.createIcon("16/add2.png");
    private static Icon LEFT_ICON = SwingTools.createIcon("16/arrow_left_green.png");
    private static Icon RIGHT_ICON = SwingTools.createIcon("16/arrow_right_green.png");
    private static Icon UP_ICON = SwingTools.createIcon("16/arrow_up_green.png");
    private static Icon DOWN_ICON = SwingTools.createIcon("16/arrow_down_green.png");
    private boolean ok = false;
    private int mode;
    private ExtendedListModel operatorListModel;
    private ExtendedListModel parametersListModel;
    private ExtendedListModel selectedParametersListModel;
    private ExtendedJList operatorList;
    private ExtendedJList parametersList;
    private ExtendedJList selectedParametersList;
    private JLabel minValueJLabel;
    private JLabel maxValueJLabel;
    private JLabel stepsValueJLabel;
    private JLabel gridScaleValueJLabel;
    private JTextField minValueTextField;
    private JTextField maxValueTextField;
    private JTextField stepsValueTextField;
    private JComboBox gridScaleValueComboBox;
    private JList categoriesList;
    private JList selectedCategoriesList;
    private DefaultListModel categoriesListModel;
    private DefaultListModel selectedCategoriesListModel;
    private JTextField createValueTextField;
    private JButton createValueButton;
    private JButton addValueButton;
    private JButton removeValueButton;
    private JButton upListButton;
    private JButton downListButton;
    private JRadioButton choseGridRadioButton;
    private JRadioButton choseListRadioButton;
    private JLabel infoLabel;
    private ConfigurationListener listener;
    private Process process;
    private LinkedHashMap<String, ParameterValues> parameterValuesMap;

    public ConfigureParameterOptimizationDialog(ConfigurationListener listener) {
        super(RapidMinerGUI.getMainFrame(), "Specify parameters...", true);
        this.listener = listener;
        this.process = listener.getProcess();
        this.parameterValuesMap = new LinkedHashMap();
        this.initializeDialog();
        ParameterIteratingOperatorChain parameterOperatorChain = (ParameterIteratingOperatorChain)listener;
        this.mode = parameterOperatorChain.getParameterValueMode();
        List<ParameterValues> readParameterValues = null;
        try {
            List<String[]> parameterValueList = parameterOperatorChain.getParameterList("parameters");
            readParameterValues = parameterOperatorChain.parseParameterValues(parameterValueList);
        }
        catch (Exception e) {
            parameterOperatorChain.logWarning(e.getMessage());
        }
        if (readParameterValues != null) {
            for (ParameterValues parameterValue : readParameterValues) {
                this.addParameter(parameterValue);
            }
        }
        this.updateInfoLabel();
    }

    private void initializeDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel selectionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.operatorListModel = new ExtendedListModel();
        for (Operator op : ((OperatorChain)this.listener).getAllInnerOperators()) {
            String descriptionText = op.getOperatorDescription().getLongDescriptionHTML();
            if (descriptionText == null) {
                descriptionText = op.getOperatorDescription().getShortDescription();
            }
            StringBuffer toolTipText = new StringBuffer("<b>Description: </b>" + descriptionText);
            toolTipText.append(String.valueOf(Tools.getLineSeparator()) + "<b>Input:</b> " + SwingTools.getStringFromClassArray(op.getInputClasses()));
            toolTipText.append(String.valueOf(Tools.getLineSeparator()) + "<b>Output:</b> " + SwingTools.getStringFromClassArray(op.getOutputClasses()));
            this.operatorListModel.addElement(op, SwingTools.transformToolTipText(toolTipText.toString()));
        }
        this.operatorList = new ExtendedJList(this.operatorListModel);
        this.operatorList.setSelectionMode(0);
        this.operatorList.setLayoutOrientation(0);
        this.parametersListModel = new ExtendedListModel();
        this.parametersList = new ExtendedJList(this.parametersListModel);
        this.parametersList.setLayoutOrientation(0);
        this.operatorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int index = ConfigureParameterOptimizationDialog.this.operatorList.getSelectedIndex();
                if (index != -1) {
                    Operator op = (Operator)ConfigureParameterOptimizationDialog.this.operatorList.getModel().getElementAt(index);
                    ConfigureParameterOptimizationDialog.this.updateParameterListModel(op);
                }
            }
        });
        this.selectedParametersListModel = new ExtendedListModel();
        this.selectedParametersList = new ExtendedJList(this.selectedParametersListModel);
        this.selectedParametersList.setLayoutOrientation(0);
        this.selectedParametersList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ConfigureParameterOptimizationDialog.this.showParameterValues((String)ConfigureParameterOptimizationDialog.this.selectedParametersList.getSelectedValue());
            }
        });
        JPanel parameterSelectionButtonsPanel = new JPanel(new BorderLayout());
        JButton addParameterButton = null;
        addParameterButton = RIGHT_ICON != null ? new JButton(RIGHT_ICON) : new JButton(">");
        addParameterButton.setToolTipText("Select parameters.");
        addParameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.addSelectedParameters();
            }
        });
        JButton removeParameterButton = null;
        removeParameterButton = LEFT_ICON != null ? new JButton(LEFT_ICON) : new JButton("<");
        removeParameterButton.setToolTipText("Deselect parameters.");
        removeParameterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.removeSelectedParameters();
            }
        });
        parameterSelectionButtonsPanel.add((Component)addParameterButton, "North");
        parameterSelectionButtonsPanel.add((Component)removeParameterButton, "South");
        JScrollPane operatorListScrollPane = new JScrollPane(this.operatorList){
            private static final long serialVersionUID = 1103467036573935368L;

            public Dimension getPreferredSize() {
                return new Dimension((int)((double)this.getWidth() * 0.25), super.getPreferredSize().height);
            }
        };
        JScrollPane parametersListScrollPane = new JScrollPane(this.parametersList){
            private static final long serialVersionUID = 8474453689364798720L;

            public Dimension getPreferredSize() {
                return new Dimension((int)((double)this.getWidth() * 0.25), super.getPreferredSize().height);
            }
        };
        JScrollPane selectedParametersListScrollPane = new JScrollPane(this.selectedParametersList){
            private static final long serialVersionUID = -7089596032717082128L;

            public Dimension getPreferredSize() {
                return new Dimension((int)((double)this.getWidth() * 0.25), super.getPreferredSize().height);
            }
        };
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        operatorListScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Operators")));
        selectionPanel.add((Component)operatorListScrollPane, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        parametersListScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Parameters")));
        selectionPanel.add((Component)parametersListScrollPane, c);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 0;
        selectionPanel.add((Component)parameterSelectionButtonsPanel, c);
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        selectedParametersListScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Selected Parameters")));
        selectionPanel.add((Component)selectedParametersListScrollPane, c);
        this.getContentPane().add((Component)selectionPanel, "North");
        JPanel gridPanel = new JPanel(new GridBagLayout());
        gridPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Grid/Range")));
        c.insets = new Insets(0, 10, 2, 10);
        c.gridy = 0;
        c.weightx = 0.25;
        c.gridx = 0;
        this.minValueJLabel = new JLabel("Min");
        this.minValueJLabel.setEnabled(false);
        gridPanel.add((Component)this.minValueJLabel, c);
        c.gridx = 1;
        this.maxValueJLabel = new JLabel("Max");
        this.maxValueJLabel.setEnabled(false);
        gridPanel.add((Component)this.maxValueJLabel, c);
        c.gridx = 2;
        this.stepsValueJLabel = new JLabel("Steps");
        this.stepsValueJLabel.setEnabled(false);
        gridPanel.add((Component)this.stepsValueJLabel, c);
        c.gridx = 3;
        this.gridScaleValueJLabel = new JLabel("Scale");
        this.gridScaleValueJLabel.setEnabled(false);
        gridPanel.add((Component)this.gridScaleValueJLabel, c);
        this.minValueTextField = new JFormattedTextField();
        this.minValueTextField.setText(Double.valueOf(0.0).toString());
        this.minValueTextField.setToolTipText("Minimum value of grid or range.");
        this.minValueTextField.setEnabled(false);
        this.minValueTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
            }
        });
        this.minValueTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
                ConfigureParameterOptimizationDialog.this.minValueTextField.transferFocus();
            }
        });
        c.insets = new Insets(2, 10, 7, 10);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        gridPanel.add((Component)this.minValueTextField, c);
        this.maxValueTextField = new JFormattedTextField();
        this.maxValueTextField.setText(Double.valueOf(0.0).toString());
        this.maxValueTextField.setToolTipText("Maximum value of grid or range.");
        this.maxValueTextField.setEnabled(false);
        this.maxValueTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
            }
        });
        this.maxValueTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
                ConfigureParameterOptimizationDialog.this.maxValueTextField.transferFocus();
            }
        });
        c.gridx = 1;
        c.fill = 1;
        gridPanel.add((Component)this.maxValueTextField, c);
        this.stepsValueTextField = new JFormattedTextField();
        this.stepsValueTextField.setText(Integer.valueOf(0).toString());
        this.stepsValueTextField.setToolTipText("Number of steps in grid.");
        this.stepsValueTextField.setEnabled(false);
        this.stepsValueTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
            }
        });
        this.stepsValueTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
                ConfigureParameterOptimizationDialog.this.stepsValueTextField.transferFocus();
            }
        });
        c.gridx = 2;
        c.fill = 1;
        gridPanel.add((Component)this.stepsValueTextField, c);
        this.gridScaleValueComboBox = this.mode == 0 ? new JComboBox<String>(ParameterValueGrid.SCALES) : new JComboBox();
        this.gridScaleValueComboBox.setToolTipText("Grid scheme.");
        this.gridScaleValueComboBox.setEnabled(false);
        this.gridScaleValueComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.updateSelectedNumericalParameterValues();
            }
        });
        c.gridx = 3;
        c.fill = 2;
        gridPanel.add((Component)this.gridScaleValueComboBox, c);
        JPanel listPanel = new JPanel(new GridBagLayout());
        listPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Value List")));
        this.categoriesListModel = new DefaultListModel();
        this.selectedCategoriesListModel = new DefaultListModel();
        this.createValueTextField = new JTextField();
        this.createValueTextField.setToolTipText("Type in a new value here.");
        this.createValueTextField.setEnabled(false);
        this.createValueTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.createListValue();
            }
        });
        c.insets = new Insets(2, 10, 7, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.475;
        c.weighty = 0.0;
        c.fill = 1;
        listPanel.add((Component)this.createValueTextField, c);
        this.categoriesList = new JList(this.categoriesListModel);
        this.categoriesList.setToolTipText("Available (or predefined) values.");
        this.categoriesList.setEnabled(false);
        c.insets = new Insets(2, 10, 7, 0);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.475;
        c.weighty = 1.0;
        c.fill = 1;
        listPanel.add((Component)new JScrollPane(this.categoriesList), c);
        this.createValueButton = ADD_ICON != null ? new JButton(ADD_ICON) : new JButton("+");
        this.createValueButton.setToolTipText("Add a new value.");
        this.createValueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.createListValue();
            }
        });
        this.createValueButton.setEnabled(false);
        c.insets = new Insets(2, 7, 7, 7);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        listPanel.add((Component)this.createValueButton, c);
        JPanel valueSelectionButtonsPanel = new JPanel(new BorderLayout());
        this.addValueButton = RIGHT_ICON != null ? new JButton(RIGHT_ICON) : new JButton(">");
        this.addValueButton.setToolTipText("Select value from list of available values.");
        this.addValueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selectedParameter = (String)ConfigureParameterOptimizationDialog.this.selectedParametersListModel.get(ConfigureParameterOptimizationDialog.this.selectedParametersList.getLeadSelectionIndex());
                Object[] selectedValues = ConfigureParameterOptimizationDialog.this.categoriesList.getSelectedValues();
                int i = 0;
                while (i < selectedValues.length) {
                    ConfigureParameterOptimizationDialog.this.categoriesListModel.removeElement(selectedValues[i]);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.addElement(selectedValues[i]);
                    ParameterValues parameterValue = (ParameterValues)ConfigureParameterOptimizationDialog.this.parameterValuesMap.get(selectedParameter);
                    if (parameterValue instanceof ParameterValueList) {
                        ((ParameterValueList)parameterValue).add((String)selectedValues[i]);
                    }
                    ++i;
                }
                ConfigureParameterOptimizationDialog.this.updateInfoLabel();
            }
        });
        this.addValueButton.setEnabled(false);
        this.removeValueButton = LEFT_ICON != null ? new JButton(LEFT_ICON) : new JButton("<");
        this.removeValueButton.setToolTipText("Remove value from selection.");
        this.removeValueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selectedParameter = (String)ConfigureParameterOptimizationDialog.this.selectedParametersListModel.get(ConfigureParameterOptimizationDialog.this.selectedParametersList.getLeadSelectionIndex());
                Object[] selectedValues = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedValues();
                int i = 0;
                while (i < selectedValues.length) {
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.removeElement(selectedValues[i]);
                    ParameterValues parameterValue = (ParameterValues)ConfigureParameterOptimizationDialog.this.parameterValuesMap.get(selectedParameter);
                    if (parameterValue instanceof ParameterValueList && ((ParameterValueList)parameterValue).contains((String)selectedValues[i])) {
                        ConfigureParameterOptimizationDialog.this.categoriesListModel.addElement(selectedValues[i]);
                        ((ParameterValueList)parameterValue).remove((String)selectedValues[i]);
                    }
                    ++i;
                }
                ConfigureParameterOptimizationDialog.this.updateInfoLabel();
            }
        });
        this.removeValueButton.setEnabled(false);
        valueSelectionButtonsPanel.add((Component)this.addValueButton, "Center");
        valueSelectionButtonsPanel.add((Component)this.removeValueButton, "South");
        c.insets = new Insets(2, 7, 7, 7);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridheight = 2;
        c.fill = 0;
        listPanel.add((Component)valueSelectionButtonsPanel, c);
        this.selectedCategoriesList = new JList(this.selectedCategoriesListModel);
        this.selectedCategoriesList.setToolTipText("Selected values.");
        this.selectedCategoriesList.setEnabled(false);
        c.insets = new Insets(2, 0, 7, 0);
        c.gridx = 2;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 0.475;
        c.fill = 1;
        listPanel.add((Component)new JScrollPane(this.selectedCategoriesList), c);
        JPanel valueMovingButtonsPanel = new JPanel(new BorderLayout());
        this.upListButton = UP_ICON != null ? new JButton(UP_ICON) : new JButton("Up");
        this.upListButton.setToolTipText("Move the selected value up in the list.");
        this.upListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex;
                Object selectedValue;
                ParameterValues parameterValue;
                String selectedParameter = (String)ConfigureParameterOptimizationDialog.this.selectedParametersListModel.get(ConfigureParameterOptimizationDialog.this.selectedParametersList.getLeadSelectionIndex());
                int[] selectedIndices = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedIndices();
                if (selectedIndices.length == 1 && (parameterValue = (ParameterValues)ConfigureParameterOptimizationDialog.this.parameterValuesMap.get(selectedParameter)) instanceof ParameterValueList && ((ParameterValueList)parameterValue).contains((String)(selectedValue = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedValue())) && (selectedIndex = selectedIndices[0]) >= 1) {
                    parameterValue.move(selectedIndex, -1);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.remove(selectedIndex);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.add(selectedIndex - 1, selectedValue);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesList.setSelectedIndex(selectedIndex - 1);
                }
            }
        });
        this.upListButton.setEnabled(false);
        this.downListButton = DOWN_ICON != null ? new JButton(DOWN_ICON) : new JButton("Down");
        this.downListButton.setToolTipText("Move the selected value down in the list.");
        this.downListButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex;
                Object selectedValue;
                ParameterValues parameterValue;
                String selectedParameter = (String)ConfigureParameterOptimizationDialog.this.selectedParametersListModel.get(ConfigureParameterOptimizationDialog.this.selectedParametersList.getLeadSelectionIndex());
                int[] selectedIndices = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedIndices();
                if (selectedIndices.length == 1 && (parameterValue = (ParameterValues)ConfigureParameterOptimizationDialog.this.parameterValuesMap.get(selectedParameter)) instanceof ParameterValueList && ((ParameterValueList)parameterValue).contains((String)(selectedValue = ConfigureParameterOptimizationDialog.this.selectedCategoriesList.getSelectedValue())) && (selectedIndex = selectedIndices[0]) < ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.size() - 1) {
                    parameterValue.move(selectedIndex, 1);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.remove(selectedIndex);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesListModel.add(selectedIndex + 1, selectedValue);
                    ConfigureParameterOptimizationDialog.this.selectedCategoriesList.setSelectedIndex(selectedIndex + 1);
                }
            }
        });
        this.downListButton.setEnabled(false);
        valueMovingButtonsPanel.add((Component)this.upListButton, "Center");
        valueMovingButtonsPanel.add((Component)this.downListButton, "South");
        c.insets = new Insets(2, 7, 7, 4);
        c.gridx = 3;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridheight = 2;
        c.fill = 0;
        listPanel.add((Component)valueMovingButtonsPanel, c);
        listPanel.setEnabled(false);
        JPanel valuePanel = new JPanel(new BorderLayout());
        valuePanel.add((Component)gridPanel, "North");
        valuePanel.add((Component)listPanel, "Center");
        this.getContentPane().add((Component)valuePanel, "Center");
        JPanel radioButtonPanel = new JPanel(new FlowLayout(0));
        this.choseGridRadioButton = new JRadioButton("Grid", true);
        this.choseGridRadioButton.setToolTipText("Use a regular grid for numerical parameters.");
        this.choseGridRadioButton.setEnabled(false);
        this.choseGridRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ConfigureParameterOptimizationDialog.this.choseGridRadioButton.isSelected()) {
                    ConfigureParameterOptimizationDialog.this.choseGridRadioButton.setSelected(true);
                    ConfigureParameterOptimizationDialog.this.choseListRadioButton.setSelected(false);
                    ConfigureParameterOptimizationDialog.this.switchToGrid();
                }
            }
        });
        radioButtonPanel.add(this.choseGridRadioButton);
        this.choseListRadioButton = new JRadioButton("List", false);
        this.choseListRadioButton.setToolTipText("Use a list of single values for numerical parameters.");
        this.choseListRadioButton.setEnabled(false);
        this.choseListRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ConfigureParameterOptimizationDialog.this.choseListRadioButton.isSelected()) {
                    ConfigureParameterOptimizationDialog.this.choseListRadioButton.setSelected(true);
                    ConfigureParameterOptimizationDialog.this.choseGridRadioButton.setSelected(false);
                    ConfigureParameterOptimizationDialog.this.switchToList();
                }
            }
        });
        radioButtonPanel.add(this.choseListRadioButton);
        JPanel infoPanel = new JPanel(new FlowLayout(1));
        this.infoLabel = new JLabel();
        infoPanel.add(this.infoLabel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigureParameterOptimizationDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)radioButtonPanel, "West");
        bottomPanel.add((Component)infoPanel, "Center");
        bottomPanel.add((Component)buttonPanel, "East");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setSize(Math.max(640, (int)(0.66 * (double)this.getOwner().getWidth())), Math.max(480, (int)(0.66 * (double)this.getOwner().getHeight())));
        this.setLocationRelativeTo(this.getOwner());
    }

    private void updateInfoLabel() {
        int size = this.parameterValuesMap.size();
        int combinations = 1;
        if (this.mode == 0) {
            for (ParameterValues parameterValues : this.parameterValuesMap.values()) {
                int values = parameterValues.getNumberOfValues();
                combinations *= values == 0 ? 1 : values;
            }
            this.infoLabel.setText(String.valueOf(size) + " parameters / " + combinations + " combinations selected");
        } else {
            this.infoLabel.setText(String.valueOf(size) + " parameters selected");
        }
    }

    private void createListValue() {
        String selectedParameter = (String)this.selectedParametersListModel.get(this.selectedParametersList.getLeadSelectionIndex());
        String createdValue = this.createValueTextField.getText();
        if (createdValue.equals("")) {
            return;
        }
        if (this.selectedCategoriesListModel.contains(createdValue)) {
            return;
        }
        this.selectedCategoriesListModel.addElement(createdValue);
        ParameterValues parameterValue = this.parameterValuesMap.get(selectedParameter);
        if (parameterValue instanceof ParameterValueList) {
            ((ParameterValueList)parameterValue).add(createdValue);
        }
        if (this.categoriesListModel.contains(createdValue)) {
            this.categoriesListModel.removeElement(createdValue);
        }
        this.createValueTextField.setText("");
        this.updateInfoLabel();
    }

    private void switchToGrid() {
        ParameterValues oldParameterValues;
        String key = (String)this.selectedParametersList.getSelectedValue();
        if (key != null && (oldParameterValues = this.parameterValuesMap.get(key)) instanceof ParameterValueList) {
            ParameterValues newParameterValues = this.createNumericalParameterValues(oldParameterValues.getOperator(), oldParameterValues.getParameterType());
            this.parameterValuesMap.put(key, newParameterValues);
            this.fillComponents(newParameterValues);
        }
        this.minValueJLabel.setEnabled(true);
        this.maxValueJLabel.setEnabled(true);
        this.stepsValueJLabel.setEnabled(true);
        this.gridScaleValueJLabel.setEnabled(true);
        this.minValueTextField.setEnabled(true);
        this.maxValueTextField.setEnabled(true);
        this.stepsValueTextField.setEnabled(true);
        this.gridScaleValueComboBox.setEnabled(true);
        this.categoriesList.setEnabled(false);
        this.selectedCategoriesList.setEnabled(false);
        this.addValueButton.setEnabled(false);
        this.removeValueButton.setEnabled(false);
        this.createValueButton.setEnabled(false);
        this.createValueTextField.setEnabled(false);
        this.upListButton.setEnabled(false);
        this.downListButton.setEnabled(false);
        this.updateInfoLabel();
    }

    private void switchToList() {
        ParameterValues oldParameterValues;
        String key = (String)this.selectedParametersList.getSelectedValue();
        if (key != null && (oldParameterValues = this.parameterValuesMap.get(key)) instanceof ParameterValueGrid) {
            ParameterValueList newParameterValues = new ParameterValueList(oldParameterValues.getOperator(), oldParameterValues.getParameterType());
            this.parameterValuesMap.put(key, newParameterValues);
            this.fillComponents(newParameterValues);
        }
        this.minValueJLabel.setEnabled(false);
        this.maxValueJLabel.setEnabled(false);
        this.stepsValueJLabel.setEnabled(false);
        this.gridScaleValueJLabel.setEnabled(false);
        this.minValueTextField.setEnabled(false);
        this.maxValueTextField.setEnabled(false);
        this.stepsValueTextField.setEnabled(false);
        this.gridScaleValueComboBox.setEnabled(false);
        this.categoriesList.setEnabled(true);
        this.selectedCategoriesList.setEnabled(true);
        this.addValueButton.setEnabled(true);
        this.removeValueButton.setEnabled(true);
        this.createValueButton.setEnabled(true);
        this.createValueTextField.setEnabled(true);
        this.upListButton.setEnabled(true);
        this.downListButton.setEnabled(true);
        this.updateInfoLabel();
    }

    private void updateParameterListModel(Operator operator) {
        this.parametersListModel.removeAllElements();
        List<ParameterType> parameters = operator.getParameterTypes();
        for (ParameterType parameter : parameters) {
            if (this.mode == 1 && !(parameter instanceof ParameterTypeNumber) || this.parameterValuesMap.containsKey(String.valueOf(operator.getName()) + "." + parameter.getKey())) continue;
            this.parametersListModel.addElement(parameter.getKey(), parameter.getDescription());
            if (parameter.isNumerical() || parameter instanceof ParameterTypeCategory || parameter instanceof ParameterTypeStringCategory || parameter instanceof ParameterTypeString || parameter instanceof ParameterTypeBoolean || parameter instanceof ParameterTypeFile) continue;
            this.parametersListModel.setEnabled(parameter.getKey(), false);
        }
    }

    private void addSelectedParameters() {
        Object[] parameterKeys = this.parametersList.getSelectedValues();
        Operator operator = (Operator)this.operatorList.getSelectedValue();
        int i = 0;
        while (i < parameterKeys.length) {
            String parameterKey = (String)parameterKeys[i];
            ParameterType type = operator.getParameterType(parameterKey);
            ParameterValues parameterValue = null;
            if (type.isNumerical()) {
                parameterValue = this.createNumericalParameterValues(operator, type);
            } else if (type instanceof ParameterTypeCategory || type instanceof ParameterTypeStringCategory || type instanceof ParameterTypeString || type instanceof ParameterTypeBoolean || type instanceof ParameterTypeFile) {
                parameterValue = new ParameterValueList(operator, type, this.getDefaultListParameterValues(type));
            }
            if (parameterValue != null) {
                this.addParameter(parameterValue);
            }
            ++i;
        }
        this.updateInfoLabel();
    }

    private void addParameter(ParameterValues parameterValue) {
        String key = parameterValue.getKey();
        this.parameterValuesMap.put(key, parameterValue);
        this.selectedParametersListModel.addElement(key, parameterValue.getParameterType().getDescription());
        this.parametersListModel.removeElement(parameterValue.getParameterType().getKey());
    }

    private void removeSelectedParameters() {
        Object[] selectedParameters = this.selectedParametersList.getSelectedValues();
        int i = 0;
        while (i < selectedParameters.length) {
            Operator op;
            String operatorName = ((String)selectedParameters[i]).substring(0, ((String)selectedParameters[i]).indexOf("."));
            this.selectedParametersListModel.removeElement(selectedParameters[i]);
            this.parameterValuesMap.remove(selectedParameters[i]);
            int index = this.operatorList.getSelectedIndex();
            if (index != -1 && (op = (Operator)this.operatorList.getModel().getElementAt(index)) == this.process.getOperator(operatorName)) {
                this.updateParameterListModel(op);
            }
            ++i;
        }
        this.updateInfoLabel();
    }

    private void enableComponents(ParameterValues parameterValue) {
        this.minValueJLabel.setEnabled(false);
        this.maxValueJLabel.setEnabled(false);
        this.stepsValueJLabel.setEnabled(false);
        this.gridScaleValueJLabel.setEnabled(false);
        this.minValueTextField.setEnabled(false);
        this.maxValueTextField.setEnabled(false);
        this.stepsValueTextField.setEnabled(false);
        this.gridScaleValueComboBox.setEnabled(false);
        this.categoriesList.setEnabled(false);
        this.selectedCategoriesList.setEnabled(false);
        this.addValueButton.setEnabled(false);
        this.removeValueButton.setEnabled(false);
        this.createValueButton.setEnabled(false);
        this.createValueTextField.setEnabled(false);
        this.upListButton.setEnabled(false);
        this.downListButton.setEnabled(false);
        this.choseGridRadioButton.setEnabled(false);
        this.choseListRadioButton.setEnabled(false);
        if (parameterValue != null) {
            ParameterType type = parameterValue.getParameterType();
            if (type instanceof ParameterTypeBoolean || type instanceof ParameterTypeCategory) {
                this.categoriesList.setEnabled(true);
                this.selectedCategoriesList.setEnabled(true);
                this.addValueButton.setEnabled(true);
                this.removeValueButton.setEnabled(true);
                this.upListButton.setEnabled(true);
                this.downListButton.setEnabled(true);
            } else if (type instanceof ParameterTypeNumber) {
                if (!(parameterValue instanceof ParameterValueRange)) {
                    this.choseGridRadioButton.setEnabled(true);
                    this.choseListRadioButton.setEnabled(true);
                }
                if (parameterValue instanceof ParameterValueList) {
                    this.categoriesList.setEnabled(true);
                    this.selectedCategoriesList.setEnabled(true);
                    this.addValueButton.setEnabled(true);
                    this.removeValueButton.setEnabled(true);
                    this.createValueTextField.setEnabled(true);
                    this.createValueButton.setEnabled(true);
                    this.choseGridRadioButton.setSelected(false);
                    this.choseListRadioButton.setSelected(true);
                    this.upListButton.setEnabled(true);
                    this.downListButton.setEnabled(true);
                } else {
                    this.minValueJLabel.setEnabled(true);
                    this.maxValueJLabel.setEnabled(true);
                    this.minValueTextField.setEnabled(true);
                    this.maxValueTextField.setEnabled(true);
                    if (parameterValue instanceof ParameterValueGrid) {
                        this.stepsValueJLabel.setEnabled(true);
                        this.gridScaleValueJLabel.setEnabled(true);
                        this.stepsValueTextField.setEnabled(true);
                        this.gridScaleValueComboBox.setEnabled(true);
                        this.choseGridRadioButton.setSelected(true);
                        this.choseListRadioButton.setSelected(false);
                    }
                }
            } else if (type instanceof ParameterTypeString || type instanceof ParameterTypeStringCategory || type instanceof ParameterTypeValue || type instanceof ParameterTypeFile) {
                this.categoriesList.setEnabled(true);
                this.selectedCategoriesList.setEnabled(true);
                this.createValueButton.setEnabled(true);
                this.createValueTextField.setEnabled(true);
                this.addValueButton.setEnabled(true);
                this.removeValueButton.setEnabled(true);
                this.upListButton.setEnabled(true);
                this.downListButton.setEnabled(true);
            }
        }
    }

    private void showGridValues(ParameterValueGrid parameterValueGrid) {
        this.selectedCategoriesListModel.removeAllElements();
        double[] gridValues = parameterValueGrid.getValues();
        int i = 0;
        while (i < gridValues.length) {
            this.selectedCategoriesListModel.addElement(Tools.formatIntegerIfPossible(gridValues[i]));
            ++i;
        }
    }

    private void fillComponents(ParameterValues parameterValue) {
        this.categoriesListModel.removeAllElements();
        this.selectedCategoriesListModel.removeAllElements();
        if (parameterValue instanceof ParameterValueRange) {
            ParameterValueRange parameterValueRange = (ParameterValueRange)parameterValue;
            this.minValueTextField.setText(Double.valueOf(parameterValueRange.getMin()).toString());
            this.maxValueTextField.setText(Double.valueOf(parameterValueRange.getMax()).toString());
        } else if (parameterValue instanceof ParameterValueGrid) {
            ParameterValueGrid parameterValueGrid = (ParameterValueGrid)parameterValue;
            this.minValueTextField.setText(Double.valueOf(parameterValueGrid.getMin()).toString());
            this.maxValueTextField.setText(Double.valueOf(parameterValueGrid.getMax()).toString());
            this.stepsValueTextField.setText(Integer.valueOf(parameterValueGrid.getSteps()).toString());
            this.gridScaleValueComboBox.setSelectedIndex(parameterValueGrid.getScale());
            this.showGridValues(parameterValueGrid);
        } else if (parameterValue instanceof ParameterValueList) {
            ParameterValueList parameterValueList = (ParameterValueList)parameterValue;
            ParameterType type = parameterValueList.getParameterType();
            for (Object value : parameterValueList) {
                this.selectedCategoriesListModel.addElement(value);
            }
            String[] categories = this.getDefaultListParameterValues(type);
            if (categories != null) {
                int i = 0;
                while (i < categories.length) {
                    if (!parameterValueList.contains(categories[i])) {
                        this.categoriesListModel.addElement(categories[i]);
                    }
                    ++i;
                }
            }
        }
    }

    private void showParameterValues(String key) {
        if (key == null) {
            this.enableComponents(null);
            return;
        }
        ParameterValues parameterValues = this.parameterValuesMap.get(key);
        this.fillComponents(parameterValues);
        this.enableComponents(parameterValues);
    }

    private void updateSelectedNumericalParameterValues() {
        int index = this.selectedParametersList.getSelectedIndex();
        if (index == -1) {
            this.enableComponents(null);
            return;
        }
        String key = (String)this.selectedParametersListModel.get(index);
        ParameterValues parameterValues = this.parameterValuesMap.get(key);
        if (parameterValues != null) {
            if (parameterValues instanceof ParameterValueGrid) {
                ParameterValueGrid parameterValueGrid = (ParameterValueGrid)parameterValues;
                try {
                    parameterValueGrid.setMin(Double.parseDouble(this.minValueTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    parameterValueGrid.setMax(Double.parseDouble(this.maxValueTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    parameterValueGrid.setSteps(Integer.parseInt(this.stepsValueTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                parameterValueGrid.setScale(this.gridScaleValueComboBox.getSelectedIndex());
                this.showGridValues(parameterValueGrid);
            }
            if (parameterValues instanceof ParameterValueRange) {
                ParameterValueRange parameterValueRange = (ParameterValueRange)parameterValues;
                try {
                    parameterValueRange.setMin(Double.parseDouble(this.minValueTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    parameterValueRange.setMax(Double.parseDouble(this.maxValueTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.updateInfoLabel();
    }

    private ParameterValues createNumericalParameterValues(Operator operator, ParameterType type) {
        double min = ((ParameterTypeNumber)type).getMinValue();
        double max = ((ParameterTypeNumber)type).getMaxValue();
        if (this.mode == 0) {
            return new ParameterValueGrid(operator, type, min, max);
        }
        return new ParameterValueRange(operator, type, min, max);
    }

    private String[] getDefaultListParameterValues(ParameterType type) {
        if (type instanceof ParameterTypeCategory) {
            return ((ParameterTypeCategory)type).getValues();
        }
        if (type instanceof ParameterTypeStringCategory) {
            return ((ParameterTypeStringCategory)type).getValues();
        }
        if (type instanceof ParameterTypeBoolean) {
            return new String[]{"true", "false"};
        }
        return new String[0];
    }

    private void ok() {
        this.ok = true;
        LinkedList<String[]> parameterList = new LinkedList<String[]>();
        for (String key : this.parameterValuesMap.keySet()) {
            String value = this.parameterValuesMap.get(key).getValuesString();
            parameterList.add(new String[]{key, value});
        }
        Parameters parameters = this.listener.getParameters();
        parameters.setParameter("parameters", Parameters.transformList2String(parameterList));
        this.listener.setParameters(parameters);
        this.dispose();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }
}

