/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.condition;

import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.tools.Tools;

public class LastInnerOperatorCondition
implements InnerOperatorCondition {
    private Class[] mustDeliver;
    private Class[] willGet;
    private boolean allowEmptyChains = false;

    public LastInnerOperatorCondition(Class[] mustDeliver) {
        this(null, mustDeliver);
    }

    public LastInnerOperatorCondition(Class[] willGet, Class[] mustDeliver) {
        this(willGet, mustDeliver, false);
    }

    public LastInnerOperatorCondition(Class[] willGet, Class[] mustDeliver, boolean allowEmptyChains) {
        this.willGet = willGet;
        this.mustDeliver = mustDeliver;
        this.allowEmptyChains = allowEmptyChains;
    }

    public Class[] checkIO(OperatorChain chain, Class[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (!this.allowEmptyChains && chain.getNumberOfOperators() == 0) {
            throw new WrongNumberOfInnerOperatorsException(chain, chain.getMinNumberOfInnerOperators(), chain.getMaxNumberOfInnerOperators(), 0);
        }
        Class[] output = input;
        if (this.willGet != null) {
            output = new Class[input.length + this.willGet.length];
            System.arraycopy(input, 0, output, 0, input.length);
            System.arraycopy(this.willGet, 0, output, input.length, this.willGet.length);
        }
        int i = 0;
        while (i < chain.getNumberOfOperators()) {
            Operator operator = chain.getOperator(i);
            if (operator.isEnabled()) {
                output = operator.checkIO(output);
            }
            ++i;
        }
        i = 0;
        while (i < this.mustDeliver.length) {
            if (!DefaultIODescription.containsClass(this.mustDeliver[i], output)) {
                throw new IllegalInputException(chain, chain.getOperator(chain.getNumberOfOperators() - 1), this.mustDeliver[i]);
            }
            ++i;
        }
        return output;
    }

    public String toHTML() {
        int i;
        StringBuffer result = new StringBuffer("The inner operators ");
        if (this.willGet != null) {
            result.append("must be able to handle [");
            i = 0;
            while (i < this.willGet.length) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(Tools.classNameWOPackage(this.willGet[i]));
                ++i;
            }
            result.append("]");
            if (this.mustDeliver != null) {
                result.append(" and ");
            } else {
                result.append(".");
            }
        }
        if (this.mustDeliver != null) {
            result.append("must deliver [");
            i = 0;
            while (i < this.mustDeliver.length) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(Tools.classNameWOPackage(this.mustDeliver[i]));
                ++i;
            }
            result.append("].");
        }
        return result.toString();
    }
}

