/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.selection.AbstractFeatureSelection;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveUselessFeatures
extends AbstractFeatureSelection {
    public static final String PARAMETER_NUMERICAL_MIN_DEVIATION = "numerical_min_deviation";
    public static final String PARAMETER_NOMINAL_SINGLE_VALUE_UPPER = "nominal_single_value_upper";
    public static final String PARAMETER_NOMINAL_SINGLE_VALUE_LOWER = "nominal_single_value_lower";

    public RemoveUselessFeatures(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        ExampleSet clone = (ExampleSet)exampleSet.clone();
        clone.recalculateAllAttributeStatistics();
        double numericalMinDeviation = this.getParameterAsDouble(PARAMETER_NUMERICAL_MIN_DEVIATION);
        double nominalSingleValueUpper = this.getParameterAsDouble(PARAMETER_NOMINAL_SINGLE_VALUE_UPPER);
        double nominalSingleValueLower = this.getParameterAsDouble(PARAMETER_NOMINAL_SINGLE_VALUE_LOWER);
        if (nominalSingleValueLower < 0.0) {
            nominalSingleValueLower = 1.0 / (double)clone.size();
        }
        Iterator<Attribute> i = clone.getAttributes().iterator();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            if (attribute.isNominal()) {
                List<String> values = attribute.getMapping().getValues();
                double[] valueCounts = new double[values.size()];
                Iterator v = values.iterator();
                int n = 0;
                while (v.hasNext()) {
                    String value = (String)v.next();
                    valueCounts[n] = clone.getStatistics(attribute, "count", value);
                    ++n;
                }
                if (clone.getStatistics(attribute, "unknown") / (double)clone.size() >= nominalSingleValueUpper) {
                    i.remove();
                    continue;
                }
                double maximumValueCount = Double.NEGATIVE_INFINITY;
                n = 0;
                while (n < valueCounts.length) {
                    double percent = valueCounts[n] / (double)clone.size();
                    maximumValueCount = Math.max(maximumValueCount, percent);
                    if (percent >= nominalSingleValueUpper) {
                        i.remove();
                        break;
                    }
                    ++n;
                }
                if (maximumValueCount <= nominalSingleValueLower) {
                    i.remove();
                    continue;
                }
            } else if (attribute.isNumerical()) {
                if (clone.getStatistics(attribute, "unknown") / (double)clone.size() >= nominalSingleValueUpper) {
                    i.remove();
                    continue;
                }
                if (Math.sqrt(clone.getStatistics(attribute, "variance")) <= numericalMinDeviation) {
                    i.remove();
                }
            } else {
                this.log("Attribute '" + attribute.getName() + "' is not numerical and not nominal, do nothing...");
            }
            this.checkForStop();
        }
        if (clone.getAttributes().size() <= 0) {
            this.logWarning("Example set does not not have any attribute after removing the useless attributes!");
        }
        return clone;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_NUMERICAL_MIN_DEVIATION, "Removes all numerical attributes with standard deviation less or equal to this threshold.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_NOMINAL_SINGLE_VALUE_UPPER, "Removes all nominal attributes which provides more than the given amount of only one value.", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_NOMINAL_SINGLE_VALUE_LOWER, "Removes all nominal attributes which provides less than the given amount of at least one value (-1: remove attributes with values occuring only once).", -1.0, 1.0, -1.0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

