/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.AllInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueSubgroupIteration
extends OperatorChain {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_VALUES = "values";
    public static final String[] VALUE_OPTIONS = new String[]{"all", "above p"};
    public static final int VALUE_OPTION_ALL = 0;
    public static final int VALUE_OPTION_ABOVE_P = 1;
    public static final String PARAMETER_P = "p";
    public static final String PARAMETER_FILTER_ATTRIBUTE = "filter_attribute";
    public static final String PARAMETER_APPLY_ON_COMPLETE_SET = "apply_on_complete_set";
    public static final String PARAMETER_ITERATION_MACRO = "iteration_macro";
    public static final String DEFAULT_ITERATION_MACRO_NAME = "loop_value";

    public ValueSubgroupIteration(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        exampleSet.recalculateAllAttributeStatistics();
        IOContainer innerResult = new IOContainer(new IOObject[0]);
        List<String[]> attributeValueOptions = this.getParameterList(PARAMETER_ATTRIBUTES);
        LinkedHashMap<Attribute, Integer> attributeValueOptionsMap = new LinkedHashMap<Attribute, Integer>();
        int[] valueOptions = new int[attributeValueOptions.size()];
        Pattern[] attributeRegexPatterns = new Pattern[attributeValueOptions.size()];
        Attribute[] attributes = new Attribute[attributeValueOptions.size()];
        Iterator<String[]> iterator = attributeValueOptions.iterator();
        int j = 0;
        while (iterator.hasNext()) {
            String[] pair = iterator.next();
            String regex = pair[0];
            try {
                attributeRegexPatterns[j] = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new UserError((Operator)this, 206, regex, e.getMessage());
            }
            attributes[j] = exampleSet.getAttributes().get(pair[0]);
            valueOptions[j] = ((ParameterTypeCategory)((ParameterTypeList)this.getParameterType(PARAMETER_ATTRIBUTES)).getValueType()).getIndex(pair[1]);
            ++j;
        }
        int i = 0;
        while (i < attributeRegexPatterns.length) {
            Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
            while (a.hasNext()) {
                Attribute attribute = a.next();
                Matcher matcher = attributeRegexPatterns[i].matcher(attribute.getName());
                if (!matcher.matches()) continue;
                attributeValueOptionsMap.put(attribute, valueOptions[i]);
            }
            ++i;
        }
        double p = this.getParameterAsDouble(PARAMETER_P);
        boolean filterAttribute = this.getParameterAsBoolean(PARAMETER_FILTER_ATTRIBUTE);
        String iterationMacro = this.getParameterAsString(PARAMETER_ITERATION_MACRO);
        if (this.getParameterAsBoolean(PARAMETER_APPLY_ON_COMPLETE_SET)) {
            if (iterationMacro != null) {
                this.getProcess().getMacroHandler().addMacro(iterationMacro, "ALL");
            }
            IOContainer input = new IOContainer(exampleSet);
            Iterator<Operator> opIt = this.getOperators();
            while (opIt.hasNext()) {
                try {
                    input = opIt.next().apply(input);
                }
                catch (ConcurrentModificationException e) {
                    if (this.isDebugMode()) {
                        e.printStackTrace();
                    }
                    throw new UserError(this, 923);
                }
            }
            int k = 0;
            while (k < input.size()) {
                input.getElementAt(k).setSource(String.valueOf(this.getName()) + ":ALL");
                ++k;
            }
            innerResult = innerResult.append(input.getIOObjects());
        }
        for (Attribute attribute : attributeValueOptionsMap.keySet()) {
            if (!attribute.isNominal()) continue;
            List<String> values = null;
            switch ((Integer)attributeValueOptionsMap.get(attribute)) {
                case 0: {
                    values = attribute.getMapping().getValues();
                    break;
                }
                case 1: {
                    values = new Vector<String>();
                    for (String value : attribute.getMapping().getValues()) {
                        if (!(exampleSet.getStatistics(attribute, "count", value) / (double)exampleSet.size() >= p)) continue;
                        values.add(value);
                    }
                    break;
                }
                default: {
                    values = attribute.getMapping().getValues();
                }
            }
            for (String value : values) {
                if (exampleSet.getStatistics(attribute, "count", value) > 0.0) {
                    String className = "attribute_value_filter";
                    String parameter = String.valueOf(attribute.getName()) + "=" + value;
                    this.log("Creating condition '" + className + "' with parameter '" + parameter + "'");
                    Condition condition = null;
                    try {
                        condition = ConditionedExampleSet.createCondition(className, exampleSet, parameter);
                    }
                    catch (ConditionCreationException e) {
                        throw new UserError((Operator)this, 904, className, e.getMessage());
                    }
                    ConditionedExampleSet subgroupSet = new ConditionedExampleSet(exampleSet, condition, false);
                    if (filterAttribute) {
                        subgroupSet.getAttributes().remove(attribute);
                    }
                    if (iterationMacro != null) {
                        this.getProcess().getMacroHandler().addMacro(iterationMacro, parameter.replace(' ', '_'));
                    }
                    IOContainer input = new IOContainer(subgroupSet);
                    Iterator<Operator> opIt = this.getOperators();
                    while (opIt.hasNext()) {
                        try {
                            input = opIt.next().apply(input);
                        }
                        catch (ConcurrentModificationException e) {
                            if (this.isDebugMode()) {
                                e.printStackTrace();
                            }
                            throw new UserError(this, 923);
                        }
                    }
                    int k = 0;
                    while (k < input.size()) {
                        input.getElementAt(k).setSource(String.valueOf(this.getName()) + ":" + parameter);
                        ++k;
                    }
                    innerResult = innerResult.append(input.getIOObjects());
                    if (filterAttribute) {
                        subgroupSet.getAttributes().addRegular(attribute);
                    }
                }
                this.inApplyLoop();
            }
        }
        if (iterationMacro != null) {
            this.getProcess().getMacroHandler().addMacro(iterationMacro, null);
        }
        return innerResult.getIOObjects();
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[0]);
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        Iterator<Operator> i = this.getOperators();
        Operator current = null;
        while (i.hasNext()) {
            current = i.next();
        }
        if (current != null) {
            return current.getOutputClasses();
        }
        return new Class[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeCategory valueOption = new ParameterTypeCategory(PARAMETER_VALUES, "Values.", VALUE_OPTIONS, 0);
        ParameterType type = new ParameterTypeList(PARAMETER_ATTRIBUTES, "The attributes.", valueOption);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P, "Threshold of value occurance.", 0.0, 1.0, 0.2);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_FILTER_ATTRIBUTE, "Filter subgroup defining attribute.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_ON_COMPLETE_SET, "Apply inner operators also on complete set.", false));
        types.add(new ParameterTypeString(PARAMETER_ITERATION_MACRO, "Name of macro which is set in each iteration.", DEFAULT_ITERATION_MACRO_NAME));
        return types;
    }
}

