/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import Jama.Matrix;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTablePairwiseMatrixExtractionAdapter;
import com.rapidminer.datatable.DataTableSymmetricalMatrixAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.tools.CellColorProviderScaled;
import com.rapidminer.gui.tools.ExtendedFixedColumnJTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.viewer.DataTableViewer;
import com.rapidminer.gui.viewer.NumericalMatrixViewerTableModel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class NumericalMatrix
extends ResultObjectAdapter {
    private static final long serialVersionUID = -5498982791125720765L;
    private static final int MAX_NUMBER_OF_RESULT_STRING_ATTRIBUTES = 20;
    private static final String RESULT_ICON_NAME = "table.png";
    private static Icon resultIcon = null;
    private Matrix matrix;
    private String[] columnNames;
    private String[] rowNames;
    private NumberFormat formatter;
    private String name;
    private boolean symmetrical = false;
    private String firstAttributeName = "First Attribute";
    private String secondAttributeName = "Second Attribute";

    static {
        resultIcon = SwingTools.createIcon("16/table.png");
    }

    public NumericalMatrix(String name, String[] columnNames, boolean symmetrical) {
        this(name, columnNames, new Matrix(columnNames.length, columnNames.length), symmetrical);
    }

    public NumericalMatrix(String name, String[] columnNames, Matrix matrix, boolean symmetrical) {
        this.name = name;
        this.formatter = NumberFormat.getInstance();
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setMinimumFractionDigits(3);
        this.columnNames = columnNames;
        this.rowNames = columnNames;
        this.matrix = matrix;
        this.symmetrical = symmetrical;
    }

    public NumericalMatrix(String name, String[] rowNames, String[] columnNames, Matrix matrix) {
        this.name = name;
        this.formatter = NumberFormat.getInstance();
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setMinimumFractionDigits(3);
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        this.matrix = matrix;
        this.symmetrical = false;
    }

    public NumericalMatrix(String name, ExampleSet exampleSet, boolean symmetrical) {
        this(name, NumericalMatrix.getColumnNames(exampleSet), symmetrical);
    }

    public void setFirstAttributeName(String firstAttributeName) {
        this.firstAttributeName = firstAttributeName;
    }

    public void setSecondAttributeName(String secondAttributeName) {
        this.secondAttributeName = secondAttributeName;
    }

    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public String getRowName(int index) {
        return this.rowNames[index];
    }

    private static String[] getColumnNames(ExampleSet exampleSet) {
        String[] attributeNames = new String[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeNames[counter++] = attribute.getName();
        }
        return attributeNames;
    }

    public void setValue(int i, int j, double value) {
        this.matrix.set(i, j, value);
        if (this.symmetrical) {
            this.matrix.set(j, i, value);
        }
    }

    public double getValue(int i, int j) {
        return this.matrix.get(i, j);
    }

    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public int getNumberOfColumns() {
        return this.columnNames.length;
    }

    public int getNumberOfRows() {
        return this.rowNames.length;
    }

    public String getName() {
        return String.valueOf(this.name) + " Matrix";
    }

    public DataTable createMatrixDataTable() {
        return new DataTableSymmetricalMatrixAdapter(this, this.name, this.columnNames);
    }

    public DataTable createPairwiseDataTable() {
        return new DataTablePairwiseMatrixExtractionAdapter(this, this.rowNames, this.columnNames, new String[]{this.firstAttributeName, this.secondAttributeName, this.name});
    }

    public String getExtension() {
        return "mat";
    }

    public String getFileDescription() {
        return String.valueOf(this.name.toLowerCase()) + " matrix";
    }

    public Component getVisualizationComponent(IOContainer container) {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int x = 0;
        while (x < this.getNumberOfRows()) {
            int y = 0;
            while (y < this.getNumberOfColumns()) {
                double value = Math.abs(this.getValue(x, y));
                if (!Double.isNaN(value)) {
                    min = Math.min(min, value);
                    max = Math.max(max, value);
                }
                ++y;
            }
            ++x;
        }
        final ExtendedFixedColumnJTable matrixViewer = ExtendedFixedColumnJTable.createFixedColumnTable(new NumericalMatrixViewerTableModel(this));
        matrixViewer.getMainDataTable().setCellColorProvider(new CellColorProviderScaled(matrixViewer.getMainDataTable(), true, min, max));
        DataTable pairwiseDataTable = this.createPairwiseDataTable();
        final DataTableViewer pairwiseTableViewer = new DataTableViewer(pairwiseDataTable, false);
        pairwiseTableViewer.getTable().setAutoResizeMode(2);
        final PlotterPanel plotterComponent = new PlotterPanel(pairwiseDataTable);
        final JRadioButton matrixButton = new JRadioButton("Matrix View", true);
        matrixButton.setToolTipText("Changes to a table showing the " + this.name.toLowerCase() + ".");
        matrixButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (matrixButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)matrixViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton pairwiseButton = new JRadioButton("Pairwise " + this.name, true);
        pairwiseButton.setToolTipText("Changes to a table showing the " + this.name.toLowerCase() + " for all pairs.");
        pairwiseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (pairwiseButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)pairwiseTableViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("Plot View", false);
        plotButton.setToolTipText("Changes to a plot view of the " + this.name.toLowerCase());
        plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)plotterComponent, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(matrixButton);
        group.add(pairwiseButton);
        group.add(plotButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(matrixButton);
        togglePanel.add(pairwiseButton);
        togglePanel.add(plotButton);
        mainPanel.add((Component)togglePanel, "North");
        mainPanel.add((Component)matrixViewer, "Center");
        return mainPanel;
    }

    public Icon getResultIcon() {
        return resultIcon;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(this.name) + " Matrix (" + this.matrix.getRowDimension() + " rows, " + this.matrix.getColumnDimension() + " columns):" + Tools.getLineSeparator());
        int i = 0;
        while (i < this.columnNames.length) {
            if (i >= 20) {
                result.append("...");
                break;
            }
            result.append("\t" + this.columnNames[i]);
            ++i;
        }
        i = 0;
        while (i < this.matrix.getRowDimension()) {
            if (i >= 20) {
                result.append(String.valueOf(Tools.getLineSeparator()) + "...");
                break;
            }
            result.append(String.valueOf(Tools.getLineSeparator()) + this.columnNames[i]);
            int j = 0;
            while (j < this.matrix.getColumnDimension()) {
                if (j >= 20) {
                    result.append("...");
                    break;
                }
                result.append("\t" + this.formatter.format(this.matrix.get(i, j)));
                ++j;
            }
            ++i;
        }
        return result.toString();
    }
}

