/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.Process;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.parameter.UndefinedParameterError;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class ResultService {
    private static PrintWriter out;
    private static boolean systemStream;

    static {
        systemStream = true;
        out = new PrintWriter(System.out);
    }

    public static void init(String filename, Process process) {
        if (filename == null) {
            process.getLog().log("No filename given for result file, using stdout for logging results!", 4);
            ResultService.init(new PrintWriter(System.out));
        } else if (filename.equals("stderr")) {
            ResultService.init(new PrintWriter(System.err));
        } else if (filename.equals("stdout")) {
            ResultService.init(new PrintWriter(System.out));
        } else {
            PrintWriter out;
            File file = process.resolveFileName(filename);
            Charset encoding = process.getRootOperator().getEncoding();
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            }
            catch (IOException e) {
                process.getLog().log("Cannot create resultfile '" + filename + "': " + e.getClass() + ":" + e.getMessage(), 8);
                process.getLog().log("using stdout", 8);
                out = new PrintWriter(System.out);
            }
            systemStream = false;
            ResultService.init(out);
        }
    }

    public static void init(PrintWriter outWriter) {
        out = outWriter;
    }

    public static void init(Process process) {
        String filename = null;
        try {
            filename = process.getRootOperator().getParameterAsString("resultfile");
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        ResultService.init(filename, process);
    }

    public static void close() {
        if (!systemStream) {
            out.close();
        }
    }

    public static void logResult(String result) {
        ResultService.logResult(result, out);
    }

    public static void logResult(String result, PrintWriter localOut) {
        localOut.println(String.valueOf(ResultService.getTime()) + " " + result);
    }

    public static void logResult(ResultObject resultObject) {
        ResultService.logResult(resultObject, out);
    }

    public static void logResult(ResultObject resultObject, PrintWriter localOut) {
        ResultService.logResult(resultObject.toResultString(), localOut);
    }

    private static String getTime() {
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        String time = String.valueOf(ResultService.getTwoDigits(cal.get(5))) + "." + ResultService.getTwoDigits(cal.get(2) + 1) + "." + cal.get(1) + " " + ResultService.getTwoDigits(cal.get(11)) + ":" + ResultService.getTwoDigits(cal.get(12)) + ":" + ResultService.getTwoDigits(cal.get(13));
        return time;
    }

    static String getTwoDigits(int i) {
        return String.valueOf(i < 10 ? "0" : "") + i;
    }
}

