/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Tools;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTTokenSequence;
import edu.udo.cs.wvtool.util.TokenEnumeration;
import edu.udo.cs.wvtool.util.WVToolException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenSequence
extends ResultObjectAdapter
implements WVTTokenSequence {
    private static final long serialVersionUID = -1513798588906738472L;
    private List<String> tokens = new LinkedList<String>();
    private WVTDocumentInfo docInfo;

    public TokenSequence(TokenSequence seq, boolean copySequence) {
        this.docInfo = seq.getDocumentInfo();
        if (copySequence) {
            this.tokens = new LinkedList<String>(seq.getTokenSequence());
        }
    }

    public TokenSequence(List<String> tokenList, WVTDocumentInfo docInfo) {
        this.tokens = new LinkedList<String>(tokenList);
        this.docInfo = docInfo;
    }

    public TokenSequence(String s, WVTDocumentInfo docInfo) {
        this.tokens.add(s);
        this.docInfo = docInfo;
    }

    public TokenSequence(TokenEnumeration tokenEnum, WVTDocumentInfo docInfo) throws WVToolException {
        while (tokenEnum.hasMoreTokens()) {
            this.addToken(tokenEnum.nextToken());
        }
        this.docInfo = docInfo;
    }

    public void addToken(String s) {
        this.tokens.add(s);
    }

    public List<String> getTokenSequence() {
        return this.tokens;
    }

    public WVTDocumentInfo getDocumentInfo() {
        return this.docInfo;
    }

    public String getExtension() {
        return ".txt";
    }

    public String getFileDescription() {
        return "";
    }

    public Component getVisualizationComponent(IOContainer container) {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        JLabel label = new JLabel("Document: " + this.docInfo.getSourceName());
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
        result.add((Component)label, "North");
        JTextPane textArea = new JTextPane();
        textArea.setEditable(false);
        SimpleAttributeSet attributeSet = new SimpleAttributeSet();
        StyledDocument doc = textArea.getStyledDocument();
        boolean flag = true;
        for (String s : this.tokens) {
            if (flag) {
                StyleConstants.setForeground(attributeSet, new Color(255, 51, 204));
            } else {
                StyleConstants.setForeground(attributeSet, new Color(51, 51, 255));
            }
            flag = !flag;
            try {
                doc.insertString(doc.getLength(), String.valueOf(s) + " ", attributeSet);
            }
            catch (BadLocationException e) {
                SwingTools.showSimpleErrorMessage((String)"Error during logging: ", (Throwable)e);
            }
        }
        textArea.setCaretPosition(0);
        result.add((Component)new ExtendedJScrollPane((Component)textArea), "Center");
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.docInfo.getSourceName());
        buf.append(Tools.getLineSeparator());
        buf.append("number of tokens: " + this.tokens.size());
        return buf.toString();
    }
}

