/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.extraction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.operator.extraction.AttributeQueryMap;
import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.FeatureExtractor;
import com.rapidminer.operator.extraction.TextExtractionWrapper;
import com.rapidminer.operator.extraction.TextExtractor;
import com.rapidminer.operator.extraction.util.NumberParser;
import com.rapidminer.tools.Ontology;
import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFeatureExtractor
implements FeatureExtractor {
    private final AttributeQueryMap aqMap;
    private final WVTConfiguration config;

    public DefaultFeatureExtractor(AttributeQueryMap aqMap, WVTConfiguration config) {
        this.aqMap = aqMap;
        this.config = config;
    }

    @Override
    public void extract(WVTDocumentInfo info, DataRow dr) throws ExtractionException {
        TextExtractionWrapper wrapper = new TextExtractionWrapper(info, this.config, false);
        for (Attribute att : this.aqMap.getAttributes()) {
            TextExtractor query = this.aqMap.getQuery(att);
            String val = this.extractValue(wrapper, query, info);
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(att.getValueType(), 6)) {
                if (val != null) {
                    dr.set(att, (double)att.getMapping().getPositiveIndex());
                    continue;
                }
                dr.set(att, (double)att.getMapping().getNegativeIndex());
                continue;
            }
            if (val != null) {
                if (!att.isNominal()) {
                    double numericalValue = Double.NaN;
                    try {
                        numericalValue = NumberParser.parse(val);
                    }
                    catch (NumberFormatException e1) {
                        numericalValue = Double.NaN;
                    }
                    dr.set(att, numericalValue);
                    continue;
                }
                dr.set(att, (double)att.getMapping().mapString(val));
                continue;
            }
            dr.set(att, Double.NaN);
        }
    }

    private String extractValue(TextExtractionWrapper wrapper, TextExtractor query, WVTDocumentInfo info) throws ExtractionException {
        Iterator<String> values = null;
        values = wrapper.getValues(query);
        if (values != null && values.hasNext()) {
            return values.next();
        }
        return null;
    }

    @Override
    public Collection<Attribute> getAttributes() {
        return this.aqMap.getAttributes();
    }
}

