/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import marytts.cart.DecisionNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.features.FeatureVector;

public class DirectedGraphNode
extends Node {
    private DecisionNode decisionNode;
    private Node leafNode;
    private Map<Node, Integer> motherToIndex = new HashMap<Node, Integer>();
    private List<Node> mothers = new ArrayList<Node>();
    private int uniqueID;

    public DirectedGraphNode(DecisionNode decisionNode, Node leafNode) {
        this.setDecisionNode(decisionNode);
        this.setLeafNode(leafNode);
    }

    public DecisionNode getDecisionNode() {
        return this.decisionNode;
    }

    @Override
    public boolean isDirectedGraphNode() {
        return true;
    }

    public void setDecisionNode(DecisionNode newNode) {
        this.decisionNode = newNode;
        if (newNode != null) {
            newNode.setMother(this, 0);
        }
    }

    public Node getLeafNode() {
        return this.leafNode;
    }

    public void setLeafNode(Node newNode) {
        if (newNode != null && !(newNode instanceof DirectedGraphNode) && !(newNode instanceof LeafNode)) {
            throw new IllegalArgumentException("Only leaf nodes and directed graph nodes allowed as leafNode");
        }
        this.leafNode = newNode;
        if (newNode != null) {
            newNode.setMother(this, 0);
        }
    }

    @Override
    public void setMother(Node node, int nodeIndex) {
        this.mothers.add(node);
        this.motherToIndex.put(node, nodeIndex);
    }

    @Override
    public Node getMother() {
        if (this.mothers.isEmpty()) {
            return null;
        }
        return this.mothers.get(0);
    }

    @Override
    public int getNodeIndex() {
        Node firstMother = this.getMother();
        if (firstMother != null) {
            return this.motherToIndex.get(firstMother);
        }
        return 0;
    }

    public List<Node> getMothers() {
        return this.mothers;
    }

    public int getNodeIndex(Node aMother) {
        if (!this.motherToIndex.containsKey(aMother)) {
            throw new IllegalArgumentException("The given node is not a mother of this node");
        }
        return this.motherToIndex.get(aMother);
    }

    public void removeMother(Node aMother) {
        if (!this.motherToIndex.containsKey(aMother)) {
            throw new IllegalArgumentException("The given node is not a mother of this node");
        }
        this.motherToIndex.remove(aMother);
        this.mothers.remove(aMother);
    }

    @Override
    protected void fillData(Object target, int pos, int len) {
        if (this.leafNode != null) {
            this.leafNode.fillData(target, pos, len);
        }
    }

    @Override
    public Object getAllData() {
        if (this.leafNode != null) {
            return this.leafNode.getAllData();
        }
        if (this.decisionNode != null) {
            return this.decisionNode.getAllData();
        }
        return null;
    }

    @Override
    public int getNumberOfData() {
        if (this.leafNode != null) {
            return this.leafNode.getNumberOfData();
        }
        if (this.decisionNode != null) {
            return this.decisionNode.getNumberOfData();
        }
        return 0;
    }

    @Override
    public int getNumberOfNodes() {
        if (this.decisionNode != null) {
            return this.decisionNode.getNumberOfNodes();
        }
        return 0;
    }

    public Node getNextNode(FeatureVector fv) {
        Node next;
        if (this.decisionNode != null && (next = this.decisionNode.getNextNode(fv)) != null) {
            return next;
        }
        return this.leafNode;
    }

    public int getUniqueGraphNodeID() {
        return this.uniqueID;
    }

    public void setUniqueGraphNodeID(int id) {
        this.uniqueID = id;
    }

    @Override
    public String getDecisionPath() {
        StringBuilder ancestorInfo = new StringBuilder();
        if (this.getMothers().size() == 0) {
            ancestorInfo.append("null");
        }
        for (Node mum : this.getMothers()) {
            if (ancestorInfo.length() > 0) {
                ancestorInfo.append(" or\n");
            }
            if (mum.isDecisionNode()) {
                ancestorInfo.append(((DecisionNode)mum).getDecisionPath(this.getNodeIndex()));
                continue;
            }
            ancestorInfo.append(mum.getDecisionPath());
        }
        return ancestorInfo + " - " + this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DGN");
        sb.append(this.uniqueID);
        if (this.motherToIndex.size() > 1) {
            sb.append(" (").append(this.motherToIndex.size()).append(" mothers)");
        }
        return sb.toString();
    }
}

