/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.smoothing;

import marytts.signalproc.window.DynamicWindow;

public class TemporalSmoother {
    public static final int DEFAULT_NUM_NEIGHBOURS = 4;
    public static final int DEFAULT_SMOOTHING_WINDOW = 1;

    public static double[] smooth(double[] x, int neighbours) {
        return TemporalSmoother.smooth(x, neighbours, 1);
    }

    public static double[] smooth(double[] x, int neighbours, int windowType) {
        int i;
        double[][] xx = new double[x.length][1];
        for (i = 0; i < x.length; ++i) {
            xx[i][0] = x[i];
        }
        xx = TemporalSmoother.smooth(xx, neighbours, windowType);
        double[] y = new double[x.length];
        for (i = 0; i < x.length; ++i) {
            y[i] = xx[i][0];
        }
        return y;
    }

    public static double[][] smooth(double[][] x, int neighbours) {
        return TemporalSmoother.smooth(x, neighbours, 1);
    }

    public static double[][] smooth(double[][] x, int neighbours, int windowType) {
        int i;
        if (neighbours <= 0) {
            return x;
        }
        double[][] y = new double[x.length][x[0].length];
        int windowSize = 2 * neighbours + 1;
        DynamicWindow w = new DynamicWindow(windowType);
        double[] weights = w.values(windowSize);
        for (i = 1; i < x.length; ++i) {
            assert (x[i].length == x[0].length);
        }
        for (i = 0; i < x[0].length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                y[j][i] = 0.0;
                double weightSum = 0.0;
                for (int k = -neighbours; k <= neighbours; ++k) {
                    if (j + k < 0 || j + k >= x.length) continue;
                    double[] dArray = y[j];
                    int n = i;
                    dArray[n] = dArray[n] + weights[k + neighbours] * x[j + k][i];
                    weightSum += weights[k + neighbours];
                }
                if (!(weightSum > 0.0)) continue;
                double[] dArray = y[j];
                int n = i;
                dArray[n] = dArray[n] / weightSum;
            }
        }
        return y;
    }

    public static void main(String[] args) {
        double[][] xx = new double[10][2];
        xx[0][0] = 100.0;
        xx[0][1] = 220.0;
        xx[1][0] = 110.0;
        xx[1][1] = 210.0;
        xx[2][0] = 150.0;
        xx[2][1] = 230.0;
        xx[3][0] = 90.0;
        xx[3][1] = 220.0;
        xx[4][0] = 80.0;
        xx[4][1] = 250.0;
        xx[5][0] = 120.0;
        xx[5][1] = 260.0;
        xx[6][0] = 140.0;
        xx[6][1] = 290.0;
        xx[7][0] = 180.0;
        xx[7][1] = 300.0;
        xx[8][0] = 150.0;
        xx[8][1] = 340.0;
        xx[9][0] = 120.0;
        xx[9][1] = 320.0;
        double[][] y = TemporalSmoother.smooth(xx, 3);
        System.out.println("Finished");
    }
}

