/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.util.Arrays;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.FrameProvider;
import marytts.signalproc.process.InlineFrameMerger;
import marytts.signalproc.process.PitchFrameProvider;
import marytts.signalproc.window.DynamicTwoHalvesWindow;
import marytts.signalproc.window.Window;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.SequenceDoubleDataSource;

public class FramewiseMerger
extends FrameOverlapAddSource {
    protected DoubleDataSource labelTimes;
    protected DoubleDataSource otherLabelTimes;
    protected FrameProvider otherFrameProvider;
    protected double prevLabel;
    protected double currentLabel;
    protected double prevOtherLabel;
    protected double currentOtherLabel;
    protected double localTimeStretchFactor = 1.0;

    public FramewiseMerger(DoubleDataSource inputSource, DoubleDataSource pitchmarks, int samplingRate, DoubleDataSource labelTimes, DoubleDataSource otherSource, DoubleDataSource otherPitchmarks, int otherSamplingRate, DoubleDataSource otherLabelTimes, InlineFrameMerger merger) {
        this.labelTimes = labelTimes;
        this.otherLabelTimes = otherLabelTimes;
        this.prevLabel = 0.0;
        this.currentLabel = 0.0;
        this.prevOtherLabel = 0.0;
        this.currentOtherLabel = 0.0;
        DynamicTwoHalvesWindow analysisWindow = new DynamicTwoHalvesWindow(3, 0.5);
        double firstPitchmark = pitchmarks.getData(1)[0];
        assert (firstPitchmark > 0.0);
        if (firstPitchmark < 0.001 * (double)samplingRate) {
            firstPitchmark = pitchmarks.getData(1)[0];
        }
        pitchmarks = new SequenceDoubleDataSource(new DoubleDataSource[]{new BufferedDoubleDataSource(new double[]{firstPitchmark}), pitchmarks});
        int firstPeriodLength = (int)(firstPitchmark * (double)samplingRate);
        double[] firstPeriod = new double[firstPeriodLength];
        inputSource.getData(firstPeriod, 0, firstPeriodLength);
        inputSource = new SequenceDoubleDataSource(new DoubleDataSource[]{new BufferedDoubleDataSource(firstPeriod), inputSource});
        this.memory = new double[2 * firstPeriodLength];
        System.arraycopy(firstPeriod, 0, this.memory, firstPeriodLength, firstPeriodLength);
        analysisWindow.applyInline(this.memory, 0, this.memory.length);
        if (merger != null) {
            double firstOtherPitchmark = otherPitchmarks.getData(1)[0];
            assert (firstOtherPitchmark > 0.0);
            if (firstOtherPitchmark < 0.001 * (double)otherSamplingRate) {
                firstPitchmark = otherPitchmarks.getData(1)[0];
            }
            otherPitchmarks = new SequenceDoubleDataSource(new DoubleDataSource[]{new BufferedDoubleDataSource(new double[]{firstOtherPitchmark}), otherPitchmarks});
            int firstOtherPeriodLength = (int)(firstOtherPitchmark * (double)otherSamplingRate);
            double[] firstOtherPeriod = new double[firstOtherPeriodLength];
            otherSource.getData(firstOtherPeriod, 0, firstOtherPeriodLength);
            otherSource = new SequenceDoubleDataSource(new DoubleDataSource[]{new BufferedDoubleDataSource(firstOtherPeriod), otherSource});
            double[] frameToMerge = new double[2 * firstOtherPeriodLength];
            System.arraycopy(firstOtherPeriod, 0, frameToMerge, firstOtherPeriodLength, firstOtherPeriodLength);
            merger.setFrameToMerge(frameToMerge);
            merger.applyInline(this.memory, 0, this.memory.length);
        }
        System.arraycopy(this.memory, firstPeriodLength, this.memory, 0, firstPeriodLength);
        Arrays.fill(this.memory, firstPeriodLength, this.memory.length, 0.0);
        this.frameProvider = new PitchFrameProvider(inputSource, pitchmarks, analysisWindow, samplingRate, 8, 1);
        this.otherFrameProvider = new PitchFrameProvider(otherSource, otherPitchmarks, analysisWindow, otherSamplingRate, 8, 1);
        this.processor = merger;
    }

    public FramewiseMerger(DoubleDataSource inputSource, int frameLength, int samplingRate, DoubleDataSource labelTimes, DoubleDataSource otherSource, int otherSamplingRate, DoubleDataSource otherLabelTimes, InlineFrameMerger merger) {
        BufferedDoubleDataSource paddingOther1 = new BufferedDoubleDataSource(new double[3 * frameLength / 4]);
        SequenceDoubleDataSource paddedOtherSource = new SequenceDoubleDataSource(new DoubleDataSource[]{paddingOther1, otherSource});
        this.otherFrameProvider = new FrameProvider(paddedOtherSource, Window.get(3, frameLength, 0.5), frameLength, frameLength / 4, samplingRate, true);
        int inputFrameshift = this.blockSize = frameLength / 4;
        Window window = Window.get(3, frameLength + 1, 0.5);
        this.outputWindow = null;
        this.memory = new double[frameLength];
        this.processor = merger;
        BufferedDoubleDataSource padding1 = new BufferedDoubleDataSource(new double[3 * inputFrameshift]);
        BufferedDoubleDataSource padding2 = new BufferedDoubleDataSource(new double[3 * inputFrameshift]);
        SequenceDoubleDataSource paddedSource = new SequenceDoubleDataSource(new DoubleDataSource[]{padding1, inputSource, padding2});
        this.frameProvider = new FrameProvider(paddedSource, window, frameLength, inputFrameshift, samplingRate, true);
        double[] dummy = new double[this.blockSize];
        for (int i = 0; i < 3; ++i) {
            this.getData(dummy, 0, this.blockSize);
        }
        this.frameProvider.resetInternalTimer();
        this.otherFrameProvider.resetInternalTimer();
        this.labelTimes = labelTimes;
        this.otherLabelTimes = otherLabelTimes;
        this.prevLabel = 0.0;
        this.currentLabel = 0.0;
        this.prevOtherLabel = 0.0;
        this.currentOtherLabel = 0.0;
    }

    @Override
    protected double[] getNextFrame() {
        double[] nextSignalFrame = this.frameProvider.getNextFrame();
        double frameStart = this.frameProvider.getFrameStartTime();
        while (frameStart >= this.currentLabel) {
            if (this.labelTimes == null || this.otherLabelTimes == null || !this.labelTimes.hasMoreData() || !this.otherLabelTimes.hasMoreData()) {
                this.currentLabel = Double.POSITIVE_INFINITY;
                this.localTimeStretchFactor = 1.0;
                continue;
            }
            this.prevLabel = this.currentLabel;
            this.currentLabel = this.labelTimes.getData(1)[0];
            assert (this.currentLabel >= this.prevLabel);
            this.prevOtherLabel = this.currentOtherLabel;
            this.currentOtherLabel = this.otherLabelTimes.getData(1)[0];
            assert (this.currentOtherLabel >= this.prevOtherLabel);
            if (this.currentLabel == this.prevLabel || this.currentOtherLabel == this.prevOtherLabel) {
                this.localTimeStretchFactor = 1.0;
                continue;
            }
            this.localTimeStretchFactor = (this.currentOtherLabel - this.prevOtherLabel) / (this.currentLabel - this.prevLabel);
        }
        assert (this.prevLabel <= frameStart && frameStart < this.currentLabel);
        double targetOtherStart = this.prevOtherLabel + (frameStart - this.prevLabel) * this.localTimeStretchFactor;
        double otherStart = this.otherFrameProvider.getFrameStartTime();
        double[] otherFrame = this.otherFrameProvider.getCurrentFrame();
        double prevOtherStart = -1.0;
        double[] prevOtherFrame = null;
        if (otherStart < 0.0) {
            otherFrame = this.otherFrameProvider.getNextFrame();
            otherStart = this.otherFrameProvider.getFrameStartTime();
        }
        assert (otherStart >= 0.0);
        double expectedNextOtherStart = otherStart + this.otherFrameProvider.getFrameShiftTime();
        while (otherStart < targetOtherStart && this.otherFrameProvider.hasMoreData()) {
            prevOtherFrame = (double[])otherFrame.clone();
            prevOtherStart = otherStart;
            otherFrame = this.otherFrameProvider.getNextFrame();
            otherStart = this.otherFrameProvider.getFrameStartTime();
            assert (Math.abs(otherStart - expectedNextOtherStart) < 1.0E-10) : "Other frame starts at " + otherStart + " -- expected was " + expectedNextOtherStart;
            expectedNextOtherStart = otherStart + this.otherFrameProvider.getFrameShiftTime();
        }
        if (prevOtherFrame == null) {
            ((InlineFrameMerger)this.processor).setFrameToMerge(otherFrame);
        } else {
            assert (prevOtherStart < targetOtherStart);
            assert (targetOtherStart <= otherStart || !this.otherFrameProvider.hasMoreData());
            if (targetOtherStart > otherStart) {
                targetOtherStart = otherStart;
            }
            double rPrev = 1.0 - (targetOtherStart - prevOtherStart) / (otherStart - prevOtherStart);
            assert (0.0 <= rPrev);
            assert (rPrev < 1.0);
            ((InlineFrameMerger)this.processor).setFrameToMerge(prevOtherFrame, otherFrame, rPrev);
        }
        return nextSignalFrame;
    }

    @Override
    protected int getBlockSize() {
        return this.frameProvider.getFrameShiftSamples();
    }

    public static void main(String[] args) {
    }
}

