/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechFrame;
import marytts.signalproc.sinusoidal.Sinusoid;
import marytts.signalproc.sinusoidal.SinusoidalTrack;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.util.math.ComplexArray;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class SinusoidalTracks {
    public SinusoidalTrack[] tracks;
    public int totalTracks;
    public int currentIndex;
    public int fs;
    public float origDur;
    public float[] voicings;
    public float absMaxOriginal;
    public float totalEnergy;
    public Vector<double[]> sysAmps;
    public Vector<double[]> sysPhases;
    public Vector<float[]> sysCeps;
    public Vector<ComplexArray> frameDfts;
    public float[] times;

    public SinusoidalTracks(int len, int samplingRate) {
        this.initialize(len, samplingRate);
    }

    public SinusoidalTracks(SinusoidalTracks sinTrks) {
        this(sinTrks, 0, sinTrks.totalTracks - 1);
    }

    public SinusoidalTracks(SinusoidalTracks sinTrks, int startIndex, int endIndex) {
        this.copy(sinTrks, startIndex, endIndex);
    }

    public void setSamplingRate(int samplingRate) {
        this.fs = samplingRate;
    }

    public void initialize(int len, int samplingRate) {
        if (len > 0) {
            this.totalTracks = len;
            this.tracks = new SinusoidalTrack[this.totalTracks];
        } else {
            this.totalTracks = 0;
            this.tracks = null;
        }
        this.currentIndex = -1;
        this.origDur = 0.0f;
        this.setSamplingRate(samplingRate);
        this.voicings = null;
    }

    public void copy(SinusoidalTracks srcTracks, int startTrackIndex, int endTrackIndex) {
        this.absMaxOriginal = srcTracks.absMaxOriginal;
        this.totalEnergy = srcTracks.totalEnergy;
        if (startTrackIndex < 0) {
            startTrackIndex = 0;
        }
        if (endTrackIndex < 0) {
            endTrackIndex = 0;
        }
        if (endTrackIndex > srcTracks.totalTracks - 1) {
            endTrackIndex = srcTracks.totalTracks - 1;
        }
        if (startTrackIndex > endTrackIndex) {
            startTrackIndex = endTrackIndex;
        }
        if (this.totalTracks < endTrackIndex - startTrackIndex + 1) {
            this.initialize(endTrackIndex - startTrackIndex + 1, srcTracks.fs);
        }
        if (this.totalTracks > 0) {
            for (int i = startTrackIndex; i <= endTrackIndex; ++i) {
                this.tracks[i] = new SinusoidalTrack(srcTracks.tracks[i].totalSins);
                this.tracks[i].copy(srcTracks.tracks[i]);
            }
            this.currentIndex = endTrackIndex - startTrackIndex;
            if (srcTracks.origDur > this.origDur) {
                this.origDur = srcTracks.origDur;
            }
        }
        this.setVoicings(srcTracks.voicings);
        this.setTimes(srcTracks.times);
        this.setSystemAmps(srcTracks.sysAmps);
        this.setSystemPhases(srcTracks.sysPhases);
        this.setSystemCeps(srcTracks.sysCeps);
        this.setFrameDfts(srcTracks.frameDfts);
    }

    public void copy(SinusoidalTracks srcTracks) {
        this.copy(srcTracks, 0, srcTracks.totalTracks - 1);
    }

    public void add(SinusoidalTrack track) {
        if (this.currentIndex + 1 >= this.totalTracks) {
            if (this.totalTracks > 0) {
                SinusoidalTracks tmpTracks = new SinusoidalTracks(this);
                if (tmpTracks.totalTracks < 10) {
                    this.initialize(2 * tmpTracks.totalTracks, this.fs);
                } else if (tmpTracks.totalTracks < 100) {
                    this.initialize(tmpTracks.totalTracks + 20, this.fs);
                } else if (tmpTracks.totalTracks < 1000) {
                    this.initialize(tmpTracks.totalTracks + 200, this.fs);
                } else {
                    this.initialize(tmpTracks.totalTracks + 2000, this.fs);
                }
                this.copy(tmpTracks);
            } else {
                this.initialize(1, this.fs);
            }
        }
        ++this.currentIndex;
        this.tracks[this.currentIndex] = new SinusoidalTrack(1);
        this.tracks[this.currentIndex].copy(track);
        if (this.origDur < track.times[track.totalSins - 1]) {
            this.origDur = track.times[track.totalSins - 1];
        }
    }

    public void add(float time, Sinusoid[] sins, float maxFreqOfVoicing, int state) {
        for (int i = 0; i < sins.length; ++i) {
            SinusoidalTrack tmpTrack = new SinusoidalTrack(time, sins[i], maxFreqOfVoicing, state);
            this.add(tmpTrack);
            if (!(time > this.origDur)) continue;
            this.origDur = time;
        }
    }

    public void update(int index, SinusoidalTrack track) {
        if (index < this.totalTracks) {
            this.tracks[index].copy(track);
        }
    }

    public void getTrackStatistics() {
        this.getTrackStatistics(-1.0f, -1.0f);
    }

    public void getTrackStatistics(float windowSizeInSeconds, float skipSizeInSeconds) {
        int i;
        int shortLim = 5;
        int longLim = 15;
        int longest = 0;
        int numShorts = 0;
        int numLongs = 0;
        double average = 0.0;
        for (i = 0; i < this.totalTracks; ++i) {
            if (this.tracks[i].totalSins > longest) {
                longest = this.tracks[i].totalSins;
            }
            if (this.tracks[i].totalSins < shortLim) {
                ++numShorts;
            }
            if (this.tracks[i].totalSins > longLim) {
                ++numLongs;
            }
            average += (double)this.tracks[i].totalSins;
        }
        average /= (double)this.totalTracks;
        System.out.println("Total tracks = " + String.valueOf(this.totalTracks));
        if (windowSizeInSeconds > 0.0f && skipSizeInSeconds > 0.0f) {
            System.out.println("Longest track = " + String.valueOf(longest) + " (" + String.valueOf((double)((float)longest * skipSizeInSeconds) + 0.5 * (double)windowSizeInSeconds) + " sec.)");
        } else {
            System.out.println("Longest track = " + String.valueOf(longest));
        }
        if (windowSizeInSeconds > 0.0f && skipSizeInSeconds > 0.0f) {
            System.out.println("Mean track length = " + String.valueOf(average) + " (" + String.valueOf(average * (double)skipSizeInSeconds + 0.5 * (double)windowSizeInSeconds) + " sec.)");
        } else {
            System.out.println("Mean track length = " + String.valueOf(average));
        }
        System.out.println("Total tracks shorter than " + String.valueOf(shortLim) + " speech frames = " + String.valueOf(numShorts));
        System.out.println("Total tracks longer than " + String.valueOf(longLim) + " speech frames = " + String.valueOf(numLongs));
        for (i = 0; i < this.totalTracks; ++i) {
            this.tracks[i].getStatistics(true, true, this.fs, i);
        }
    }

    public float getOriginalDuration() {
        return this.origDur;
    }

    public void setOriginalDurationAuto() {
        for (int i = 0; i < this.totalTracks; ++i) {
            if (this.tracks[i].times == null || !(this.origDur < this.tracks[i].times[this.tracks[i].currentIndex])) continue;
            this.origDur = this.tracks[i].times[this.tracks[i].currentIndex];
        }
    }

    public void setOriginalDurationManual(float origDurIn) {
        this.origDur = origDurIn;
    }

    public void setVoicings(float[] voicingsIn) {
        if (voicingsIn != null && voicingsIn.length > 0) {
            this.voicings = new float[voicingsIn.length];
            System.arraycopy(voicingsIn, 0, this.voicings, 0, voicingsIn.length);
        } else {
            this.voicings = null;
        }
    }

    public void setTimes(float[] timesIn) {
        if (timesIn != null && timesIn.length > 0) {
            this.times = new float[timesIn.length];
            System.arraycopy(timesIn, 0, this.times, 0, timesIn.length);
        } else {
            this.times = null;
        }
    }

    public void setSystemAmps(Vector<double[]> sysAmpsIn) {
        this.sysAmps = sysAmpsIn;
    }

    public void setSystemPhases(Vector<double[]> sysPhasesIn) {
        this.sysPhases = sysPhasesIn;
    }

    public void setSystemCeps(Vector<float[]> sysCepsIn) {
        this.sysCeps = sysCepsIn;
    }

    public void setFrameDfts(Vector<ComplexArray> frameDftsIn) {
        this.frameDfts = frameDftsIn;
    }

    public void writeToTextFile(String filename) throws IOException {
        File outFile = new File(filename);
        FileWriter out = new FileWriter(outFile);
        for (int i = 0; i < this.totalTracks; ++i) {
            String str = "*** Track index= " + String.valueOf(i) + "\r\n" + "AMP(lin)\tFREQ(Hz)\tPHASE(rad)\tPHASE(\u00b0)\tTIME(sec)" + "\r\n";
            out.write(str);
            for (int j = 0; j < this.tracks[i].totalSins; ++j) {
                str = String.format("%1$f", Float.valueOf(this.tracks[i].amps[j])) + "\t" + String.format("%1$f", Float.valueOf(SignalProcUtils.radian2hz(this.tracks[i].freqs[j], this.fs))) + "\t" + String.format("%1$f", Float.valueOf(this.tracks[i].phases[j])) + "\t" + String.format("%1$f", Float.valueOf(MathUtils.unwrapToRange(MathUtils.radian2degrees(this.tracks[i].phases[j]), -180.0f))) + "\t" + String.format("%1$f", Float.valueOf(this.tracks[i].times[j])) + "\r\n";
                out.write(str);
            }
            str = "********************************************************\r\n";
            out.write(str);
        }
        out.close();
    }

    public void setSysAmpsAndTimes(NonharmonicSinusoidalSpeechFrame[] framesSins) {
        if (framesSins == null || framesSins.length <= 0) {
            this.sysAmps = null;
            this.sysPhases = null;
            this.sysCeps = null;
            this.frameDfts = null;
            this.times = null;
        } else {
            this.sysAmps = new Vector();
            this.sysPhases = new Vector();
            this.sysCeps = new Vector();
            this.frameDfts = new Vector();
            this.times = new float[framesSins.length];
            for (int i = 0; i < framesSins.length; ++i) {
                this.sysAmps.add(framesSins[i].systemAmps);
                this.sysPhases.add(framesSins[i].systemPhases);
                this.sysCeps.add(framesSins[i].systemCeps);
                this.frameDfts.add(framesSins[i].frameDfts);
                this.times[i] = framesSins[i].time;
            }
        }
    }

    public void setSysAmpsAndTimes(HntmSpeechSignal hntmSignal, HntmAnalyzerParams params) {
        this.sysAmps = null;
        this.sysPhases = null;
        this.frameDfts = null;
        if (hntmSignal == null || hntmSignal.frames == null || hntmSignal.frames.length <= 0) {
            this.sysCeps = null;
            this.times = null;
        } else {
            this.sysCeps = new Vector();
            this.times = new float[hntmSignal.frames.length];
            for (int i = 0; i < hntmSignal.frames.length; ++i) {
                this.sysCeps.add(hntmSignal.frames[i].h.getCeps(hntmSignal.frames[i].f0InHz, hntmSignal.samplingRateInHz, params));
                this.times[i] = hntmSignal.frames[i].tAnalysisInSeconds;
            }
        }
    }
}

