/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.regex.Pattern;

public class FeatureGeneratorUtil {
    private static Pattern lowercase = Pattern.compile("^[a-z]+$");
    private static Pattern twoDigits = Pattern.compile("^[0-9][0-9]$");
    private static Pattern fourDigits = Pattern.compile("^[0-9][0-9][0-9][0-9]$");
    private static Pattern containsNumber = Pattern.compile("[0-9]");
    private static Pattern containsLetter = Pattern.compile("[a-zA-Z]");
    private static Pattern containsHyphens = Pattern.compile("-");
    private static Pattern containsBackslash = Pattern.compile("/");
    private static Pattern containsComma = Pattern.compile(",");
    private static Pattern containsPeriod = Pattern.compile("\\.");
    private static Pattern allCaps = Pattern.compile("^[A-Z]+$");
    private static Pattern capPeriod = Pattern.compile("^[A-Z]\\.$");
    private static Pattern initialCap = Pattern.compile("^[A-Z]");

    public static String tokenFeature(String token) {
        String feat = lowercase.matcher(token).find() ? "lc" : (twoDigits.matcher(token).find() ? "2d" : (fourDigits.matcher(token).find() ? "4d" : (containsNumber.matcher(token).find() ? (containsLetter.matcher(token).find() ? "an" : (containsHyphens.matcher(token).find() ? "dd" : (containsBackslash.matcher(token).find() ? "ds" : (containsComma.matcher(token).find() ? "dc" : (containsPeriod.matcher(token).find() ? "dp" : "num"))))) : (allCaps.matcher(token).find() && token.length() == 1 ? "sc" : (allCaps.matcher(token).find() ? "ac" : (capPeriod.matcher(token).find() ? "cp" : (initialCap.matcher(token).find() ? "ic" : "other")))))));
        return feat;
    }
}

