/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.ColorizedBarRenderer;
import com.rapidminer.gui.plotter.charts.CtrlChartPanel;
import com.rapidminer.gui.plotter.charts.RapidBarPainter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AverageFunction;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChartPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 1208210421840512091L;
    private static final int MAX_CATEGORIES = 200;
    private static final String[] ORIENTATION_TYPES = new String[]{"vertical", "horizontal"};
    public static final int ORIENTATION_TYPE_VERTICAL = 0;
    public static final int ORIENTATION_TYPE_HORIZONTAL = 1;
    private DataTable dataTable;
    private DefaultCategoryDataset categoryDataSet = new DefaultCategoryDataset();
    private int groupByColumn = -1;
    private int legendByColumn = -1;
    private int valueColumn = -1;
    private JComboBox orientationType = new JComboBox<String>(ORIENTATION_TYPES);
    private JCheckBox useDistinct = new JCheckBox("Use Only Distinct", false);
    private JCheckBox rotateLabels = new JCheckBox("Rotate Labels", false);
    private JComboBox aggregationFunction = null;
    private boolean absolute = false;
    private ChartPanel panel = new ChartPanel(null);

    public BarChartPlotter() {
        this.setBackground(Color.white);
        String[] allFunctions = new String[AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length + 1];
        allFunctions[0] = "none";
        System.arraycopy(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 0, allFunctions, 1, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length);
        this.aggregationFunction = new JComboBox<String>(allFunctions);
        this.aggregationFunction.setToolTipText("Select the type of the aggregation function which should be used for grouped values.");
        this.aggregationFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarChartPlotter.this.updatePlotter();
            }
        });
        this.useDistinct.setToolTipText("Indicates if only distinct values should be used for aggregation functions.");
        this.useDistinct.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarChartPlotter.this.updatePlotter();
            }
        });
        this.rotateLabels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarChartPlotter.this.updatePlotter();
            }
        });
        this.orientationType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BarChartPlotter.this.updatePlotter();
            }
        });
    }

    public BarChartPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.updatePlotter();
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
        this.updatePlotter();
    }

    @Override
    public boolean isSupportingAbsoluteValues() {
        return true;
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.valueColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.valueColumn == index;
    }

    @Override
    public String getPlotName() {
        return "Value Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 2;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (index == 0) {
            this.groupByColumn = dimension;
        } else if (index == 1) {
            this.legendByColumn = dimension;
        }
        this.updatePlotter();
    }

    @Override
    public int getAxis(int index) {
        if (index == 0) {
            return this.groupByColumn;
        }
        if (index == 1) {
            return this.legendByColumn;
        }
        return -1;
    }

    @Override
    public String getAxisName(int index) {
        if (index == 0) {
            return "Group-By Column";
        }
        if (index == 1) {
            return "Legend Column";
        }
        return "Unknown";
    }

    public void setRotateLabels(boolean rotateLabels) {
        this.rotateLabels.setSelected(rotateLabels);
        this.updatePlotter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int prepareData() {
        var1_1 = this.dataTable;
        synchronized (var1_1) {
            block19: {
                aggregation = null;
                if (this.aggregationFunction.getSelectedIndex() > 0) {
                    try {
                        aggregation = AbstractAggregationFunction.createAggregationFunction(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[this.aggregationFunction.getSelectedIndex() - 1]);
                    }
                    catch (Exception e) {
                        LogService.getGlobal().logWarning("Cannot instantiate aggregation function '" + this.aggregationFunction.getSelectedItem() + "', using 'average' as default.");
                        aggregation = new AverageFunction();
                    }
                }
                i = this.dataTable.iterator();
                categoryValues = new LinkedHashMap<String, TreeSet<Double>>();
                this.categoryDataSet.clear();
                if (this.groupByColumn >= 0 && this.dataTable.isNumerical(this.groupByColumn)) {
                    return 0;
                }
                while (true) {
                    block20: {
                        if (i.hasNext()) break block20;
                        if (this.valueColumn < 0) break block19;
                        if (aggregation == null) break;
                        c = categoryValues.entrySet().iterator();
                        if (true) ** GOTO lbl78
                    }
                    row = i.next();
                    value = NaN;
                    if (this.valueColumn >= 0) {
                        value = row.getValue(this.valueColumn);
                    }
                    if (Double.isNaN(value)) continue;
                    if (this.absolute) {
                        value = Math.abs(value);
                    }
                    valueString = null;
                    valueString = this.dataTable.isDate(this.valueColumn) != false ? Tools.formatDate(new Date((long)value)) : (this.dataTable.isTime(this.valueColumn) != false ? Tools.formatTime(new Date((long)value)) : (this.dataTable.isDateTime(this.valueColumn) != false ? Tools.formatDateTime(new Date((long)value)) : (this.dataTable.isNominal(this.valueColumn) != false ? this.dataTable.mapIndex(this.valueColumn, (int)value) : Tools.formatIntegerIfPossible(value))));
                    legendName = String.valueOf(valueString);
                    if (this.legendByColumn >= 0) {
                        nameValue = row.getValue(this.legendByColumn);
                        legendName = this.dataTable.isDate(this.legendByColumn) != false ? Tools.formatDate(new Date((long)nameValue)) : (this.dataTable.isTime(this.legendByColumn) != false ? Tools.formatTime(new Date((long)nameValue)) : (this.dataTable.isDateTime(this.legendByColumn) != false ? Tools.formatDateTime(new Date((long)nameValue)) : (this.dataTable.isNominal(this.legendByColumn) != false ? String.valueOf(this.dataTable.mapIndex(this.legendByColumn, (int)nameValue)) + " (" + valueString + ")" : String.valueOf(Tools.formatIntegerIfPossible(nameValue)) + " (" + valueString + ")")));
                    }
                    groupByName = legendName;
                    if (this.groupByColumn >= 0) {
                        nameValue = row.getValue(this.groupByColumn);
                        groupByName = this.dataTable.isDate(this.groupByColumn) != false ? Tools.formatDate(new Date((long)nameValue)) : (this.dataTable.isTime(this.groupByColumn) != false ? Tools.formatTime(new Date((long)nameValue)) : (this.dataTable.isDateTime(this.groupByColumn) != false ? Tools.formatDateTime(new Date((long)nameValue)) : (this.dataTable.isNominal(this.groupByColumn) != false ? this.dataTable.mapIndex(this.groupByColumn, (int)nameValue) : String.valueOf(Tools.formatIntegerIfPossible(nameValue)))));
                    }
                    if ((values /* !! */  = (TreeSet<Double>)categoryValues.get(groupByName)) == null) {
                        values /* !! */  = this.useDistinct.isSelected() != false ? new TreeSet<Double>() : new LinkedList<E>();
                        categoryValues.put(groupByName, values /* !! */ );
                    }
                    values /* !! */ .add(value);
                }
                for (Map.Entry<K, V> entry : categoryValues.entrySet()) {
                    name = (String)entry.getKey();
                    values = (Collection)entry.getValue();
                    v = values.iterator();
                    while (v.hasNext()) {
                        value = (Double)v.next();
                        if (this.groupByColumn < 0) {
                            this.categoryDataSet.setValue(value, (Comparable)this.dataTable.getColumnName(this.valueColumn), (Comparable)name);
                            continue;
                        }
                        this.categoryDataSet.setValue(value, (Comparable)this.dataTable.getColumnName(this.groupByColumn), (Comparable)name);
                    }
                }
                break block19;
                do {
                    entry = c.next();
                    name = (String)entry.getKey();
                    values = (Collection)entry.getValue();
                    valueArray = new double[values.size()];
                    v = values.iterator();
                    valueIndex = 0;
                    while (v.hasNext()) {
                        valueArray[valueIndex++] = (Double)v.next();
                    }
                    value = aggregation.calculate(valueArray);
                    if (this.groupByColumn < 0) {
                        this.categoryDataSet.setValue(value, (Comparable)this.dataTable.getColumnName(this.valueColumn), (Comparable)name);
                        continue;
                    }
                    this.categoryDataSet.setValue(value, (Comparable)this.dataTable.getColumnName(this.groupByColumn), (Comparable)name);
lbl78:
                    // 3 sources

                } while (c.hasNext());
            }
            return categoryValues.size();
        }
    }

    @Override
    public JComponent getPlotter() {
        return this.panel;
    }

    public void updatePlotter() {
        int categoryCount = this.prepareData();
        if (categoryCount <= 200) {
            JFreeChart chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)this.categoryDataSet, (PlotOrientation)(this.orientationType.getSelectedIndex() == 0 ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL), (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.WHITE);
            chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
            CategoryAxis domainAxis = plot.getDomainAxis();
            domainAxis.setLabelFont(LABEL_FONT_BOLD);
            domainAxis.setTickLabelFont(LABEL_FONT);
            String domainName = this.groupByColumn >= 0 ? this.dataTable.getColumnName(this.groupByColumn) : null;
            domainAxis.setLabel(domainName);
            if (this.rotateLabels.isSelected()) {
                plot.getDomainAxis().setTickLabelsVisible(true);
                plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
            }
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setLabelFont(LABEL_FONT_BOLD);
            rangeAxis.setTickLabelFont(LABEL_FONT);
            String rangeName = this.valueColumn >= 0 ? this.dataTable.getColumnName(this.valueColumn) : null;
            rangeAxis.setLabel(rangeName);
            double[] colorValues = null;
            colorValues = this.groupByColumn >= 0 && this.dataTable.isNominal(this.groupByColumn) ? new double[this.dataTable.getNumberOfValues(this.groupByColumn)] : new double[this.categoryDataSet.getColumnCount()];
            int i = 0;
            while (i < colorValues.length) {
                colorValues[i] = i;
                ++i;
            }
            ColorizedBarRenderer renderer = new ColorizedBarRenderer(colorValues);
            renderer.setBarPainter(new RapidBarPainter());
            renderer.setDrawBarOutline(true);
            int size = this.categoryDataSet.getRowCount();
            if (size > 1) {
                int i2 = 0;
                while (i2 < size) {
                    renderer.setSeriesPaint(i2, this.getColorProvider().getPointColor((double)i2 / (double)(size - 1)));
                    ++i2;
                }
            }
            plot.setRenderer((CategoryItemRenderer)renderer);
            LegendTitle legend = chart.getLegend();
            if (legend != null) {
                legend.setPosition(RectangleEdge.TOP);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                legend.setItemFont(LABEL_FONT);
            }
            if (this.panel instanceof CtrlChartPanel) {
                this.panel.setChart(chart);
            } else {
                this.panel = new CtrlChartPanel(chart, this.getWidth(), this.getHeight() - 20);
                ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
                this.panel.addMouseListener((MouseListener)controller);
                this.panel.addMouseMotionListener((MouseMotionListener)controller);
            }
            this.panel.getChartRenderingInfo().setEntityCollection(null);
        } else {
            LogService.getGlobal().logNote("Too many columns (" + categoryCount + "), this chart is only able to plot up to " + 200 + " different categories.");
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        switch (index) {
            case 0: {
                JLabel label = new JLabel("Aggregation");
                label.setToolTipText("Select the type of the aggregation function which should be used for grouped values.");
                return label;
            }
            case 1: {
                return this.aggregationFunction;
            }
            case 2: {
                return this.useDistinct;
            }
            case 3: {
                return this.rotateLabels;
            }
            case 4: {
                return this.orientationType;
            }
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys() {
        List<ParameterType> types = super.getAdditionalParameterKeys();
        String[] allFunctions = new String[AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length + 1];
        allFunctions[0] = "none";
        System.arraycopy(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 0, allFunctions, 1, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length);
        types.add(new ParameterTypeCategory("aggregation", "The function used for aggregating the values grouped by the specified column.", allFunctions, 0));
        types.add(new ParameterTypeBoolean("use_distinct", "Indicates if only distinct values should be regarded for aggregation.", false));
        types.add(new ParameterTypeBoolean("rotate_labels", "Indicates if the domain axis labels should be rotated.", false));
        types.add(new ParameterTypeCategory("orientation", "The orientation of the bars.", ORIENTATION_TYPES, 0));
        return types;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setAdditionalParameter(String key, String value) {
        if ("aggregation".equals(key)) {
            block15: {
                index = 0;
                try {
                    index = Integer.valueOf(value);
                    break block15;
                }
                catch (NumberFormatException e) {
                    nameCounter = 1;
                    var9_10 = AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES;
                    var8_12 = AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length;
                    var7_14 = 0;
                    ** while (var7_14 < var8_12)
                }
lbl-1000:
                // 1 sources

                {
                    name = var9_10[var7_14];
                    if (name.equals(value)) {
                        index = nameCounter;
                        break;
                    }
                    ++nameCounter;
                    ++var7_14;
                    continue;
                }
            }
            this.aggregationFunction.setSelectedIndex(index);
        } else if ("use_distinct".equals(key)) {
            distinct = Tools.booleanValue(value, false);
            this.useDistinct.setSelected(distinct);
        } else if ("rotate_labels".equals(key)) {
            this.setRotateLabels(Tools.booleanValue(value, false));
        } else if ("orientation".equals(key)) {
            block16: {
                index = 0;
                try {
                    index = Integer.valueOf(value);
                    break block16;
                }
                catch (NumberFormatException e) {
                    nameCounter = 1;
                    var9_11 = BarChartPlotter.ORIENTATION_TYPES;
                    var8_13 = BarChartPlotter.ORIENTATION_TYPES.length;
                    var7_15 = 0;
                    ** while (var7_15 < var8_13)
                }
lbl-1000:
                // 1 sources

                {
                    name = var9_11[var7_15];
                    if (name.equals(value)) {
                        index = nameCounter;
                        break;
                    }
                    ++nameCounter;
                    ++var7_15;
                    continue;
                }
            }
            this.orientationType.setSelectedIndex(index);
        }
    }
}

