/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Tools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOContainer
implements Serializable {
    private static final long serialVersionUID = 8152465082153754473L;
    private List<IOObject> ioObjects;
    public static final IOContainer DUMMY_IO_CONTAINER = new IOContainer(new ResultObjectAdapter(){
        private static final long serialVersionUID = -5877096753744650074L;

        public String getName() {
            return "Dummy";
        }

        public String toString() {
            return "No intermediate results for this operator";
        }

        public boolean isSavable() {
            return false;
        }

        public String getExtension() {
            return "dum";
        }

        public String getFileDescription() {
            return "dummy result";
        }
    });

    public IOContainer() {
        this(new IOObject[0]);
    }

    public IOContainer(Collection<? extends IOObject> objectCollection) {
        this.ioObjects = new ArrayList<IOObject>(objectCollection.size());
        this.ioObjects.addAll(objectCollection);
    }

    public IOContainer(IOObject ... objectArray) {
        this.ioObjects = new ArrayList<IOObject>(objectArray.length);
        int i = 0;
        while (i < objectArray.length) {
            this.ioObjects.add(objectArray[i]);
            ++i;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("IOContainer (" + this.ioObjects.size() + " objects):" + Tools.getLineSeparator());
        for (IOObject current : this.ioObjects) {
            if (current == null) continue;
            result.append(String.valueOf(current.toString()) + Tools.getLineSeparator() + (current.getSource() != null ? "(created by " + current.getSource() + ")" + Tools.getLineSeparator() : ""));
        }
        return result.toString();
    }

    public int size() {
        return this.ioObjects.size();
    }

    public IOObject getElementAt(int index) {
        return this.ioObjects.get(index);
    }

    public IOObject removeElementAt(int index) {
        return this.ioObjects.remove(index);
    }

    public IOObject[] getIOObjects() {
        return this.ioObjects.toArray(new IOObject[this.ioObjects.size()]);
    }

    public <T extends IOObject> T get(Class<T> cls) throws MissingIOObjectException {
        return this.getInput(cls, 0, false);
    }

    public <T extends IOObject> T get(Class<T> cls, int nr) throws MissingIOObjectException {
        return this.getInput(cls, nr, false);
    }

    public <T extends IOObject> T remove(Class<T> cls) throws MissingIOObjectException {
        return this.getInput(cls, 0, true);
    }

    public <T extends IOObject> T remove(Class<T> cls, int nr) throws MissingIOObjectException {
        return this.getInput(cls, nr, true);
    }

    public boolean contains(Class<? extends IOObject> cls) {
        try {
            this.getInput(cls, 0, false);
            return true;
        }
        catch (MissingIOObjectException e) {
            return false;
        }
    }

    private <T extends IOObject> T getInput(Class<T> cls, int nr, boolean remove) throws MissingIOObjectException {
        int n = 0;
        Iterator<IOObject> i = this.ioObjects.iterator();
        while (i.hasNext()) {
            IOObject object = i.next();
            if (object == null || !cls.isAssignableFrom(object.getClass())) continue;
            if (n == nr) {
                if (remove) {
                    i.remove();
                }
                return (T)object;
            }
            ++n;
        }
        throw new MissingIOObjectException(cls);
    }

    public IOContainer append(IOObject object) {
        return this.append(new IOObject[]{object});
    }

    public IOContainer append(IOObject[] output) {
        LinkedList<IOObject> newObjects = new LinkedList<IOObject>();
        int i = 0;
        while (i < output.length) {
            newObjects.add(output[i]);
            ++i;
        }
        newObjects.addAll(this.ioObjects);
        return new IOContainer(newObjects);
    }

    public IOContainer prepend(IOObject object) {
        return this.prepend(new IOObject[]{object});
    }

    public IOContainer prepend(IOObject[] output) {
        LinkedList<IOObject> newObjects = new LinkedList<IOObject>();
        newObjects.addAll(this.ioObjects);
        int i = 0;
        while (i < output.length) {
            newObjects.add(output[i]);
            ++i;
        }
        return new IOContainer(newObjects);
    }

    public IOContainer append(Collection<IOObject> output) {
        LinkedList<IOObject> newObjects = new LinkedList<IOObject>();
        newObjects.addAll(output);
        newObjects.addAll(this.ioObjects);
        return new IOContainer(newObjects);
    }

    public IOContainer copy() {
        LinkedList<IOObject> clones = new LinkedList<IOObject>();
        Iterator<IOObject> i = this.ioObjects.iterator();
        while (i.hasNext()) {
            clones.add(i.next().copy());
        }
        return new IOContainer(clones);
    }

    public void removeAll() {
        this.ioObjects.clear();
    }
}

