/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationEvaluator;
import com.rapidminer.operator.performance.PerformanceVector;

public class SimplePopulationEvaluator
implements PopulationEvaluator {
    private ExampleSet originalSet;
    private IOContainer input;
    private FeatureOperator operator;

    public SimplePopulationEvaluator(FeatureOperator operator, IOContainer input, ExampleSet originalSet) {
        this.originalSet = originalSet;
        this.input = input;
        this.operator = operator;
    }

    private final void evaluate(Individual individual) throws OperatorException {
        if (individual.getPerformance() == null) {
            double[] weights = individual.getWeights();
            ExampleSet clone = FeatureOperator.createCleanClone(this.originalSet, weights);
            IOObject[] operatorChainInput = new IOObject[]{clone};
            IOContainer innerResult = this.input.prepend(operatorChainInput);
            int i = 0;
            while (i < this.operator.getNumberOfOperators()) {
                innerResult = this.operator.getOperator(i).apply(innerResult);
                ++i;
            }
            PerformanceVector performanceVector = innerResult.remove(PerformanceVector.class);
            individual.setPerformance(performanceVector);
        }
    }

    public void evaluate(Population population) throws OperatorException {
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            this.evaluate(population.get(i));
            ++i;
        }
    }
}

