/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.math.MathFunctions;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationWeighting
extends AbstractWeighting {
    public static final String PARAMETER_SQUARED_CORRELATION = "squared_correlation";

    public CorrelationWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        Attributes attributes = exampleSet.getAttributes();
        Attribute labelAttribute = attributes.getLabel();
        boolean useSquaredCorrelation = this.getParameterAsBoolean(PARAMETER_SQUARED_CORRELATION);
        AttributeWeights weights = new AttributeWeights(exampleSet);
        for (Attribute attribute : attributes) {
            double correlation = MathFunctions.correlation(exampleSet, labelAttribute, attribute, useSquaredCorrelation);
            weights.setWeight(attribute.getName(), Math.abs(correlation));
        }
        return weights;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_SQUARED_CORRELATION, "Indicates if the squared correlation should be calculated.", false));
        return types;
    }
}

