/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.operator.generator.ClassificationFunction;
import com.rapidminer.operator.generator.Dot;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class GlobalAndLocalPatternsFunction
extends ClassificationFunction {
    private static final int NUMBER_OF_POSITIVE_DOTS = 8;
    private static final int NUMBER_OF_NEGATIVE_DOTS = 5;
    private List<Dot> positiveDots = new LinkedList<Dot>();
    private List<Dot> negativeDots = new LinkedList<Dot>();

    public void init(RandomGenerator random) {
        this.positiveDots.clear();
        this.negativeDots.clear();
        double maxRadius = (this.upper - this.lower) / 8.0;
        int i = 0;
        while (i < 8) {
            this.positiveDots.add(new Dot(random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(0.0, maxRadius)));
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.negativeDots.add(new Dot(random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(this.lower, this.upper), random.nextDoubleInRange(0.0, maxRadius)));
            ++i;
        }
    }

    public double calculate(double[] att) throws TargetFunction.FunctionException {
        if (att.length != 2) {
            throw new TargetFunction.FunctionException("Global and Local Patterns Function", "needs exactly two attributes!");
        }
        for (Dot pDot : this.positiveDots) {
            if (!pDot.contains(att[0], att[1])) continue;
            return this.getLabel().getMapping().mapString("positive");
        }
        for (Dot nDot : this.negativeDots) {
            if (!nDot.contains(att[0], att[1])) continue;
            return this.getLabel().getMapping().mapString("negative");
        }
        double sum = 0.0;
        int i = 0;
        while (i < att.length) {
            sum += att[i];
            ++i;
        }
        return sum > 0.0 ? this.getLabel().getMapping().mapString("positive") : this.getLabel().getMapping().mapString("negative");
    }
}

