/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArffExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_DATA_FILE = "data_file";
    public static final String PARAMETER_LABEL_ATTRIBUTE = "label_attribute";
    public static final String PARAMETER_ID_ATTRIBUTE = "id_attribute";
    public static final String PARAMETER_WEIGHT_ATTRIBUTE = "weight_attribute";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public ArffExampleSource(OperatorDescription description) {
        super(description);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        try {
            InputStream inputStream = this.getParameterAsInputStream(PARAMETER_DATA_FILE);
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, this.getEncoding()));
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            Attribute label = null;
            Attribute weight = null;
            Attribute id = null;
            StreamTokenizer tokenizer = this.createTokenizer(in);
            Tools.getFirstToken(tokenizer);
            if (tokenizer.ttype == -1) {
                throw new UserError((Operator)this, 302, this.getParameterAsString(PARAMETER_DATA_FILE), "file is empty");
            }
            if (!"@relation".equalsIgnoreCase(tokenizer.sval)) {
                throw new IOException("expected the keyword @relation in line " + tokenizer.lineno());
            }
            Tools.getNextToken(tokenizer);
            Tools.getLastToken(tokenizer, false);
            Tools.getFirstToken(tokenizer);
            if (tokenizer.ttype == -1) {
                throw new IOException("unexpected end of file in line " + tokenizer.lineno() + ", attribute description expected...");
            }
            while (true) {
                if (!"@attribute".equalsIgnoreCase(tokenizer.sval)) {
                    if ("@data".equalsIgnoreCase(tokenizer.sval)) break;
                    throw new IOException("expected keyword '@data' in line " + tokenizer.lineno());
                }
                Attribute attribute = this.createAttribute(tokenizer);
                if (attribute == null) {
                    throw new IOException("Cannot read attribute information, maybe the value type is missing or a name containing spaces without quoting was used...");
                }
                attributes.add(attribute);
                if (attribute.getName().equals(this.getParameterAsString(PARAMETER_LABEL_ATTRIBUTE))) {
                    label = attribute;
                    continue;
                }
                if (attribute.getName().equals(this.getParameterAsString(PARAMETER_ID_ATTRIBUTE))) {
                    id = attribute;
                    continue;
                }
                if (!attribute.getName().equals(this.getParameterAsString(PARAMETER_WEIGHT_ATTRIBUTE))) continue;
                weight = attribute;
            }
            if (attributes.size() == 0) {
                throw new IOException("no attributes were declared in the ARFF file, please declare attributes with the '@attribute' keyword.");
            }
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            Attribute[] attributeArray = table.getAttributes();
            DataRowFactory factory = new DataRowFactory(this.getParameterAsInt(PARAMETER_DATAMANAGEMENT), this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER).charAt(0));
            int maxRows = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
            double sampleProb = this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO);
            RandomGenerator random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
            DataRow dataRow = null;
            int counter = 0;
            while ((dataRow = this.createDataRow(tokenizer, true, factory, attributeArray)) != null && (maxRows <= -1 || counter < maxRows)) {
                ++counter;
                if (maxRows == -1 && random.nextDouble() > sampleProb) continue;
                table.addDataRow(dataRow);
            }
            in.close();
            HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
            specialMap.put(label, "label");
            specialMap.put(weight, "weight");
            specialMap.put(id, "id");
            return table.createExampleSet(specialMap);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, this.getParameterAsString(PARAMETER_DATA_FILE), e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private Attribute createAttribute(StreamTokenizer tokenizer) throws IOException {
        block14: {
            block13: {
                attribute = null;
                Tools.getNextToken(tokenizer);
                attributeName = tokenizer.sval;
                Tools.getNextToken(tokenizer);
                if (tokenizer.ttype != -3) break block13;
                if (tokenizer.sval.equalsIgnoreCase("real")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 4);
                } else if (tokenizer.sval.equalsIgnoreCase("integer")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 3);
                } else if (tokenizer.sval.equalsIgnoreCase("numeric")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 2);
                } else if (tokenizer.sval.equalsIgnoreCase("string")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 5);
                } else if (tokenizer.sval.equalsIgnoreCase("date")) {
                    attribute = AttributeFactory.createAttribute(attributeName, 10);
                }
                Tools.waitForEOL(tokenizer);
                break block14;
            }
            attribute = AttributeFactory.createAttribute(attributeName, 1);
            tokenizer.pushBack();
            if (tokenizer.nextToken() == 123) ** GOTO lbl31
            throw new IOException("{ expected at beginning of nominal values definition in line " + tokenizer.lineno());
lbl-1000:
            // 1 sources

            {
                if (tokenizer.ttype == 10) {
                    throw new IOException("} expected at end of the nominal values definition in line " + tokenizer.lineno());
                }
                attribute.getMapping().mapString(tokenizer.sval);
lbl31:
                // 2 sources

                ** while (tokenizer.nextToken() != 125)
            }
lbl32:
            // 1 sources

            if (attribute.getMapping().size() == 0) {
                throw new IOException("empty definition of nominal values is not suggested in line " + tokenizer.lineno());
            }
        }
        Tools.getLastToken(tokenizer, false);
        Tools.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            throw new IOException("unexpected end of file before data section in line " + tokenizer.lineno());
        }
        return attribute;
    }

    private DataRow createDataRow(StreamTokenizer tokenizer, boolean checkForCarriageReturn, DataRowFactory factory, Attribute[] allAttributes) throws IOException {
        Tools.getFirstToken(tokenizer);
        if (tokenizer.ttype == -1) {
            return null;
        }
        if (tokenizer.ttype == 123) {
            return this.createDataRowFromSparse(tokenizer, checkForCarriageReturn, factory, allAttributes);
        }
        return this.createDataRowFromDense(tokenizer, checkForCarriageReturn, factory, allAttributes);
    }

    private DataRow createDataRowFromDense(StreamTokenizer tokenizer, boolean checkForCarriageReturn, DataRowFactory factory, Attribute[] allAttributes) throws IOException {
        String[] tokens = new String[allAttributes.length];
        int i = 0;
        while (i < allAttributes.length) {
            if (i > 0) {
                Tools.getNextToken(tokenizer);
            }
            if (tokenizer.ttype == 63) {
                tokens[i] = "?";
            } else {
                if (tokenizer.ttype != -3) {
                    throw new IOException("not a valid value '" + tokenizer.sval + "' in line " + tokenizer.lineno());
                }
                tokens[i] = tokenizer.sval;
            }
            ++i;
        }
        if (checkForCarriageReturn) {
            Tools.getLastToken(tokenizer, true);
        }
        return factory.create(tokens, allAttributes);
    }

    private DataRow createDataRowFromSparse(StreamTokenizer tokenizer, boolean checkForCarriageReturn, DataRowFactory factory, Attribute[] allAttributes) throws IOException {
        String[] tokens = new String[allAttributes.length];
        int t = 0;
        while (t < tokens.length) {
            tokens[t] = "0";
            ++t;
        }
        while (true) {
            if (tokenizer.nextToken() == 10) {
                throw new IOException("unexpedted end of line " + tokenizer.lineno());
            }
            if (tokenizer.ttype == -1) {
                throw new IOException("unexpedted end of file in line " + tokenizer.lineno());
            }
            if (tokenizer.ttype == 125) break;
            int index = Integer.valueOf(tokenizer.sval);
            Tools.getNextToken(tokenizer);
            if (tokenizer.ttype == 63) {
                tokens[index] = "?";
                continue;
            }
            if (tokenizer.ttype != -3) {
                throw new IOException("not a valid value '" + tokenizer.sval + "' in line " + tokenizer.lineno());
            }
            tokens[index] = tokenizer.sval;
        }
        if (checkForCarriageReturn) {
            Tools.getLastToken(tokenizer, true);
        }
        return factory.create(tokens, allAttributes);
    }

    private StreamTokenizer createTokenizer(Reader in) {
        StreamTokenizer tokenizer = new StreamTokenizer(in);
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(44, 44);
        tokenizer.commentChar(37);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.ordinaryChar(123);
        tokenizer.ordinaryChar(125);
        tokenizer.eolIsSignificant(true);
        return tokenizer;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_DATA_FILE, "The path to the data file.", "arff", false));
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_LABEL_ATTRIBUTE, "The (case sensitive) name of the label attribute");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_ID_ATTRIBUTE, "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeString(PARAMETER_WEIGHT_ATTRIBUTE, "The (case sensitive) name of the weight attribute"));
        types.add(new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", "."));
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of the data set which should be read (1 = all; only used if sample_size = -1)", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The exact number of samples which should be read (-1 = use sample ratio; if not -1, sample_ratio will not have any effect)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (only for permutation, -1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

