/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackingModel
extends PredictionModel {
    private static final long serialVersionUID = -3978054415189320147L;
    private String modelName;
    private List<Model> baseModels;
    private Model stackingModel;
    private boolean useAllAttributes;

    public StackingModel(ExampleSet exampleSet, String modelName, List<Model> baseModels, Model stackingModel, boolean useAllAttributes) {
        super(exampleSet);
        this.modelName = modelName;
        this.baseModels = baseModels;
        this.stackingModel = stackingModel;
        this.useAllAttributes = useAllAttributes;
    }

    @Override
    public String getName() {
        return this.modelName;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) throws OperatorException {
        PredictionModel.removePredictedLabel(exampleSet, true, true);
        ExampleSet stackingExampleSet = (ExampleSet)exampleSet.clone();
        if (!this.useAllAttributes) {
            stackingExampleSet.getAttributes().clearRegular();
        }
        LinkedList<Attribute> tempPredictions = new LinkedList<Attribute>();
        int i = 0;
        for (Model baseModel : this.baseModels) {
            exampleSet = baseModel.apply(exampleSet);
            Attribute basePrediction = exampleSet.getAttributes().getPredictedLabel();
            basePrediction.setName("base_prediction" + i);
            PredictionModel.removePredictedLabel(exampleSet, false, true);
            stackingExampleSet.getAttributes().addRegular(basePrediction);
            tempPredictions.add(basePrediction);
            ++i;
        }
        stackingExampleSet = this.stackingModel.apply(stackingExampleSet);
        PredictionModel.copyPredictedLabel(stackingExampleSet, exampleSet);
        for (Attribute tempPrediction : tempPredictions) {
            stackingExampleSet.getAttributes().remove(tempPrediction);
            stackingExampleSet.getExampleTable().removeAttribute(tempPrediction);
        }
        return exampleSet;
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        ExtendedJTabbedPane tabPane = new ExtendedJTabbedPane();
        tabPane.add("Stacking Model", this.stackingModel.getVisualizationComponent(container));
        int index = 1;
        for (Model model : this.baseModels) {
            tabPane.add("Model " + index, model.getVisualizationComponent(container));
            ++index;
        }
        return tabPane;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(String.valueOf(super.toString()) + Tools.getLineSeparators(2));
        result.append(String.valueOf(this.modelName) + ":");
        result.append(String.valueOf(Tools.getLineSeparator()) + this.stackingModel.toString() + Tools.getLineSeparators(2));
        result.append("Base Models:");
        for (Model baseModel : this.baseModels) {
            result.append(String.valueOf(Tools.getLineSeparator()) + baseModel.toString());
        }
        return result.toString();
    }
}

