/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.viewer.ROCViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.math.Averagable;
import com.rapidminer.tools.math.ROCData;
import com.rapidminer.tools.math.ROCDataGenerator;
import java.awt.Component;
import java.awt.Graphics;
import java.util.LinkedList;

public class AreaUnderCurve
extends MeasuredPerformance
implements Renderable {
    private static final long serialVersionUID = 6877715214974493828L;
    private double auc = Double.NaN;
    private transient ROCDataGenerator rocDataGenerator = new ROCDataGenerator(1.0, 1.0);
    private LinkedList<ROCData> rocData = new LinkedList();
    private int counter = 1;
    private String positiveClass;
    private transient ROCViewer viewer;

    public AreaUnderCurve() {
    }

    public AreaUnderCurve(AreaUnderCurve aucObject) {
        super(aucObject);
        this.auc = aucObject.auc;
        this.counter = aucObject.counter;
        this.positiveClass = aucObject.positiveClass;
    }

    public void startCounting(ExampleSet exampleSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(exampleSet, useExampleWeights);
        this.rocData.add(this.rocDataGenerator.createROCData(exampleSet, useExampleWeights));
        this.auc = this.rocDataGenerator.calculateAUC(this.rocData.getLast());
        this.positiveClass = exampleSet.getAttributes().getPredictedLabel().getMapping().getPositiveString();
    }

    public void countExample(Example example) {
    }

    public double getExampleCount() {
        return 1.0;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public double getMikroAverage() {
        return this.auc / (double)this.counter;
    }

    public double getFitness() {
        return this.getAverage();
    }

    public String getName() {
        return "AUC";
    }

    public String getDescription() {
        return "The area under a ROC curve. Given example weights are also considered. Please note that the second class is considered to be positive.";
    }

    public void buildSingleAverage(Averagable performance) {
        AreaUnderCurve other = (AreaUnderCurve)performance;
        this.counter += other.counter;
        this.auc += other.auc;
        this.rocData.addAll(other.rocData);
    }

    public Component getVisualizationComponent(IOContainer ioContainer) {
        return new ROCViewer(this.toString(), this.rocDataGenerator, this.rocData);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (positive class: " + this.positiveClass + ")";
    }

    public void prepareRendering() {
        if (this.viewer == null) {
            this.viewer = new ROCViewer(this.toString(), this.rocDataGenerator, this.rocData);
        }
        this.viewer.prepareRendering();
    }

    public void finishRendering() {
        this.viewer = null;
    }

    public int getRenderHeight(int preferredHeight) {
        return this.viewer.getRenderHeight(preferredHeight);
    }

    public int getRenderWidth(int preferredWidth) {
        return this.viewer.getRenderWidth(preferredWidth);
    }

    public void render(Graphics graphics, int width, int height) {
        this.viewer.render(graphics, width, height);
    }
}

