/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.filter.Sorting;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.MathFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FillDataGaps
extends AbstractSeriesProcessing {
    public static final String PARAMETER_USE_GCD_FOR_STEP_SIZE = "use_gcd_for_step_size";
    public static final String PARAMETER_STEP_SIZE = "step_size";
    public static final String PARAMETER_START = "start";
    public static final String PARAMETER_END = "end";

    public FillDataGaps(OperatorDescription description) {
        super(description);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ExampleSet apply(ExampleSet inputSet) throws OperatorException {
        idAttribute = inputSet.getAttributes().getId();
        if (idAttribute == null) {
            throw new UserError(this, 129);
        }
        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(idAttribute.getValueType(), 9) && !Ontology.ATTRIBUTE_VALUE_TYPE.isA(idAttribute.getValueType(), 3)) {
            throw new UserError((Operator)this, 120, new Object[]{idAttribute.getName(), new Object[]{Ontology.VALUE_TYPE_NAMES[idAttribute.getValueType()], String.valueOf(Ontology.VALUE_TYPE_NAMES[9]) + " or " + Ontology.VALUE_TYPE_NAMES[3]}});
        }
        sorting = null;
        try {
            sorting = OperatorService.createOperator(Sorting.class);
        }
        catch (OperatorCreationException e) {
            throw new OperatorException(String.valueOf(this.getName()) + ": Cannot create discretization operator (" + e + ").");
        }
        sorting.setParameter("attribute_name", idAttribute.getName());
        sortedSet = sorting.apply(inputSet);
        stepSize = 1L;
        if (!this.getParameterAsBoolean("use_gcd_for_step_size")) {
            stepSize = this.getParameterAsInt("step_size");
        } else {
            distances = new LinkedList<Long>();
            first = true;
            lastValue = 0L;
            if (this.isParameterSet("start")) {
                first = false;
                lastValue = this.getParameterAsInt("start");
            }
            for (Example example : sortedSet) {
                value = (long)example.getValue(idAttribute);
                if (first) {
                    first = false;
                } else if (value > lastValue) {
                    distances.add(value - lastValue);
                }
                lastValue = value;
            }
            if (this.isParameterSet("end") && (long)(endValue = this.getParameterAsInt("end")) > lastValue) {
                distances.add((long)endValue - lastValue);
            }
            stepSize = MathFunctions.getGCD(distances);
            distances.clear();
        }
        missingValues = new LinkedList<Long>();
        lastValue = 0L;
        first = true;
        minValue = 0x7FFFFFFFFFFFFFFFL;
        maxValue = -9223372036854775807L;
        for (Example example : sortedSet) {
            value = (long)example.getValue(idAttribute);
            minValue = Math.min(minValue, value);
            maxValue = Math.max(maxValue, value);
            if (!first) ** GOTO lbl54
            first = false;
            lastValue = value;
            continue;
lbl-1000:
            // 1 sources

            {
                missingValues.add(lastValue += stepSize);
lbl54:
                // 2 sources

                ** while (lastValue + stepSize < value)
            }
lbl55:
            // 1 sources

            lastValue = value;
        }
        if (this.isParameterSet("start") && (start = (long)this.getParameterAsInt("start")) < minValue) {
            lastValue = start;
            while (lastValue + stepSize <= minValue) {
                missingValues.add(lastValue);
                lastValue += stepSize;
            }
        }
        if (this.isParameterSet("end") && (end = (long)this.getParameterAsInt("end")) > maxValue) {
            lastValue = maxValue + stepSize;
            while (lastValue <= end) {
                missingValues.add(lastValue);
                lastValue += stepSize;
            }
        }
        attributes = new ArrayList<Attribute>(sortedSet.getAttributes().allSize());
        specialAttributes = new HashMap<Attribute, String>();
        a = sortedSet.getAttributes().allAttributeRoles();
        idIndex = -1;
        index = 0;
        while (a.hasNext()) {
            role = a.next();
            cloneAttribute = (Attribute)role.getAttribute().clone();
            attributes.add(cloneAttribute);
            if (role.isSpecial()) {
                specialAttributes.put(cloneAttribute, role.getSpecialName());
                if (role.getSpecialName().equals("id")) {
                    idIndex = index;
                }
            }
            ++index;
        }
        table = new MemoryExampleTable(attributes);
        for (Example example : sortedSet) {
            data = new double[attributes.size()];
            index = 0;
            i = sortedSet.getAttributes().allAttributes();
            while (i.hasNext()) {
                data[index++] = example.getValue(i.next());
            }
            table.addDataRow(new DoubleArrayDataRow(data));
        }
        var23_30 = missingValues.iterator();
        while (var23_30.hasNext()) {
            missingValue = (Long)var23_30.next();
            data = new double[attributes.size()];
            d = 0;
            while (d < data.length) {
                data[d] = NaN;
                ++d;
            }
            data[idIndex] = missingValue;
            table.addDataRow(new DoubleArrayDataRow(data));
        }
        resultSet = table.createExampleSet(specialAttributes);
        resultSet = sorting.apply(new IOContainer(new IOObject[]{resultSet})).remove(ExampleSet.class);
        return resultSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_USE_GCD_FOR_STEP_SIZE, "Indicates if the greatest common divisor should be calculated and used as the underlying distance between all data points.", true));
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_STEP_SIZE, "The used step size for filling the gaps (only used if GCD calculation is not checked).", 1, Integer.MAX_VALUE, 1);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_GCD_FOR_STEP_SIZE, false, false));
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_START, "If this parameter is defined gaps at the beginning (if they occur) before the first data point will also be filled.", 1, Integer.MAX_VALUE, true));
        types.add(new ParameterTypeInt(PARAMETER_END, "If this parameter is defined gaps at the end (if they occur) after the last data point will also be filled.", 1, Integer.MAX_VALUE, true));
        return types;
    }
}

