/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.example.Attribute;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import java.util.Map;
import java.util.TreeMap;

public class MedianFunction
extends AbstractAggregationFunction {
    private TreeMap<Double, Double> valueWeightMap = new TreeMap();
    private double totalWeight;

    public MedianFunction() {
        this(true);
    }

    public MedianFunction(Boolean ignoreMissings) {
        super(ignoreMissings);
    }

    public String getName() {
        return "median";
    }

    protected void reset() {
        this.foundMissing = false;
        this.totalWeight = 0.0;
        if (this.valueWeightMap != null) {
            this.valueWeightMap.clear();
        }
    }

    public void update(double value, double weight) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        Double totalValueWeight = this.valueWeightMap.get(value);
        totalValueWeight = totalValueWeight != null ? Double.valueOf(totalValueWeight + weight) : new Double(weight);
        this.valueWeightMap.put(value, totalValueWeight);
        this.totalWeight += weight;
    }

    public void update(double value) {
        if (Double.isNaN(value)) {
            this.foundMissing = true;
            return;
        }
        Double totalValueWeight = this.valueWeightMap.get(value);
        totalValueWeight = totalValueWeight != null ? Double.valueOf(totalValueWeight + 1.0) : new Double(1.0);
        this.valueWeightMap.put(value, totalValueWeight);
        this.totalWeight += 1.0;
    }

    public double getValue() {
        if (this.foundMissing && !this.ignoreMissings) {
            return Double.NaN;
        }
        double valueWeightSum = 0.0;
        double lastValue = Double.NaN;
        double lastWeight = Double.NaN;
        for (Map.Entry<Double, Double> entry : this.valueWeightMap.entrySet()) {
            if (!Double.isNaN(lastValue) && !Double.isNaN(lastWeight)) {
                double thisWeight = entry.getValue();
                return (lastValue * lastWeight + entry.getKey() * thisWeight) / (lastWeight + thisWeight);
            }
            if ((valueWeightSum += entry.getValue().doubleValue()) > this.totalWeight / 2.0) {
                return entry.getKey();
            }
            if (valueWeightSum != this.totalWeight / 2.0) continue;
            lastWeight = entry.getValue();
            lastValue = entry.getKey();
        }
        return Double.NaN;
    }

    public boolean supportsAttribute(Attribute attribute) {
        return attribute.isNumerical();
    }
}

