/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import java.io.IOException;
import marytts.machinelearning.ClusteredDataGenerator;
import marytts.machinelearning.GMM;
import marytts.machinelearning.GMMTrainerParams;
import marytts.machinelearning.KMeansClusteringTrainer;
import marytts.machinelearning.KMeansClusteringTrainerParams;
import marytts.util.MaryUtils;
import marytts.util.io.FileUtils;
import marytts.util.io.MaryRandomAccessFile;
import marytts.util.math.DoubleMatrix;
import marytts.util.math.MathUtils;
import marytts.util.string.StringUtils;

public class GMMTrainer {
    public double[] logLikelihoods = null;

    public GMM train(double[][] x, GMMTrainerParams gmmParams) {
        long startTime = System.currentTimeMillis();
        GMM gmm = null;
        if (x != null && gmmParams.totalComponents > 0) {
            if (!MaryUtils.isWindows()) {
                gmmParams.useNativeCLibTrainer = false;
            }
            if (!gmmParams.useNativeCLibTrainer) {
                int featureDimension = x[0].length;
                for (int i = 1; i < x.length; ++i) {
                    assert (x[i].length == featureDimension);
                }
                KMeansClusteringTrainerParams kmeansParams = new KMeansClusteringTrainerParams(gmmParams);
                KMeansClusteringTrainer kmeansClusterer = new KMeansClusteringTrainer();
                kmeansClusterer.train(x, kmeansParams);
                GMM initialGmm = new GMM(kmeansClusterer);
                gmm = this.expectationMaximization(x, initialGmm, gmmParams.emMinIterations, gmmParams.emMaxIterations, gmmParams.isUpdateCovariances, gmmParams.tinyLogLikelihoodChangePercent, gmmParams.minCovarianceAllowed);
            } else {
                String strIsBigEndian = "1";
                String dataFile = StringUtils.getRandomFileName("d:/gmmTemp_", 8, ".dat");
                DoubleMatrix d = new DoubleMatrix(x);
                d.write(dataFile);
                String gmmFile = StringUtils.modifyExtension(dataFile, ".gmm");
                String logFile = StringUtils.modifyExtension(dataFile, ".log");
                String strCommand = "GMMTrainer.exe \"" + dataFile + "\" " + "\"" + gmmFile + "\" " + String.valueOf(gmmParams.totalComponents) + " " + strIsBigEndian + " " + String.valueOf(gmmParams.isDiagonalCovariance ? 1 : 0) + " " + String.valueOf(gmmParams.kmeansMaxIterations) + " " + String.valueOf(gmmParams.kmeansMinClusterChangePercent) + " " + String.valueOf(gmmParams.kmeansMinSamplesInOneCluster) + " " + String.valueOf(gmmParams.emMinIterations) + " " + String.valueOf(gmmParams.emMaxIterations) + " " + String.valueOf(gmmParams.isUpdateCovariances ? 1 : 0) + " " + String.valueOf(gmmParams.tinyLogLikelihoodChangePercent) + " " + String.valueOf(gmmParams.minCovarianceAllowed) + " " + "\"" + logFile + "\"";
                int exitVal = MaryUtils.shellExecute(strCommand, true);
                if (exitVal == 0) {
                    System.out.println("GMM training with native C library done...");
                    gmm = new GMM(gmmFile);
                    FileUtils.delete(gmmFile);
                } else {
                    System.out.println("Error executing native C library with exit code " + exitVal);
                }
                FileUtils.delete(dataFile);
            }
        }
        long endTime = System.currentTimeMillis();
        System.out.println("GMM training took " + String.valueOf((double)(endTime - startTime) / 1000.0) + " seconds...");
        return gmm;
    }

    public GMM expectationMaximization(double[][] x, GMM initialGmm, int emMinimumIterations, int emMaximumIterations, boolean isUpdateCovariances, double tinyLogLikelihoodChangePercent, double minimumCovarianceAllowed) {
        int k;
        int totalObservations = x.length;
        GMM gmm = new GMM(initialGmm);
        for (int i = 0; i < totalObservations; ++i) {
            assert (x[i].length == gmm.featureDimension);
        }
        int numIterations = 1;
        double error = 0.0;
        for (k = 0; k < gmm.totalComponents; ++k) {
            gmm.weights[k] = 1.0f / (float)gmm.totalComponents;
        }
        boolean bContinue = true;
        double[] zDenum = new double[totalObservations];
        double[][] zNum = new double[totalObservations][gmm.totalComponents];
        double[][] z = new double[totalObservations][gmm.totalComponents];
        double[] num1 = new double[gmm.featureDimension];
        double[] tmpMean = new double[gmm.featureDimension];
        double[][] num2 = new double[gmm.featureDimension][gmm.featureDimension];
        this.logLikelihoods = new double[emMaximumIterations];
        long end = 0L;
        long start = 0L;
        while (bContinue) {
            double tmp;
            double P_xj_tetak;
            int j;
            start = System.currentTimeMillis();
            for (j = 0; j < totalObservations; ++j) {
                zDenum[j] = 0.0;
                for (k = 0; k < gmm.totalComponents; ++k) {
                    P_xj_tetak = gmm.isDiagonalCovariance ? MathUtils.getGaussianPdfValue(x[j], gmm.components[k].meanVector, gmm.components[k].getCovMatrixDiagonal(), gmm.components[k].getConstantTerm()) : MathUtils.getGaussianPdfValue(x[j], gmm.components[k].meanVector, gmm.components[k].getInvCovMatrix(), gmm.components[k].getConstantTerm());
                    zNum[j][k] = gmm.weights[k] * P_xj_tetak;
                    zDenum[j] = zDenum[j] + zNum[j][k];
                }
            }
            for (j = 0; j < totalObservations; ++j) {
                for (k = 0; k < gmm.totalComponents; ++k) {
                    z[j][k] = zNum[j][k] / zDenum[j];
                }
            }
            for (k = 0; k < gmm.totalComponents; ++k) {
                double tmpSum = 0.0;
                for (j = 0; j < totalObservations; ++j) {
                    tmpSum += z[j][k];
                }
                gmm.weights[k] = tmpSum / (double)totalObservations;
            }
            double mean_diff = 0.0;
            for (k = 0; k < gmm.totalComponents; ++k) {
                double tmpZeroMean;
                int d2;
                int d1;
                for (d1 = 0; d1 < gmm.featureDimension; ++d1) {
                    num1[d1] = 0.0;
                    for (d2 = 0; d2 < gmm.featureDimension; ++d2) {
                        num2[d1][d2] = 0.0;
                    }
                }
                double denum = 0.0;
                for (j = 0; j < totalObservations; ++j) {
                    denum += z[j][k];
                    for (d1 = 0; d1 < gmm.featureDimension; ++d1) {
                        int n = d1;
                        num1[n] = num1[n] + x[j][d1] * z[j][k];
                        tmpZeroMean = x[j][d1] - gmm.components[k].meanVector[d1];
                        for (d2 = 0; d2 < gmm.featureDimension; ++d2) {
                            double[] dArray = num2[d1];
                            int n2 = d2;
                            dArray[n2] = dArray[n2] + z[j][k] * tmpZeroMean * (x[j][d2] - gmm.components[k].meanVector[d2]);
                        }
                    }
                }
                for (d1 = 0; d1 < gmm.featureDimension; ++d1) {
                    tmpMean[d1] = num1[d1] / denum;
                }
                double diffk = 0.0;
                for (d1 = 0; d1 < gmm.featureDimension; ++d1) {
                    tmpZeroMean = tmpMean[d1] - gmm.components[k].meanVector[d1];
                    diffk += tmpZeroMean * tmpZeroMean;
                }
                diffk = Math.sqrt(diffk);
                mean_diff += diffk;
                for (d1 = 0; d1 < gmm.featureDimension; ++d1) {
                    gmm.components[k].meanVector[d1] = tmpMean[d1];
                }
                if (!isUpdateCovariances) continue;
                if (gmm.isDiagonalCovariance) {
                    for (d1 = 0; d1 < gmm.featureDimension; ++d1) {
                        gmm.components[k].covMatrix[0][d1] = Math.max(num2[d1][d1] / denum, minimumCovarianceAllowed);
                    }
                } else {
                    for (d1 = 0; d1 < gmm.featureDimension; ++d1) {
                        for (d2 = 0; d2 < gmm.featureDimension; ++d2) {
                            gmm.components[k].covMatrix[d1][d2] = Math.max(num2[d1][d2] / denum, minimumCovarianceAllowed);
                        }
                    }
                }
                gmm.components[k].setDerivedValues();
            }
            if (numIterations == 1) {
                error = mean_diff;
            } else {
                double prevErr = error;
                error = mean_diff;
            }
            this.logLikelihoods[numIterations - 1] = 0.0;
            if (gmm.isDiagonalCovariance) {
                for (j = 0; j < totalObservations; ++j) {
                    tmp = 0.0;
                    for (k = 0; k < gmm.totalComponents; ++k) {
                        P_xj_tetak = MathUtils.getGaussianPdfValue(x[j], gmm.components[k].meanVector, gmm.components[k].getCovMatrixDiagonal(), gmm.components[k].getConstantTerm());
                        tmp += gmm.weights[k] * P_xj_tetak;
                    }
                    int n = numIterations - 1;
                    this.logLikelihoods[n] = this.logLikelihoods[n] + Math.log(tmp);
                }
            } else {
                for (j = 0; j < totalObservations; ++j) {
                    tmp = 0.0;
                    for (k = 0; k < gmm.totalComponents; ++k) {
                        P_xj_tetak = MathUtils.getGaussianPdfValue(x[j], gmm.components[k].meanVector, gmm.components[k].getInvCovMatrix(), gmm.components[k].getConstantTerm());
                        tmp += gmm.weights[k] * P_xj_tetak;
                    }
                    int n = numIterations - 1;
                    this.logLikelihoods[n] = this.logLikelihoods[n] + Math.log(tmp);
                }
            }
            end = System.currentTimeMillis();
            System.out.println("For " + String.valueOf(gmm.totalComponents) + " mixes - EM iteration no: " + String.valueOf(numIterations) + " with avg. difference in means " + String.valueOf(error) + " log-likelihood=" + String.valueOf(this.logLikelihoods[numIterations - 1]) + " in " + String.valueOf((double)(end - start) / 1000.0) + " sec");
            if (numIterations + 1 > emMaximumIterations || numIterations > emMinimumIterations && this.logLikelihoods[numIterations - 1] - this.logLikelihoods[numIterations - 2] < Math.abs(this.logLikelihoods[numIterations - 1] / 100.0 * tinyLogLikelihoodChangePercent)) break;
            ++numIterations;
        }
        double[] tmpLogLikelihoods = new double[numIterations - 1];
        System.arraycopy(this.logLikelihoods, 0, tmpLogLikelihoods, 0, numIterations - 1);
        this.logLikelihoods = new double[numIterations - 1];
        System.arraycopy(tmpLogLikelihoods, 0, this.logLikelihoods, 0, numIterations - 1);
        System.out.println("GMM training completed...");
        return gmm;
    }

    public static void testEndianFileIO() throws IOException {
        String cFile;
        boolean b1 = true;
        char c1 = 'c';
        short s1 = 111;
        int i1 = 222;
        double d1 = 33.3;
        float f1 = 44.4f;
        long l1 = 555L;
        String javaFile = "d:/endianJava.tmp";
        MaryRandomAccessFile fp = new MaryRandomAccessFile(javaFile, "rw");
        if (fp != null) {
            fp.writeBooleanEndian(b1);
            fp.writeCharEndian(c1);
            fp.writeShortEndian(s1);
            fp.writeIntEndian(i1);
            fp.writeDoubleEndian(d1);
            fp.writeFloatEndian(f1);
            fp.writeLongEndian(l1);
            fp.close();
        }
        if (FileUtils.exists(cFile = "d:/endianC.tmp")) {
            MaryRandomAccessFile fp2 = new MaryRandomAccessFile(cFile, "r");
            if (fp2 != null) {
                boolean b2 = fp2.readBooleanEndian();
                char c2 = fp2.readCharEndian();
                short s2 = fp2.readShortEndian();
                int i2 = fp2.readIntEndian();
                double d2 = fp2.readDoubleEndian();
                float f2 = fp2.readFloatEndian();
                long l2 = fp2.readLongEndian();
                fp2.close();
                if (b1 != b2) {
                    System.out.println("Error in bool!\n");
                }
                if (c1 != c2) {
                    System.out.println("Error in char!\n");
                }
                if (s1 != s2) {
                    System.out.println("Error in short!\n");
                }
                if (i1 != i2) {
                    System.out.println("Error in int!\n");
                }
                if (d1 != d2) {
                    System.out.println("Error in double!\n");
                }
                if (f1 != f2) {
                    System.out.println("Error in float!\n");
                }
                if (l1 != l2) {
                    System.out.println("Error in long!\n");
                }
            } else {
                System.out.println("C generated file cannot be opened...\n");
            }
        } else {
            System.out.println("C generated file not found...\n");
        }
    }

    public static void main(String[] args) {
        int i;
        int numClusters = 20;
        int numSamplesInClusters = 2000;
        double[] variances = new double[]{0.01};
        int vectorDim = 10;
        ClusteredDataGenerator[] c = new ClusteredDataGenerator[vectorDim];
        int totalVectors = 0;
        for (i = 0; i < vectorDim; ++i) {
            c[i] = i < variances.length ? new ClusteredDataGenerator(numClusters, numSamplesInClusters, 10.0 * (double)(i + 1), variances[i]) : new ClusteredDataGenerator(numClusters, numSamplesInClusters, 10.0 * (double)(i + 1), variances[0]);
        }
        totalVectors = c[0].data.length;
        double[][] x = new double[totalVectors][vectorDim];
        boolean counter = false;
        for (int n = 0; n < c.length; ++n) {
            for (i = 0; i < c[n].data.length; ++i) {
                x[i][n] = c[n].data[i];
            }
        }
        x = MathUtils.randomSort(x);
        double[] m = MathUtils.mean(x);
        double[] v = MathUtils.variance(x, m);
        System.out.println(String.valueOf(m[0]) + " " + String.valueOf(v[0]));
        GMMTrainerParams gmmParams = new GMMTrainerParams();
        gmmParams.totalComponents = numClusters;
        gmmParams.isDiagonalCovariance = true;
        gmmParams.kmeansMaxIterations = 100;
        gmmParams.kmeansMinClusterChangePercent = 0.01;
        gmmParams.kmeansMinSamplesInOneCluster = 10;
        gmmParams.emMinIterations = 100;
        gmmParams.emMaxIterations = 2000;
        gmmParams.isUpdateCovariances = true;
        gmmParams.tinyLogLikelihoodChangePercent = 0.001;
        gmmParams.minCovarianceAllowed = 1.0E-5;
        gmmParams.useNativeCLibTrainer = true;
        GMMTrainer g = new GMMTrainer();
        GMM gmm = g.train(x, gmmParams);
        if (gmm != null) {
            for (i = 0; i < gmm.totalComponents; ++i) {
                System.out.println("Gaussian #" + String.valueOf(i + 1) + " mean=" + String.valueOf(gmm.components[i].meanVector[0]) + " variance=" + String.valueOf(gmm.components[i].covMatrix[0][0]) + " prior=" + gmm.weights[i]);
            }
        }
    }
}

