/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.features.FeatureRegistry;
import marytts.features.FeatureVector;
import marytts.features.TargetFeatureComputer;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.Voice;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.UnitSelector;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class TargetFeatureLister
extends InternalModule {
    public TargetFeatureLister(MaryDataType outputType) {
        super("TargetFeatureLister", MaryDataType.ACOUSTPARAMS, outputType, null);
    }

    public TargetFeatureLister() {
        this(MaryDataType.TARGETFEATURES);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Element e;
        TargetFeatureComputer featureComputer;
        Voice voice = d.getDefaultVoice();
        String features = d.getOutputParams();
        if (voice != null) {
            featureComputer = FeatureRegistry.getTargetFeatureComputer(voice, features);
        } else {
            Locale locale = d.getLocale();
            assert (locale != null);
            featureComputer = FeatureRegistry.getTargetFeatureComputer(locale, features);
        }
        assert (featureComputer != null) : "Cannot get a feature computer!";
        Document doc = d.getDocument();
        TreeWalker tw = MaryDomUtils.createTreeWalker(doc, doc, "ph", "boundary");
        ArrayList<Element> segmentsAndBoundaries = new ArrayList<Element>();
        while ((e = (Element)tw.nextNode()) != null) {
            segmentsAndBoundaries.add(e);
        }
        String out = this.listTargetFeatures(featureComputer, segmentsAndBoundaries);
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setPlainText(out);
        return result;
    }

    public String listTargetFeatures(TargetFeatureComputer featureComputer, List<Element> segmentsAndBoundaries) {
        String pauseSymbol = featureComputer.getPauseSymbol();
        List<Target> targets = this.overridableCreateTargetsWithPauses(segmentsAndBoundaries, pauseSymbol);
        String header = featureComputer.getAllFeatureProcessorNamesAndValues();
        StringBuilder text = new StringBuilder();
        StringBuilder bin = new StringBuilder();
        for (Target target : targets) {
            FeatureVector features = featureComputer.computeFeatureVector(target);
            text.append(featureComputer.toStringValues(features)).append("\n");
            bin.append(features.toString()).append("\n");
        }
        String out = header + "\n" + text + "\n" + bin;
        return out;
    }

    public List<Target> getListTargetFeatures(TargetFeatureComputer featureComputer, List<Element> segmentsAndBoundaries) {
        String pauseSymbol = featureComputer.getPauseSymbol();
        List<Target> targets = this.overridableCreateTargetsWithPauses(segmentsAndBoundaries, pauseSymbol);
        for (Target target : targets) {
            FeatureVector features = featureComputer.computeFeatureVector(target);
            target.setFeatureVector(features);
        }
        return targets;
    }

    protected List<Target> overridableCreateTargetsWithPauses(List<Element> segmentsAndBoundaries, String pauseSymbol) {
        return TargetFeatureLister.createTargetsWithPauses(segmentsAndBoundaries, pauseSymbol);
    }

    public static List<Target> createTargetsWithPauses(List<Element> segmentsAndBoundaries, String silenceSymbol) {
        ArrayList<Target> targets = new ArrayList<Target>();
        if (segmentsAndBoundaries.size() == 0) {
            return targets;
        }
        Element last = segmentsAndBoundaries.get(segmentsAndBoundaries.size() - 1);
        if (!last.getTagName().equals("boundary")) {
            Element finalPause = MaryXML.createElement(last.getOwnerDocument(), "boundary");
            Element token = (Element)MaryDomUtils.getAncestor((Node)last, "t");
            Element parent = (Element)token.getParentNode();
            parent.appendChild(finalPause);
            segmentsAndBoundaries.add(finalPause);
        }
        for (Element sOrB : segmentsAndBoundaries) {
            String phone = UnitSelector.getPhoneSymbol(sOrB);
            targets.add(new Target(phone, sOrB));
        }
        return targets;
    }
}

