/*
 * Decompiled with CFR 0.152.
 */
package marytts.server.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import marytts.server.MaryProperties;
import marytts.server.http.FileRequestHandler;
import marytts.server.http.InfoRequestHandler;
import marytts.server.http.SynthesisRequestHandler;
import marytts.util.MaryUtils;
import org.apache.http.HttpException;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.protocol.BufferingHttpServiceHandler;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.log4j.Logger;

public class MaryHttpServer
extends Thread {
    private static Logger logger;
    private boolean isReady = false;

    public MaryHttpServer() {
        logger = MaryUtils.getLogger("server");
    }

    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public void run() {
        logger.info("Starting server.");
        int localPort = MaryProperties.needInteger("socket.port");
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", 0).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", "HttpComponents/1.1");
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor(new ResponseDate());
        httpproc.addInterceptor(new ResponseServer());
        httpproc.addInterceptor(new ResponseContent());
        httpproc.addInterceptor(new ResponseConnControl());
        BufferingHttpServiceHandler handler = new BufferingHttpServiceHandler(httpproc, new DefaultHttpResponseFactory(), new DefaultConnectionReuseStrategy(), params);
        HttpRequestHandlerRegistry registry = new HttpRequestHandlerRegistry();
        registry.register("/process", new SynthesisRequestHandler());
        InfoRequestHandler infoRH = new InfoRequestHandler();
        registry.register("/version", infoRH);
        registry.register("/datatypes", infoRH);
        registry.register("/locales", infoRH);
        registry.register("/voices", infoRH);
        registry.register("/audioformats", infoRH);
        registry.register("/exampletext", infoRH);
        registry.register("/audioeffects", infoRH);
        registry.register("/audioeffect-default-param", infoRH);
        registry.register("/audioeffect-full", infoRH);
        registry.register("/audioeffect-help", infoRH);
        registry.register("/audioeffect-is-hmm-effect", infoRH);
        registry.register("/features", infoRH);
        registry.register("/features-discrete", infoRH);
        registry.register("/vocalizations", infoRH);
        registry.register("/styles", infoRH);
        registry.register("*", new FileRequestHandler());
        handler.setHandlerResolver(registry);
        handler.setEventListener(new EventLogger());
        DefaultServerIOEventDispatch ioEventDispatch = new DefaultServerIOEventDispatch(handler, params);
        int numParallelThreads = MaryProperties.getInteger("server.http.parallelthreads", 5);
        logger.info("Waiting for client to connect on port " + localPort);
        try {
            DefaultListeningIOReactor ioReactor = new DefaultListeningIOReactor(numParallelThreads, params);
            ioReactor.listen(new InetSocketAddress(localPort));
            this.isReady = true;
            ioReactor.execute(ioEventDispatch);
        }
        catch (InterruptedIOException ex) {
            logger.info("Interrupted", ex);
        }
        catch (IOException e) {
            logger.info("Problem with HTTP connection", e);
        }
        logger.debug("Shutdown");
    }

    static class EventLogger
    implements EventListener {
        EventLogger() {
        }

        @Override
        public void connectionOpen(NHttpConnection conn) {
            logger.info("Connection from " + conn.getContext().getAttribute("http.target_host"));
        }

        @Override
        public void connectionTimeout(NHttpConnection conn) {
            logger.info("Connection timed out: " + conn);
        }

        @Override
        public void connectionClosed(NHttpConnection conn) {
            logger.info("Connection closed: " + conn);
        }

        @Override
        public void fatalIOException(IOException ex, NHttpConnection conn) {
            logger.info("I/O error: " + ex.getMessage());
        }

        @Override
        public void fatalProtocolException(HttpException ex, NHttpConnection conn) {
            logger.info("HTTP error: " + ex.getMessage());
        }
    }
}

