/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.smoothing;

import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.util.io.FileUtils;
import marytts.util.io.MaryRandomAccessFile;

public class SmoothingFile {
    public static final int NOT_OPENED = 0;
    public static final int OPEN_FOR_WRITE = 1;
    public static final int OPEN_FOR_READ = 2;
    private MaryRandomAccessFile stream = null;
    public int status = 0;
    private int totalEntries = 0;
    public int smoothingMethod;

    public SmoothingFile(String filename, int desiredStatus) {
        this(filename, desiredStatus, 0);
    }

    public SmoothingFile(String filename, int desiredStatus, int smoothingMethodIn) {
        this.smoothingMethod = smoothingMethodIn;
        if (desiredStatus == 2) {
            this.status = desiredStatus;
            try {
                this.stream = new MaryRandomAccessFile(filename, "r");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (desiredStatus == 1) {
            FileUtils.delete(filename);
            this.status = desiredStatus;
            try {
                this.stream = new MaryRandomAccessFile(filename, "rw");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeHeader() {
        if (this.status == 1) {
            try {
                this.stream.seek(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.stream.writeInt(this.totalEntries);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.stream.writeInt(this.smoothingMethod);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void readHeader() {
        if (this.status == 2) {
            try {
                this.stream.seek(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.totalEntries = this.stream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.smoothingMethod = this.stream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeSingle(double[] x) {
        this.writeSingle(x, x.length);
    }

    public void writeSingle(double[] x, int len) {
        try {
            this.stream.writeInt(Math.min(x.length, len));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.stream.writeDouble(x, 0, Math.min(x.length, len));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.incrementTotalEntries();
    }

    public void writeAll(double[][] x) {
        this.totalEntries = 0;
        this.writeHeader();
        for (int i = 0; i < x.length; ++i) {
            this.writeSingle(x[i]);
        }
        this.close();
    }

    public void incrementTotalEntries() {
        if (this.status == 1) {
            try {
                long currentPos = this.stream.getFilePointer();
                this.stream.seek(0L);
                this.totalEntries = this.stream.readInt();
                ++this.totalEntries;
                this.stream.seek(0L);
                this.stream.writeInt(this.totalEntries);
                this.stream.seek(currentPos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public double[] readSingle() {
        double[] x = null;
        if (this.status == 2) {
            int len = 0;
            try {
                len = this.stream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (len > 0) {
                try {
                    x = this.stream.readDouble(len);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return x;
    }

    public double[][] readAll() {
        Object x = null;
        if (this.status == 2) {
            this.readHeader();
            if (this.totalEntries > 0) {
                x = new double[this.totalEntries][];
                for (int i = 0; i < this.totalEntries; ++i) {
                    x[i] = this.readSingle();
                }
            }
            this.close();
        }
        return x;
    }

    public void close() {
        if (this.status != 0) {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.stream = null;
            this.status = 0;
        }
    }
}

