/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.ArrayList;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.process.PitchFrameProvider;
import marytts.signalproc.window.DynamicWindow;
import marytts.util.data.DoubleDataSource;

public abstract class PitchFrameAnalyser
extends PitchFrameProvider {
    protected DynamicWindow analysisWindow;
    protected FrameBasedAnalyser.FrameAnalysisResult[] analysisResults;

    public PitchFrameAnalyser(DoubleDataSource signal, DoubleDataSource pitchmarks, int windowType, int samplingRate) {
        this(signal, pitchmarks, windowType, samplingRate, 1, 1);
    }

    public PitchFrameAnalyser(DoubleDataSource signal, DoubleDataSource pitchmarks, int windowType, int samplingRate, int framePeriods, int shiftPeriods) {
        super(signal, pitchmarks, new DynamicWindow(windowType), samplingRate, framePeriods, shiftPeriods);
    }

    public FrameBasedAnalyser.FrameAnalysisResult analyseNextFrame() {
        double[] frame = this.getNextFrame();
        if (frame == null) {
            return null;
        }
        this.analysisWindow.applyInline(frame, 0, frame.length);
        Object analysisResult = this.analyse(frame);
        return this.constructAnalysisResult(analysisResult);
    }

    public FrameBasedAnalyser.FrameAnalysisResult[] analyseAllFrames() {
        if (this.analysisResults == null) {
            FrameBasedAnalyser.FrameAnalysisResult oneResult;
            ArrayList<FrameBasedAnalyser.FrameAnalysisResult> results = new ArrayList<FrameBasedAnalyser.FrameAnalysisResult>();
            while ((oneResult = this.analyseNextFrame()) != null) {
                results.add(oneResult);
            }
            this.analysisResults = results.toArray(new FrameBasedAnalyser.FrameAnalysisResult[0]);
        }
        return this.analysisResults;
    }

    public FrameBasedAnalyser.FrameAnalysisResult[] analyseAvailableFrames() {
        ArrayList<FrameBasedAnalyser.FrameAnalysisResult> results = new ArrayList<FrameBasedAnalyser.FrameAnalysisResult>();
        while (this.signal.available() >= this.frameLength) {
            FrameBasedAnalyser.FrameAnalysisResult oneResult = this.analyseNextFrame();
            assert (oneResult != null);
            results.add(oneResult);
        }
        return results.toArray(new FrameBasedAnalyser.FrameAnalysisResult[0]);
    }

    public abstract Object analyse(double[] var1);

    protected FrameBasedAnalyser.FrameAnalysisResult constructAnalysisResult(Object analysisResult) {
        return new FrameBasedAnalyser.FrameAnalysisResult<Object>(this.frame, this.getFrameStartTime(), analysisResult);
    }
}

