/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.util.Arrays;
import marytts.signalproc.analysis.PitchMarks;
import marytts.util.data.DoubleDataSource;
import marytts.util.signal.SignalProcUtils;

public class PsolaFrameProvider {
    protected double[] buffer;
    protected DoubleDataSource input;
    protected int index;
    protected int numPeriods;
    protected PitchMarks pitchMarker;
    protected int frmSize;
    protected int prevFrmSize;
    protected int remain;
    protected int fromBuffer;
    private boolean isFixedRate;
    private int wsFixedLen;
    private int ssFixedLen;
    private int totalFixedFrames;
    private double currentTimeInSeconds;
    private int samplingRate;

    public PsolaFrameProvider(DoubleDataSource inputSource, PitchMarks pm, int fs, int psPeriods) {
        this.input = inputSource;
        this.numPeriods = psPeriods;
        this.pitchMarker = pm;
        this.samplingRate = fs;
        int maxFrmSize = (int)((double)(this.numPeriods * fs) / 40.0);
        if (maxFrmSize % 2 != 0) {
            ++maxFrmSize;
        }
        this.buffer = new double[maxFrmSize];
        Arrays.fill(this.buffer, 0.0);
        this.index = -1;
        this.isFixedRate = false;
        this.totalFixedFrames = 0;
        this.currentTimeInSeconds = -1.0;
    }

    public PsolaFrameProvider(DoubleDataSource inputSource, double fixedWindowSizeInSeconds, double fixedSkipSizeInSeconds, int fs, int totalFrames) {
        this.input = inputSource;
        this.numPeriods = -1;
        this.pitchMarker = null;
        this.samplingRate = fs;
        this.wsFixedLen = (int)Math.floor(fixedWindowSizeInSeconds * (double)fs + 0.5);
        if (this.wsFixedLen % 2 != 0) {
            ++this.wsFixedLen;
        }
        if (this.wsFixedLen < 4) {
            this.wsFixedLen = 4;
        }
        this.frmSize = this.wsFixedLen;
        this.ssFixedLen = (int)Math.floor(fixedSkipSizeInSeconds * (double)fs + 0.5);
        int maxFrmSize = this.wsFixedLen;
        this.buffer = new double[maxFrmSize];
        Arrays.fill(this.buffer, 0.0);
        this.index = -1;
        this.isFixedRate = true;
        this.totalFixedFrames = totalFrames;
        this.currentTimeInSeconds = -1.0;
    }

    public double[] getNextFrame() {
        double[] y = null;
        if (!this.isFixedRate) {
            ++this.index;
            if (this.index + this.numPeriods < this.pitchMarker.pitchMarks.length) {
                this.frmSize = this.pitchMarker.pitchMarks[this.index + this.numPeriods] - this.pitchMarker.pitchMarks[this.index] + 1;
                this.currentTimeInSeconds = SignalProcUtils.sample2time((int)(0.5 * (double)(this.pitchMarker.pitchMarks[this.index + this.numPeriods] + this.pitchMarker.pitchMarks[this.index] + 1)), this.samplingRate);
                if (this.frmSize % 2 != 0) {
                    ++this.frmSize;
                }
                if (this.frmSize < 4) {
                    this.frmSize = 4;
                }
                y = new double[this.frmSize];
                if (this.index == 0) {
                    this.input.getData(y, 0, this.frmSize);
                } else {
                    this.fromBuffer = this.prevFrmSize - (this.pitchMarker.pitchMarks[this.index] - this.pitchMarker.pitchMarks[this.index - 1]);
                    System.arraycopy(this.buffer, this.pitchMarker.pitchMarks[this.index] - this.pitchMarker.pitchMarks[this.index - 1], y, 0, this.fromBuffer);
                    this.remain = this.frmSize - this.fromBuffer;
                    this.input.getData(y, this.fromBuffer, this.remain);
                }
                System.arraycopy(y, 0, this.buffer, 0, this.frmSize);
                this.prevFrmSize = this.frmSize;
            }
        } else {
            ++this.index;
            if (this.index < this.totalFixedFrames) {
                y = new double[this.frmSize];
                if (this.index == 0) {
                    this.input.getData(y, 0, this.frmSize);
                } else {
                    System.arraycopy(this.buffer, this.prevFrmSize - this.ssFixedLen, y, 0, this.ssFixedLen);
                    this.remain = this.frmSize - this.ssFixedLen;
                    this.input.getData(y, this.ssFixedLen, this.remain);
                }
                this.currentTimeInSeconds = SignalProcUtils.sample2time((int)((double)(this.index * this.ssFixedLen) + 0.5 * (double)this.frmSize), this.samplingRate);
                System.arraycopy(y, 0, this.buffer, 0, this.frmSize);
                this.prevFrmSize = this.frmSize;
            }
        }
        return y;
    }

    public double getCurrentTime() {
        return this.currentTimeInSeconds;
    }
}

