/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.concat;

import marytts.signalproc.window.DynamicTwoHalvesWindow;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.DoubleDataSource;

public class DatagramOverlapDoubleDataSource
extends BufferedDoubleDataSource {
    protected Datagram[][] datagrams;
    protected Datagram[] rightContexts;
    protected int p;
    protected int q;
    protected int totalRead;

    public DatagramOverlapDoubleDataSource(Datagram[][] datagrams, Datagram[] rightContexts) {
        super((DoubleDataSource)null);
        this.datagrams = datagrams;
        this.rightContexts = rightContexts;
        this.dataLength = 0L;
        for (int i = 0; i < datagrams.length; ++i) {
            for (int j = 0; j < datagrams[i].length; ++j) {
                this.dataLength += datagrams[i][j].getDuration();
            }
        }
        this.p = 0;
        this.q = 0;
    }

    @Override
    public boolean hasMoreData() {
        return this.currentlyInBuffer() > 0 || (long)this.totalRead < this.dataLength;
    }

    @Override
    public int available() {
        int available = (int)((long)this.currentlyInBuffer() + this.dataLength - (long)this.totalRead);
        return available;
    }

    @Override
    protected boolean readIntoBuffer(int minLength) {
        if (this.bufferSpaceLeft() < minLength) {
            this.increaseBufferSize(minLength + this.currentlyInBuffer());
        } else if (this.buf.length - this.writePos < minLength) {
            this.compact();
        }
        int readSum = 0;
        while (readSum < minLength && this.p < this.datagrams.length) {
            if (this.q >= this.datagrams[this.p].length) {
                ++this.p;
                this.q = 0;
                continue;
            }
            Datagram next = this.datagrams[this.p][this.q];
            int length = (int)next.getDuration();
            if (this.buf.length < this.writePos + length) {
                this.increaseBufferSize(this.writePos + length);
            }
            int read = this.readDatagram(next, this.buf, this.writePos);
            if (this.q == 0 && this.p > 0 && this.rightContexts[this.p - 1] != null) {
                new DynamicTwoHalvesWindow(3).applyInlineLeftHalf(this.buf, this.writePos, read);
                double[] context = new double[(int)this.rightContexts[this.p - 1].getDuration()];
                this.readDatagram(this.rightContexts[this.p - 1], context, 0);
                new DynamicTwoHalvesWindow(3).applyInlineRightHalf(context, 0, context.length);
                int iMax = Math.min(read, context.length);
                for (int i = 0; i < iMax; ++i) {
                    int n = this.writePos + i;
                    this.buf[n] = this.buf[n] + context[i];
                }
            }
            this.writePos += read;
            readSum += read;
            this.totalRead += read;
            ++this.q;
        }
        if (this.dataProcessor != null) {
            this.dataProcessor.applyInline(this.buf, this.writePos - readSum, readSum);
        }
        return readSum >= minLength;
    }

    protected int readDatagram(Datagram d, double[] target, int pos) {
        int dur = (int)d.getDuration();
        byte[] frameAudio = d.getData();
        assert (frameAudio.length / 2 == dur) : "expected datagram data length to be " + dur * 2 + ", found " + frameAudio.length;
        int i = 0;
        while (i < frameAudio.length) {
            byte lobyte = frameAudio[i + 1];
            byte hibyte = frameAudio[i];
            int sample = hibyte << 8 | lobyte & 0xFF;
            target[pos] = (double)sample / 32768.0;
            i += 2;
            ++pos;
        }
        return dur;
    }
}

