/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select;

import java.io.IOException;
import java.io.InputStream;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureVector;
import marytts.unitselection.data.DiphoneUnit;
import marytts.unitselection.data.FeatureFileReader;
import marytts.unitselection.data.HalfPhoneFeatureFileReader;
import marytts.unitselection.data.Unit;
import marytts.unitselection.select.DiphoneTarget;
import marytts.unitselection.select.FFRTargetCostFunction;
import marytts.unitselection.select.HalfPhoneFFRTargetCostFunction;
import marytts.unitselection.select.HalfPhoneTarget;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.TargetCostFunction;

public class DiphoneFFRTargetCostFunction
implements TargetCostFunction {
    protected FFRTargetCostFunction tcfForHalfphones;

    @Override
    public void load(String featureFileName, InputStream weightsStream, FeatureProcessorManager featProc) throws IOException, MaryConfigurationException {
        FeatureFileReader ffr = FeatureFileReader.getFeatureFileReader(featureFileName);
        this.load(ffr, weightsStream, featProc);
    }

    @Override
    public void load(FeatureFileReader ffr, InputStream weightsStream, FeatureProcessorManager featProc) throws IOException {
        this.tcfForHalfphones = ffr instanceof HalfPhoneFeatureFileReader ? new HalfPhoneFFRTargetCostFunction() : new FFRTargetCostFunction();
        this.tcfForHalfphones.load(ffr, weightsStream, featProc);
    }

    @Override
    public FeatureDefinition getFeatureDefinition() {
        return this.tcfForHalfphones.getFeatureDefinition();
    }

    @Override
    public String getFeature(Unit unit, String featureName) {
        return this.tcfForHalfphones.getFeature(unit, featureName);
    }

    @Override
    public FeatureVector getFeatureVector(Unit unit) {
        return this.tcfForHalfphones.featureVectors[unit.index];
    }

    @Override
    public double cost(Target target, Unit unit) {
        if (target instanceof HalfPhoneTarget) {
            return this.tcfForHalfphones.cost(target, unit);
        }
        if (!(target instanceof DiphoneTarget)) {
            throw new IllegalArgumentException("This target cost function can only be called for diphone and half-phone targets!");
        }
        if (!(unit instanceof DiphoneUnit)) {
            throw new IllegalArgumentException("Diphone targets need diphone units!");
        }
        DiphoneTarget dt = (DiphoneTarget)target;
        DiphoneUnit du = (DiphoneUnit)unit;
        return this.tcfForHalfphones.cost(dt.left, du.left) + this.tcfForHalfphones.cost(dt.right, du.right);
    }

    @Override
    public void computeTargetFeatures(Target target) {
        if (!(target instanceof DiphoneTarget)) {
            this.tcfForHalfphones.computeTargetFeatures(target);
        } else {
            DiphoneTarget dt = (DiphoneTarget)target;
            this.tcfForHalfphones.computeTargetFeatures(dt.left);
            this.tcfForHalfphones.computeTargetFeatures(dt.right);
        }
    }

    @Override
    public FeatureVector[] getFeatureVectors() {
        if (this.tcfForHalfphones != null) {
            return this.tcfForHalfphones.getFeatureVectors();
        }
        return null;
    }
}

