/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.File;
import java.io.FileReader;
import opennlp.maxent.BasicEventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.RealBasicEventStream;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractEventStream;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelWriter;
import opennlp.model.OnePassDataIndexer;
import opennlp.model.OnePassRealValueDataIndexer;
import opennlp.perceptron.PerceptronTrainer;
import opennlp.perceptron.SuffixSensitivePerceptronModelWriter;

public class ModelTrainer {
    public static boolean USE_SMOOTHING = false;
    public static double SMOOTHING_OBSERVATION = 0.1;

    private static void usage() {
        System.err.println("java ModelTrainer [-real] dataFile modelFile");
        System.exit(1);
    }

    public static void main(String[] args) {
        int ai = 0;
        boolean real = false;
        String type = "maxent";
        int maxit = 100;
        int cutoff = 1;
        double sigma = 1.0;
        if (args.length == 0) {
            ModelTrainer.usage();
        }
        while (args[ai].startsWith("-")) {
            if (args[ai].equals("-real")) {
                real = true;
            } else if (args[ai].equals("-perceptron")) {
                type = "perceptron";
            } else if (args[ai].equals("-maxit")) {
                maxit = Integer.parseInt(args[++ai]);
            } else if (args[ai].equals("-cutoff")) {
                cutoff = Integer.parseInt(args[++ai]);
            } else if (args[ai].equals("-sigma")) {
                sigma = Double.parseDouble(args[++ai]);
            } else {
                System.err.println("Unknown option: " + args[ai]);
                ModelTrainer.usage();
            }
            ++ai;
        }
        String dataFileName = new String(args[ai++]);
        String modelFileName = new String(args[ai]);
        try {
            AbstractModelWriter writer;
            FileReader datafr = new FileReader(new File(dataFileName));
            AbstractEventStream es = !real ? new BasicEventStream(new PlainTextByLineDataStream(datafr), ",") : new RealBasicEventStream(new PlainTextByLineDataStream(datafr));
            File outputFile = new File(modelFileName);
            if (type.equals("maxent")) {
                GIS.SMOOTHING_OBSERVATION = SMOOTHING_OBSERVATION;
                GISModel model = !real ? GIS.trainModel(es, maxit, cutoff, sigma) : GIS.trainModel(maxit, new OnePassRealValueDataIndexer(es, cutoff), USE_SMOOTHING);
                writer = new SuffixSensitiveGISModelWriter(model, outputFile);
            } else if (type.equals("perceptron")) {
                AbstractModel model = new PerceptronTrainer().trainModel(maxit, new OnePassDataIndexer(es, cutoff), cutoff);
                writer = new SuffixSensitivePerceptronModelWriter(model, outputFile);
            } else {
                throw new RuntimeException("Unknown model type: " + type);
            }
            ((AbstractModelWriter)writer).persist();
        }
        catch (Exception e) {
            System.out.print("Unable to create model due to exception: ");
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

