/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDisk
extends RowStoreAVL {
    DataFileCache cache;
    RowOutputInterface rowOut;
    Database database;

    public RowStoreAVLDisk(PersistentStoreCollection persistentStoreCollection, DataFileCache dataFileCache, Table table) {
        this.database = table.database;
        this.manager = persistentStoreCollection;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.cache = dataFileCache;
        if (dataFileCache != null) {
            this.rowOut = dataFileCache.rowOut.duplicate();
        }
        persistentStoreCollection.setStore(table, this);
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public int getAccessCount() {
        return this.cache.getAccessCount();
    }

    @Override
    public void set(CachedObject cachedObject) {
        Row row = (Row)cachedObject;
        this.database.txManager.setTransactionInfo(row);
    }

    @Override
    public CachedObject get(int n) {
        CachedObject cachedObject = this.cache.get(n, (PersistentStore)this, false);
        return cachedObject;
    }

    @Override
    public CachedObject getKeep(int n) {
        CachedObject cachedObject = this.cache.get(n, (PersistentStore)this, true);
        return cachedObject;
    }

    @Override
    public CachedObject get(int n, boolean bl) {
        CachedObject cachedObject = this.cache.get(n, (PersistentStore)this, bl);
        return cachedObject;
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        cachedObject = this.cache.get(cachedObject, (PersistentStore)this, bl);
        return cachedObject;
    }

    @Override
    public int getStorageSize(int n) {
        return this.cache.get(n, (PersistentStore)this, false).getStorageSize();
    }

    @Override
    public void add(CachedObject cachedObject) {
        int n = cachedObject.getRealSize(this.rowOut);
        n = this.rowOut.getStorageSize(n);
        cachedObject.setStorageSize(n);
        this.cache.add(cachedObject);
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            return new RowAVLDisk(this.table, rowInputInterface);
        }
        catch (IOException iOException) {
            throw Error.error(466, iOException);
        }
    }

    @Override
    public CachedObject getNewInstance(int n) {
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object) {
        RowAVLDisk rowAVLDisk = new RowAVLDisk(this.table, (Object[])object);
        this.add(rowAVLDisk);
        if (session != null) {
            RowAction rowAction;
            rowAVLDisk.rowAction = rowAction = new RowAction(session, this.table, 1, rowAVLDisk, null);
        }
        return rowAVLDisk;
    }

    @Override
    public void indexRow(Session session, Row row) {
        int n;
        try {
            for (n = 0; n < this.indexList.length; ++n) {
                this.indexList[n].insert(session, this, row);
            }
        }
        catch (HsqlException hsqlException) {
            --n;
            while (n >= 0) {
                this.indexList[n].delete(session, this, row);
                --n;
            }
            this.remove(row.getPos());
            this.database.txManager.removeTransactionInfo(row);
            throw hsqlException;
        }
    }

    @Override
    public void removeAll() {
        this.elementCount = 0;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int n) {
        this.cache.remove(n, this);
    }

    @Override
    public void removePersistence(int n) {
    }

    @Override
    public void release(int n) {
        this.cache.release(n);
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        Object[] objectArray = row.getData();
        switch (n) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, objectArray);
                if (n2 != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, (Table)this.table, objectArray);
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
                this.database.txManager.removeTransactionInfo(row);
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                row = (Row)this.get(row, true);
                ((RowAVL)row).setNewNodes();
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.cache = null;
    }

    @Override
    public CachedObject getAccessor(Index index) {
        NodeAVL nodeAVL = (NodeAVL)this.accessorList[index.getPosition()];
        if (nodeAVL == null) {
            return null;
        }
        if (!nodeAVL.isInMemory()) {
            RowAVL rowAVL = (RowAVL)this.get(nodeAVL.getPos(), false);
            nodeAVL = rowAVL.getNode(index.getPosition());
            this.accessorList[index.getPosition()] = nodeAVL;
        }
        return nodeAVL;
    }

    @Override
    public void setAccessor(Index index, CachedObject cachedObject) {
        Index index2 = index;
        this.accessorList[index2.getPosition()] = cachedObject;
    }

    @Override
    public void setAccessor(Index index, int n) {
        CachedObject cachedObject = this.get(n, false);
        if (cachedObject != null) {
            NodeAVL nodeAVL = ((RowAVL)cachedObject).getNode(index.getPosition());
            cachedObject = nodeAVL;
        }
        this.setAccessor(index, cachedObject);
    }

    @Override
    public void resetAccessorKeys(Index[] indexArray) {
        if (this.indexList.length == 0 || this.indexList[0] == null || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public int elementCount(Session session) {
        Index index = this.indexList[0];
        if (this.elementCount < 0) {
            this.elementCount = index == null ? 0 : ((IndexAVL)index).getNodeCount(session, this);
        }
        if (session != null && index != null && this.database.txManager.getTransactionControl() != 0) {
            return ((IndexAVL)index).getNodeCount(session, this);
        }
        return this.elementCount;
    }

    @Override
    public void lock() {
        this.cache.writeLock.lock();
    }

    @Override
    public void unlock() {
        this.cache.writeLock.unlock();
    }
}

