/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HmmReader {
    public static <O extends Observation> Hmm<O> read(Reader reader, OpdfReader<? extends Opdf<O>> opdfReader) throws IOException, FileFormatException {
        StreamTokenizer st = new StreamTokenizer(reader);
        HmmReader.initSyntaxTable(st);
        HmmReader.readWords(st, "Hmm", "v1.0", "NbStates");
        int nbStates = (int)HmmReader.readNumber(st);
        double[] pi = new double[nbStates];
        double[][] a = new double[nbStates][nbStates];
        ArrayList<Opdf<O>> opdfs = new ArrayList<Opdf<O>>(nbStates);
        int i = 0;
        while (i < nbStates) {
            HmmReader.readState(st, nbStates, i, pi, a, opdfs, opdfReader);
            ++i;
        }
        return new Hmm(pi, a, opdfs);
    }

    private static <O extends Observation> void readState(StreamTokenizer st, int nbStates, int stateNb, double[] pi, double[][] a, List<Opdf<O>> opdfs, OpdfReader<? extends Opdf<O>> opdfReader) throws IOException, FileFormatException {
        HmmReader.readWords(st, "State", "Pi");
        pi[stateNb] = HmmReader.readNumber(st);
        HmmReader.readWords(st, "A");
        int i = 0;
        while (i < nbStates) {
            a[stateNb][i] = HmmReader.readNumber(st);
            ++i;
        }
        opdfs.add(opdfReader.read(st));
    }

    static void readWords(StreamTokenizer st, String ... words) throws IOException, FileFormatException {
        String[] stringArray = words;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String word = stringArray[n];
            st.nextToken();
            if (st.ttype == -3) {
                if (!st.sval.equals(word)) {
                    throw new FileFormatException(st.lineno(), "Syntax error: unexpected token '" + st.sval + "', ('" + word + "' expected)");
                }
            } else if (st.ttype > 0) {
                if (word.length() != 1 || st.ttype != word.charAt(0)) {
                    throw new FileFormatException(st.lineno(), "Syntax error: unexpected token '" + (char)st.ttype + "' (" + word + "' expected)");
                }
            } else {
                throw new FileFormatException(st.lineno(), "Syntax error: '" + word + "' expected");
            }
            ++n;
        }
    }

    static double readNumber(StreamTokenizer st) throws IOException, FileFormatException {
        st.nextToken();
        if (st.ttype != -2) {
            throw new FileFormatException(st.lineno(), "Syntax error: number expected");
        }
        return st.nval;
    }

    static void initSyntaxTable(StreamTokenizer st) {
        st.resetSyntax();
        st.parseNumbers();
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.whitespaceChars(0, 32);
        st.whitespaceChars(9, 9);
        st.eolIsSignificant(false);
        st.commentChar(35);
    }
}

