/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.test;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfInteger;
import be.ac.ulg.montefiore.run.jahmm.OpdfIntegerFactory;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.HmmBinaryReader;
import be.ac.ulg.montefiore.run.jahmm.io.HmmBinaryWriter;
import be.ac.ulg.montefiore.run.jahmm.io.HmmReader;
import be.ac.ulg.montefiore.run.jahmm.io.HmmWriter;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationIntegerReader;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationSequencesReader;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationVectorReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfGaussianMixtureReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfGaussianMixtureWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfGaussianReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfGaussianWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfIntegerReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfIntegerWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfMultiGaussianReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfMultiGaussianWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfWriter;
import be.ac.ulg.montefiore.run.jahmm.test.GaussianTest;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOTest
extends TestCase {
    protected final String integerSequences = "# A simple data file with integer observations.\n1;2;3; # The first sequence\n# And the second one\n2;4;5;\n\n# A big one, spawning on multiple lines\n1;2;3; \\\n2;4;5; # Don't forget to end the file with a newline\n";
    protected final String vectorSequences = "[ 1.1 2.2 ] ; [ 4.4 5.5 ] ; [ 4.3 6.0 ] ; [ 7.7 8.8 ] ;\n[ 0.5 1.5 ] ; [ 1.5 2.5 ] ; [ 4.5 5.5 ] ; [ 8. 8. ] ; [ 7. 8. ] ;\n";
    protected final String hmmString = "# A simple Hmm\nHmm v1.0\nNbStates 2\n\nState Pi 0.7\nA 0.1 0.9\nIntegerOPDF [ .2 .3 .4 .1 ]\n\nState Pi 0.3\nA 0.4 0.6\nIntegerOPDF [ .1 .1 .1 .7 ]";
    protected final String integerOPDFString = "IntegerOPDF [ .32 .68 ]";
    protected final String gaussianOPDFString = "GaussianOPDF [ 1.2 .3 ]";
    protected final String gaussianMixtureOPDFString = "GaussianMixtureOPDF [ [ 1.2 2. ] [ .1 .9 ] [ .4 .6 ] ]";
    protected final String multiGaussianOPDFString = "MultiGaussianOPDF [ [ 5. 5. ] [ [ 1.2 .3 ] [ .3 4. ] ] ]";

    public void testBinaryHmm() {
        PipedInputStream pis = new PipedInputStream();
        Hmm<Object> hmm = null;
        try {
            hmm = new Hmm(4, new OpdfIntegerFactory(3));
            PipedOutputStream pos = new PipedOutputStream(pis);
            HmmBinaryWriter.write(pos, hmm);
            hmm = HmmBinaryReader.read(pis);
        }
        catch (IOException e) {
            IOTest.fail((String)e.toString());
        }
        IOTest.assertEquals((int)4, (int)hmm.nbStates());
        IOTest.assertEquals((int)3, (int)((OpdfInteger)hmm.getOpdf(0)).nbEntries());
    }

    public void testOPDF() throws IOException {
        this.opdfCheck("IntegerOPDF [ .32 .68 ]", new OpdfIntegerReader(), new OpdfIntegerWriter());
        this.opdfCheck("GaussianOPDF [ 1.2 .3 ]", new OpdfGaussianReader(), new OpdfGaussianWriter());
        this.opdfCheck("GaussianMixtureOPDF [ [ 1.2 2. ] [ .1 .9 ] [ .4 .6 ] ]", new OpdfGaussianMixtureReader(), new OpdfGaussianMixtureWriter());
        this.opdfCheck("MultiGaussianOPDF [ [ 5. 5. ] [ [ 1.2 .3 ] [ .3 4. ] ] ]", new OpdfMultiGaussianReader(), new OpdfMultiGaussianWriter());
    }

    private <O extends Observation, D extends Opdf<O>> void opdfCheck(String opdfString, OpdfReader<D> reader, OpdfWriter<D> writer) throws IOException {
        try {
            PipedWriter pw = new PipedWriter();
            PipedReader pr = new PipedReader(pw);
            StreamTokenizer st = new StreamTokenizer(new StringReader(opdfString));
            D opdf = reader.read(st);
            writer.write((Writer)pw, opdf);
            reader.read(new StreamTokenizer(pr));
        }
        catch (FileFormatException e) {
            IOTest.fail((String)e.toString());
        }
    }

    public void testHmm() throws IOException {
        Hmm hmm = null;
        try {
            StringReader reader = new StringReader("# A simple Hmm\nHmm v1.0\nNbStates 2\n\nState Pi 0.7\nA 0.1 0.9\nIntegerOPDF [ .2 .3 .4 .1 ]\n\nState Pi 0.3\nA 0.4 0.6\nIntegerOPDF [ .1 .1 .1 .7 ]");
            hmm = HmmReader.read(reader, new OpdfIntegerReader(4));
        }
        catch (FileFormatException e) {
            IOTest.fail((String)e.toString());
        }
        IOTest.assertEquals((int)2, (int)hmm.nbStates());
        IOTest.assertEquals((int)4, (int)((OpdfInteger)hmm.getOpdf(0)).nbEntries());
        PipedWriter pw = new PipedWriter();
        PipedReader pr = new PipedReader(pw);
        try {
            HmmWriter.write(pw, new OpdfIntegerWriter(), hmm);
            hmm = HmmReader.read(pr, new OpdfIntegerReader(4));
        }
        catch (FileFormatException e) {
            IOTest.fail((String)e.toString());
        }
        IOTest.assertEquals((int)2, (int)hmm.nbStates());
        IOTest.assertEquals((int)4, (int)((OpdfInteger)hmm.getOpdf(0)).nbEntries());
    }

    public void testInteger() throws IOException, FileFormatException {
        StringReader reader = new StringReader("# A simple data file with integer observations.\n1;2;3; # The first sequence\n# And the second one\n2;4;5;\n\n# A big one, spawning on multiple lines\n1;2;3; \\\n2;4;5; # Don't forget to end the file with a newline\n");
        List<List<ObservationInteger>> sequences = ObservationSequencesReader.readSequences(new ObservationIntegerReader(), reader);
        ((Reader)reader).close();
        IOTest.assertEquals((String)"Wrong number of sequences read", (int)3, (int)sequences.size());
        IOTest.assertEquals((String)"Wrong first observation", (int)1, (int)sequences.get((int)0).get((int)0).value);
        IOTest.assertEquals((String)"Wrong last observation", (int)5, (int)sequences.get((int)2).get((int)5).value);
    }

    public void testVector() throws IOException, FileFormatException {
        StringReader reader = new StringReader("[ 1.1 2.2 ] ; [ 4.4 5.5 ] ; [ 4.3 6.0 ] ; [ 7.7 8.8 ] ;\n[ 0.5 1.5 ] ; [ 1.5 2.5 ] ; [ 4.5 5.5 ] ; [ 8. 8. ] ; [ 7. 8. ] ;\n");
        List<List<ObservationVector>> sequences = ObservationSequencesReader.readSequences(new ObservationVectorReader(), reader);
        ((Reader)reader).close();
        IOTest.assertEquals((String)"Wrong number of sequences read", (int)2, (int)sequences.size());
        IOTest.assertTrue((String)"Wrong first observation", (boolean)GaussianTest.equalsArrays(sequences.get(0).get(0).values(), new double[]{1.1, 2.2}, 0.0));
        IOTest.assertTrue((String)"Wrong last observation", (boolean)GaussianTest.equalsArrays(sequences.get(1).get(4).values(), new double[]{7.0, 8.0}, 0.0));
    }
}

