/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import javax.swing.JFrame;
import marytts.signalproc.analysis.SpectrumWithPeakIndices;
import marytts.signalproc.display.FunctionGraph;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class SeevocAnalyser {
    public static SpectrumWithPeakIndices calcSpecEnvelopeDB(double[] absMagSpecIndB, int samplingRate) {
        return SeevocAnalyser.calcSpecEnvelopeDB(absMagSpecIndB, samplingRate, 100.0);
    }

    public static SpectrumWithPeakIndices calcSpecEnvelopeLinear(double[] absMagSpecIndB, int samplingRate, double f0) {
        SpectrumWithPeakIndices s = SeevocAnalyser.calcSpecEnvelopeDB(absMagSpecIndB, samplingRate, f0);
        s.spec = MathUtils.db2amp(s.spec);
        return s;
    }

    public static SpectrumWithPeakIndices calcSpecEnvelopeDB(double[] absMagSpecIndB, int samplingRate, double f0) {
        int j;
        int currentInd;
        int endInd;
        int startInd;
        int i;
        SpectrumWithPeakIndices s = new SpectrumWithPeakIndices();
        if (f0 < 10.0) {
            f0 = 100.0;
        }
        int maxPeaks = (int)Math.floor(0.5 * (double)samplingRate / f0 + 0.5) + 10;
        double[] peakVals = new double[maxPeaks];
        int[] peakInds = new int[maxPeaks];
        double[] peakFreqs = new double[maxPeaks];
        int maxFreqInd = absMagSpecIndB.length - 1;
        double[] freqs = new double[maxFreqInd + 1];
        for (i = 0; i <= maxFreqInd; ++i) {
            freqs[i] = SignalProcUtils.index2freq(i, samplingRate, maxFreqInd);
        }
        int numPeaks = 0;
        double currentFreq = 0.0;
        boolean bEndNotCovered = true;
        while (!(currentFreq + 1.5 * f0 > 0.5 * (double)samplingRate)) {
            startInd = SignalProcUtils.freq2index(currentFreq + 0.5 * f0, (double)samplingRate, maxFreqInd);
            endInd = SignalProcUtils.freq2index(currentFreq + 1.5 * f0, (double)samplingRate, maxFreqInd);
            startInd = Math.max(0, startInd);
            endInd = Math.min(endInd, maxFreqInd);
            startInd = Math.min(startInd, endInd);
            if (endInd == maxFreqInd) {
                bEndNotCovered = false;
            }
            if ((currentInd = MathUtils.getAbsMaxInd(absMagSpecIndB, startInd, endInd)) == -1) {
                peakVals[numPeaks + 1] = Math.max(absMagSpecIndB[startInd], absMagSpecIndB[endInd]);
                currentInd = (int)Math.floor(0.5 * (double)(startInd + endInd) + 0.5);
            } else {
                peakVals[numPeaks + 1] = absMagSpecIndB[currentInd];
            }
            currentFreq = SignalProcUtils.index2freq(currentInd, samplingRate, maxFreqInd);
            peakInds[numPeaks + 1] = currentInd;
            peakFreqs[numPeaks + 1] = currentFreq;
            if (++numPeaks == 1) {
                startInd = 0;
                endInd = SignalProcUtils.freq2index(currentFreq - 0.5 * f0, (double)samplingRate, maxFreqInd);
                startInd = Math.max(0, startInd);
                currentInd = MathUtils.getAbsMaxInd(absMagSpecIndB, startInd = Math.min(startInd, endInd = Math.min(endInd, maxFreqInd)), endInd);
                if (currentInd == -1) {
                    peakVals[0] = Math.max(absMagSpecIndB[startInd], absMagSpecIndB[endInd]);
                    currentInd = (int)Math.floor(0.5 * (double)(startInd + endInd) + 0.5);
                } else {
                    peakVals[0] = absMagSpecIndB[currentInd];
                }
                peakInds[0] = currentInd;
                peakFreqs[0] = SignalProcUtils.index2freq(currentInd, samplingRate, maxFreqInd);
            }
            if (numPeaks <= maxPeaks - 3) continue;
        }
        if (bEndNotCovered && numPeaks < maxPeaks) {
            startInd = SignalProcUtils.freq2index(currentFreq + 0.5 * f0, (double)samplingRate, maxFreqInd);
            endInd = maxFreqInd;
            startInd = Math.max(0, startInd);
            currentInd = MathUtils.getAbsMaxInd(absMagSpecIndB, startInd = Math.min(startInd, endInd), endInd);
            if (currentInd == -1) {
                peakVals[numPeaks + 1] = Math.max(absMagSpecIndB[startInd], absMagSpecIndB[endInd]);
                currentInd = (int)Math.floor(0.5 * (double)(startInd + endInd) + 0.5);
            } else {
                peakVals[numPeaks + 1] = absMagSpecIndB[currentInd];
            }
            peakInds[numPeaks + 1] = currentInd;
            peakFreqs[numPeaks + 1] = SignalProcUtils.index2freq(currentInd, samplingRate, maxFreqInd);
            ++numPeaks;
        }
        s.spec = new double[maxFreqInd + 1];
        for (j = 0; j < peakInds[0]; ++j) {
            s.spec[j] = absMagSpecIndB[0] + (absMagSpecIndB[peakInds[0]] - absMagSpecIndB[0]) / peakFreqs[0] * freqs[j];
        }
        for (i = 0; i < numPeaks - 1; ++i) {
            for (j = peakInds[i]; j < peakInds[i + 1]; ++j) {
                s.spec[j] = absMagSpecIndB[peakInds[i]] + (absMagSpecIndB[peakInds[i + 1]] - absMagSpecIndB[peakInds[i]]) / (peakFreqs[i + 1] - peakFreqs[i]) * (freqs[j] - peakFreqs[i]);
            }
        }
        for (j = peakInds[numPeaks - 1]; j <= maxFreqInd; ++j) {
            s.spec[j] = absMagSpecIndB[peakInds[numPeaks - 1]] + (absMagSpecIndB[maxFreqInd] - absMagSpecIndB[peakInds[numPeaks - 1]]) / (0.5 * (double)samplingRate - peakFreqs[numPeaks - 1]) * (freqs[j] - peakFreqs[numPeaks - 1]);
        }
        s.indices = new int[numPeaks];
        System.arraycopy(peakInds, 0, s.indices, 0, numPeaks);
        return s;
    }

    protected static JFrame showGraph(double[] array, String title) {
        FunctionGraph graph = new FunctionGraph(400, 200, 0.0, 1.0, array);
        JFrame frame = graph.showInJFrame(title, 500, 300, true, false);
        return frame;
    }
}

