/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class MaryRandomAccessFile
extends RandomAccessFile {
    public MaryRandomAccessFile(File arg0, String arg1) throws FileNotFoundException {
        super(arg0, arg1);
    }

    public MaryRandomAccessFile(String arg0, String arg1) throws FileNotFoundException {
        super(arg0, arg1);
    }

    public final boolean readBooleanEndian() throws IOException {
        boolean ret = this.readBoolean();
        return ret;
    }

    public final boolean[] readBoolean(int len) throws IOException {
        boolean[] ret = new boolean[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readBoolean();
        }
        return ret;
    }

    public final boolean[] readBooleanEndian(int len) throws IOException {
        boolean[] ret = new boolean[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readBooleanEndian();
        }
        return ret;
    }

    public final byte readByteEndian() throws IOException {
        byte ret = this.readByte();
        return ret;
    }

    public final byte[] readByte(int len) throws IOException {
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readByte();
        }
        return ret;
    }

    public final byte[] readByteEndian(int len) throws IOException {
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readByteEndian();
        }
        return ret;
    }

    public final char readCharEndian() throws IOException {
        char c = (char)this.readByte();
        return c;
    }

    public final char[] readChar(int len) throws IOException {
        char[] ret = new char[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readChar();
        }
        return ret;
    }

    public final char[] readCharEndian(int len) throws IOException {
        char[] ret = new char[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readCharEndian();
        }
        return ret;
    }

    public final double readDoubleEndian() throws IOException {
        double ret = this.readDouble();
        return ret;
    }

    public final double[] readDouble(int len) throws IOException {
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readDouble();
        }
        return ret;
    }

    public final double[] readDoubleEndian(int len) throws IOException {
        double[] ret = new double[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readDoubleEndian();
        }
        return ret;
    }

    public final int readDoubleToIntEndian() throws IOException {
        int ret = (int)this.readDouble();
        return ret;
    }

    public final int[] readDoubleToInt(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (int)this.readDouble();
        }
        return ret;
    }

    public final int[] readDoubleToIntEndian(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readDoubleToIntEndian();
        }
        return ret;
    }

    public final float readFloatEndian() throws IOException {
        float ret = this.readFloat();
        return ret;
    }

    public final float[] readFloat(int len) throws IOException {
        float[] ret = new float[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readFloat();
        }
        return ret;
    }

    public final float[] readFloatEndian(int len) throws IOException {
        float[] ret = new float[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readFloatEndian();
        }
        return ret;
    }

    public final int readIntEndian() throws IOException {
        int ret = this.readInt();
        return ret;
    }

    public final int[] readInt(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readInt();
        }
        return ret;
    }

    public final int[] readIntEndian(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readIntEndian();
        }
        return ret;
    }

    public final long readLongEndian() throws IOException {
        long ret = this.readInt();
        return ret;
    }

    public final long[] readLong(int len) throws IOException {
        long[] ret = new long[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readLong();
        }
        return ret;
    }

    public final long[] readLongEndian(int len) throws IOException {
        long[] ret = new long[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readLongEndian();
        }
        return ret;
    }

    public final short readShortEndian() throws IOException {
        short ret = this.readShort();
        return ret;
    }

    public final short[] readShort(int len) throws IOException {
        short[] ret = new short[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readShort();
        }
        return ret;
    }

    public final short[] readShortEndian(int len) throws IOException {
        short[] ret = new short[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readShortEndian();
        }
        return ret;
    }

    public final int readUnsignedByteEndian() throws IOException {
        int ret = this.readUnsignedByte();
        return ret;
    }

    public final int[] readUnsignedByte(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readUnsignedByte();
        }
        return ret;
    }

    public final int[] readUnsignedByteEndian(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readUnsignedByteEndian();
        }
        return ret;
    }

    public final int readUnsignedShortEndian() throws IOException {
        int ret = this.readUnsignedShort();
        return ret;
    }

    public final int[] readUnsignedShort(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readUnsignedShort();
        }
        return ret;
    }

    public final int[] readUnsignedShortEndian(int len) throws IOException {
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.readUnsignedShortEndian();
        }
        return ret;
    }

    public final void writeBooleanEndian(boolean v) throws IOException {
        this.writeBoolean(v);
    }

    public final void writeBoolean(boolean[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeBoolean(v[i]);
        }
    }

    public final void writeBooleanEndian(boolean[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeBooleanEndian(v[i]);
        }
    }

    public final void writeBoolean(boolean[] v) throws IOException {
        this.writeBoolean(v, 0, v.length);
    }

    public final void writeBooleanEndian(boolean[] v) throws IOException {
        this.writeBooleanEndian(v, 0, v.length);
    }

    public final void writeByteEndian(byte v) throws IOException {
        this.writeByte(v);
    }

    public final void writeByte(byte[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeByte(v[i]);
        }
    }

    public final void writeByteEndian(byte[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeByteEndian(v[i]);
        }
    }

    public final void writeByte(byte[] v) throws IOException {
        this.writeByte(v, 0, v.length);
    }

    public final void writeByteEndian(byte[] v) throws IOException {
        this.writeByteEndian(v, 0, v.length);
    }

    public final void writeCharEndian(char c) throws IOException {
        this.writeByte((byte)c);
    }

    public final void writeChar(char[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeChar(v[i]);
        }
    }

    public final void writeCharEndian(char[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeCharEndian(v[i]);
        }
    }

    public final void writeChar(char[] v) throws IOException {
        this.writeChar(v, 0, v.length);
    }

    public final void writeCharEndian(char[] v) throws IOException {
        this.writeCharEndian(v, 0, v.length);
    }

    public final void writeDoubleEndian(double v) throws IOException {
        this.writeDouble(v);
    }

    public final void writeDouble(double[] v, int startPos, int len) throws IOException {
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeDouble(v[i]);
        }
    }

    public final void writeDoubleEndian(double[] v, int startPos, int len) throws IOException {
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeDoubleEndian(v[i]);
        }
    }

    public final void writeDouble(double[] v) throws IOException {
        this.writeDouble(v, 0, v.length);
    }

    public final void writeDoubleEndian(double[] v) throws IOException {
        this.writeDoubleEndian(v, 0, v.length);
    }

    public final void writeFloatEndian(float v) throws IOException {
        this.writeFloat(v);
    }

    public final void writeFloat(float[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeFloat(v[i]);
        }
    }

    public final void writeFloatEndian(float[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeFloatEndian(v[i]);
        }
    }

    public final void writeFloat(float[] v) throws IOException {
        this.writeFloat(v, 0, v.length);
    }

    public final void writeFloatEndian(float[] v) throws IOException {
        this.writeFloatEndian(v, 0, v.length);
    }

    public final void writeIntEndian(int v) throws IOException {
        this.writeInt(v);
    }

    public final void writeInt(int[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeInt(v[i]);
        }
    }

    public final void writeIntEndian(int[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeIntEndian(v[i]);
        }
    }

    public final void writeInt(int[] v) throws IOException {
        this.writeInt(v, 0, v.length);
    }

    public final void writeIntEndian(int[] v) throws IOException {
        this.writeIntEndian(v, 0, v.length);
    }

    public final void writeLongEndian(long v) throws IOException {
        this.writeInt((int)v);
    }

    public final void writeLong(long[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeLong(v[i]);
        }
    }

    public final void writeLongEndian(long[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeLongEndian(v[i]);
        }
    }

    public final void writeLong(long[] v) throws IOException {
        this.writeLong(v, 0, v.length);
    }

    public final void writeLongEndian(long[] v) throws IOException {
        this.writeLongEndian(v, 0, v.length);
    }

    public final void writeShortEndian(short v) throws IOException {
        this.writeShort(v);
    }

    public final void writeShort(short[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeShort(v[i]);
        }
    }

    public final void writeShortEndian(short[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        for (int i = startPos; i < startPos + len; ++i) {
            this.writeShortEndian(v[i]);
        }
    }

    public final void writeShort(short[] v) throws IOException {
        this.writeShort(v, 0, v.length);
    }

    public final void writeShortEndian(short[] v) throws IOException {
        this.writeShort(v);
    }
}

