/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import opennlp.model.AbstractEventStream;
import opennlp.model.Event;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AdditionalContextFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFinderEventStream
extends AbstractEventStream {
    private ObjectStream<NameSample> nameSampleStream;
    private Iterator<Event> events = Collections.emptyList().iterator();
    private NameContextGenerator contextGenerator;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();
    private String type;

    public NameFinderEventStream(ObjectStream<NameSample> dataStream, String type, NameContextGenerator contextGenerator) {
        this.nameSampleStream = dataStream;
        this.contextGenerator = contextGenerator;
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        this.type = type != null ? type : "default";
    }

    public NameFinderEventStream(ObjectStream<NameSample> dataStream) {
        this(dataStream, null, new DefaultNameContextGenerator());
    }

    public static String[] generateOutcomes(Span[] names, String type, int length) {
        String[] outcomes = new String[length];
        for (int i = 0; i < outcomes.length; ++i) {
            outcomes[i] = "other";
        }
        for (int nameIndex = 0; nameIndex < names.length; ++nameIndex) {
            Span name = names[nameIndex];
            outcomes[name.getStart()] = name.getType() == null ? type + "-" + "start" : name.getType() + "-" + "start";
            for (int i = name.getStart() + 1; i < name.getEnd(); ++i) {
                outcomes[i] = name.getType() == null ? type + "-" + "cont" : name.getType() + "-" + "cont";
            }
        }
        return outcomes;
    }

    private void createNewEvents() throws IOException {
        NameSample sample = null;
        sample = this.nameSampleStream.read();
        if (sample != null) {
            int i;
            if (sample.isClearAdaptiveDataSet()) {
                this.contextGenerator.clearAdaptiveData();
            }
            String[] outcomes = NameFinderEventStream.generateOutcomes(sample.getNames(), this.type, sample.getSentence().length);
            this.additionalContextFeatureGenerator.setCurrentContext(sample.getAdditionalContext());
            String[] tokens = new String[sample.getSentence().length];
            ArrayList<Event> events = new ArrayList<Event>(outcomes.length);
            for (i = 0; i < sample.getSentence().length; ++i) {
                tokens[i] = sample.getSentence()[i];
            }
            for (i = 0; i < outcomes.length; ++i) {
                events.add(new Event(outcomes[i], this.contextGenerator.getContext(i, sample.getSentence(), outcomes, null)));
            }
            this.events = events.iterator();
            this.contextGenerator.updateAdaptiveData(tokens, outcomes);
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.events.hasNext()) {
            return true;
        }
        this.createNewEvents();
        return this.events.hasNext();
    }

    @Override
    public Event next() {
        if (!this.events.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.events.next();
    }

    public static String[][] additionalContext(String[] tokens, Map<String, String> prevMap) {
        String[][] ac = new String[tokens.length][1];
        for (int ti = 0; ti < tokens.length; ++ti) {
            String pt = prevMap.get(tokens[ti]);
            ac[ti][0] = "pd=" + pt;
        }
        return ac;
    }

    public static final void main(String[] args) throws IOException {
        if (args.length != 0) {
            System.err.println("Usage: NameFinderEventStream < training files");
            System.exit(1);
        }
        NameFinderEventStream es = new NameFinderEventStream(new NameSampleDataStream(new PlainTextByLineStream(new InputStreamReader(System.in))));
        while (es.hasNext()) {
            System.out.println(es.next());
        }
    }
}

