/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLImageAdder {
    private RandomAccessFile htmlraf;
    private DataOutputStream out;
    private static String fLINK = "\\[width=[0-9.]*\\]([a-zA-Z0-9_]*.png)";
    private static String fFRAGMENT = "<img src=\"$1\">";

    public HTMLImageAdder(String pathHtmlFileIn) {
        File htmlFile = new File(pathHtmlFileIn);
        File fileOut = new File(htmlFile.getParent(), "guimanualtemp.html");
        try {
            this.htmlraf = new RandomAccessFile(htmlFile, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileOut)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.correct();
    }

    public void correct() {
        try {
            while (this.htmlraf.getFilePointer() != this.htmlraf.length()) {
                String tmp = this.htmlraf.readLine();
                String result = HTMLImageAdder.replaceLinks(tmp);
                int i = 0;
                while (i < (String.valueOf(result) + "\n").length()) {
                    this.out.write((byte)(String.valueOf(result) + "\n").charAt(i));
                    ++i;
                }
            }
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String replaceLinks(String aHtmlTextWithLinks) {
        Pattern pattern = Pattern.compile(fLINK);
        Matcher matcher = pattern.matcher(aHtmlTextWithLinks);
        return matcher.replaceAll(fFRAGMENT);
    }

    public static void main(String[] args) {
        new HTMLImageAdder(args[0]);
    }
}

