/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParameterRefactoring {
    private BufferedReader srcFile;
    private BufferedWriter dstFile;
    private BufferedWriter logFile;
    private boolean isProperty = false;
    private boolean containsTODOs = false;
    private String file = "";
    private String workingDir;
    private String logDir;
    private StringBuffer newEntries = new StringBuffer("");
    private List<File> files = new LinkedList<File>();
    private int currentPosition = 0;
    private int nextIndex = 0;
    private int numberParameter = 0;
    private int numberProperty = 0;
    private int parameterDeclaration = 0;
    private int propertyDeclaration = 0;
    List<String> blackList = Arrays.asList("user.dir", "rapidminer.home", "os.name", "noWordSep", "keep_example_set", "min_similarity", "java.class.path", "user.home", "line.separator");

    public ParameterRefactoring(String workingDir, String logDir) {
        this.workingDir = workingDir;
        this.logDir = logDir;
    }

    public void transformFiles() {
        this.getAllFiles(new File(this.workingDir));
        Date dt = new Date();
        this.logFile = this.openOutputWriter(new File(this.logDir, "refactor-" + dt.getTime() + ".log"));
        this.writeToLog("Refactoring started " + dt + ", ");
        this.writeToLog("changes were made to the following classes:\n");
        int i = 0;
        while (i < this.files.size()) {
            this.file = "";
            this.currentPosition = 0;
            this.nextIndex = 0;
            this.containsTODOs = false;
            this.newEntries = new StringBuffer("");
            File currentFile = this.files.get(i);
            String[] fileName = currentFile.getName().split("\\.");
            String className = fileName[0];
            this.srcFile = this.openSourceFile(currentFile);
            if (this.srcFile == null) {
                System.out.println("Target file not found!");
                break;
            }
            this.fillBuffer();
            this.closeSourceFile();
            this.writeToLog("\n--> " + className + " class at \"" + currentFile.toString() + "\"\n\n");
            int currentIndex = this.getNextParameterTokenIndex();
            while (currentIndex != -1) {
                this.replaceParameterToken(currentIndex);
                currentIndex = this.getNextParameterTokenIndex();
            }
            this.setDeclarations(className);
            this.checkForNonStandardVariables();
            this.findOtherStatements();
            if (!this.newEntries.toString().equals("") || this.containsTODOs) {
                String path = currentFile.getParent();
                if (path == null) break;
                this.dstFile = this.openOutputWriter(new File(path, String.valueOf(className) + ".java"));
                this.writeOutput();
            }
            ++i;
        }
        this.writeToLog("\nSome strings remained unchanged:\n\n\t[parameter]: " + this.numberParameter + "\t[property]: " + this.numberProperty);
        this.writeToLog("\n\t[parameter declaration]: " + this.parameterDeclaration + "\t[property declaration]: " + this.propertyDeclaration);
        try {
            this.logFile.flush();
            this.logFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void replaceParameterToken(int pos) {
        Matcher findDeclaration;
        Pattern parameterTypeDeclaration;
        Matcher findNameReference;
        Pattern nameReference;
        String fullStatement;
        String newName;
        String comment;
        String key = "[parameter]";
        int startOfName = this.file.indexOf(34, pos);
        int endOfName = this.file.indexOf(34, startOfName + 1);
        String name = this.file.substring(startOfName, endOfName + 1);
        int startOfDescription = this.file.indexOf(34, endOfName + 1);
        int endOfDescription = this.file.indexOf(34, startOfDescription + 1);
        boolean isEndOfDescription = false;
        while (!isEndOfDescription) {
            String indicator = this.file.substring(endOfDescription - 1, endOfDescription + 1);
            if (indicator.equals("\\\"")) {
                endOfDescription = this.file.indexOf(34, endOfDescription + 1);
                continue;
            }
            isEndOfDescription = true;
        }
        String descriptionName = this.file.substring(startOfDescription, endOfDescription + 1);
        if (!this.isProperty) {
            comment = "\n\t/** The parameter name for &quot;" + descriptionName.substring(1, descriptionName.length() - 1) + "&quot; */";
            this.newEntries.append(comment);
            newName = "PARAMETER_" + this.file.substring(startOfName + 1, endOfName).toUpperCase().trim();
            fullStatement = "\n\tpublic static final String " + newName + " = " + name + ";\n";
            this.newEntries.append(fullStatement);
            nameReference = Pattern.compile("([Ligset]*Parameter[Set]*[^\\(]*\\(\\s*)" + name);
            findNameReference = nameReference.matcher(this.file);
            this.file = findNameReference.replaceAll("$1" + newName);
            parameterTypeDeclaration = Pattern.compile("(new\\s+ParameterType[^\\(]*\\(\\s*)" + name);
            findDeclaration = parameterTypeDeclaration.matcher(this.file);
            this.file = findDeclaration.replaceAll("$1" + newName);
        } else {
            key = "[property]";
            comment = "\n\t/** The property name for &quot;" + descriptionName.substring(1, descriptionName.length() - 1) + "&quot; */";
            this.newEntries.append(comment);
            newName = "PROPERTY_" + name.substring(1, name.length() - 1).toUpperCase().replace('.', '_').trim();
            fullStatement = "\n\tpublic static final String " + newName + " = " + name + ";\n";
            this.newEntries.append(fullStatement);
            nameReference = Pattern.compile("([gs]+etProperty[^\\(]*\\(\\s*)" + name);
            findNameReference = nameReference.matcher(this.file);
            this.file = findNameReference.replaceAll("$1" + newName);
            parameterTypeDeclaration = Pattern.compile("(Property\\s*\\(\\s*new\\s+ParameterType[^\\(]*\\(\\s*)" + name);
            findDeclaration = parameterTypeDeclaration.matcher(this.file);
            this.file = findDeclaration.replaceAll("$1" + newName);
        }
        int currentIndex = this.findOccurranceOf(name, 0);
        while (currentIndex >= 0) {
            this.writeToLog("\t" + key + " " + name + "\t occurs at position " + currentIndex + " (line " + this.getLineNumber(currentIndex) + ")\n");
            currentIndex = this.findOccurranceOf(name, currentIndex + 1);
        }
    }

    private int getNextParameterTokenIndex() {
        int nextParameterIndex = -1;
        int nextPropertyIndex = -1;
        boolean isRegular = false;
        try {
            Pattern parameterTypeDeclaration = Pattern.compile("(new\\s+ParameterType[^\\(]*\\(\\s*)([A-Z\"])");
            Matcher findParameterDeclaration = parameterTypeDeclaration.matcher(this.file);
            findParameterDeclaration.find(this.currentPosition);
            if (!findParameterDeclaration.group(2).equals("\"")) {
                isRegular = true;
            }
            nextParameterIndex = findParameterDeclaration.end(1) - 1;
        }
        catch (RuntimeException e) {
            nextParameterIndex = -2;
        }
        try {
            Pattern propertyTypeDeclaration = Pattern.compile("Property\\s*\\(\\s*(new\\s+ParameterType[^\\(]*\\(\\s*)([A-Z\"])");
            Matcher findPropertyDeclaration = propertyTypeDeclaration.matcher(this.file);
            findPropertyDeclaration.find(this.currentPosition);
            nextPropertyIndex = findPropertyDeclaration.end(1) - 1;
            if (!findPropertyDeclaration.group(2).equals("\"")) {
                isRegular = true;
                this.nextIndex = nextPropertyIndex;
            }
        }
        catch (RuntimeException e) {
            nextPropertyIndex = -3;
        }
        if (nextParameterIndex == -2 && nextPropertyIndex == -3) {
            return -1;
        }
        this.isProperty = nextParameterIndex == nextPropertyIndex;
        this.nextIndex = nextParameterIndex;
        Character currentChar = Character.valueOf('c');
        int currentIndex = this.nextIndex + 1;
        int numberOfOpenBrackets = 1;
        int numberOfClosedBrackets = 0;
        boolean notAllBracketsClosed = true;
        while (notAllBracketsClosed) {
            currentChar = Character.valueOf(this.file.charAt(currentIndex));
            if (currentChar.equals(Character.valueOf('\"'))) {
                currentChar = Character.valueOf(this.file.charAt(++currentIndex));
                while (!currentChar.equals(Character.valueOf('\"'))) {
                    currentChar = Character.valueOf(this.file.charAt(++currentIndex));
                }
            }
            if (currentChar.equals(Character.valueOf('('))) {
                ++numberOfOpenBrackets;
            }
            if (currentChar.equals(Character.valueOf(')'))) {
                ++numberOfClosedBrackets;
            }
            if (numberOfClosedBrackets == numberOfOpenBrackets) {
                notAllBracketsClosed = false;
            }
            ++currentIndex;
        }
        this.currentPosition = currentIndex;
        if (isRegular) {
            return this.getNextParameterTokenIndex();
        }
        return this.nextIndex;
    }

    private void checkForNonStandardVariables() {
        boolean parameterMatch = true;
        boolean propertyMatch = true;
        int nextParameterIndex = 0;
        int nextPropertyIndex = 0;
        while (parameterMatch || propertyMatch) {
            String end;
            String start;
            int todoPosition;
            try {
                Pattern parameterTypeDeclaration = Pattern.compile("[^y]\\s*\\(\\s*new\\s+ParameterType[^\\(]*\\(\\s*([^P\\s,]\\w*\\.?[^P\\s,.]\\w*\\s*),");
                Matcher findParameterDeclaration = parameterTypeDeclaration.matcher(this.file);
                findParameterDeclaration.find(nextParameterIndex);
                nextParameterIndex = findParameterDeclaration.start(1);
                String parameterStatement = this.file.substring(nextParameterIndex, findParameterDeclaration.end(1));
                this.writeToLog("\t[parameter declaration] " + parameterStatement + "\t occurs at position " + nextParameterIndex + " (line " + this.getLineNumber(nextParameterIndex) + ")\n");
                todoPosition = this.getPositionOfNextLineFeed(nextParameterIndex);
                start = this.file.substring(0, todoPosition);
                end = this.file.substring(todoPosition);
                this.file = String.valueOf(start) + " // TODO [parameter declaration]" + end;
                ++this.parameterDeclaration;
                this.containsTODOs = true;
            }
            catch (RuntimeException e) {
                parameterMatch = false;
            }
            try {
                Pattern propertyTypeDeclaration = Pattern.compile("Property\\s*\\(\\s*new\\s+ParameterType[^\\(]*\\(\\s*([^P\\s,]\\w*\\.?[^P\\s,.]\\w*\\s*),");
                Matcher findPropertyDeclaration = propertyTypeDeclaration.matcher(this.file);
                findPropertyDeclaration.find(nextPropertyIndex);
                nextPropertyIndex = findPropertyDeclaration.start(1);
                String propertyStatement = this.file.substring(nextPropertyIndex, findPropertyDeclaration.end(1));
                this.writeToLog("\t[property declaration] " + propertyStatement + "\t occurs at position " + nextPropertyIndex + " (line " + this.getLineNumber(nextPropertyIndex) + ")\n");
                todoPosition = this.getPositionOfNextLineFeed(nextPropertyIndex);
                start = this.file.substring(0, todoPosition);
                end = this.file.substring(todoPosition);
                this.file = String.valueOf(start) + " // TODO [property declaration]" + end;
                ++this.propertyDeclaration;
                this.containsTODOs = true;
            }
            catch (RuntimeException e) {
                propertyMatch = false;
            }
        }
    }

    private void findOtherStatements() {
        boolean parameterMatch = true;
        boolean propertyMatch = true;
        int parameterIndex = 0;
        int propertyIndex = 0;
        while (parameterMatch || propertyMatch) {
            String end;
            String start;
            int todoPosition;
            Matcher findReference;
            Pattern reference;
            try {
                reference = Pattern.compile("([Ligset]*)Parameter[\\w]*\\(\\s*\"([^\\)\"]*)\"\\s*\\)");
                findReference = reference.matcher(this.file);
                findReference.find(parameterIndex);
                parameterIndex = findReference.start(1);
                String parameter = this.file.substring(findReference.start(2), findReference.end(2));
                if (this.blackList.contains(parameter)) {
                    parameterIndex = findReference.end(2);
                } else {
                    this.writeToLog("\t[parameter] \"" + parameter + "\"\t occurs at position " + parameterIndex + " (line " + this.getLineNumber(parameterIndex) + ")\n");
                    parameterIndex = findReference.end(2);
                    todoPosition = this.getPositionOfNextLineFeed(parameterIndex);
                    start = this.file.substring(0, todoPosition);
                    end = this.file.substring(todoPosition);
                    this.file = String.valueOf(start) + " // TODO [parameter]" + end;
                    ++this.numberParameter;
                    this.containsTODOs = true;
                }
            }
            catch (RuntimeException e) {
                parameterMatch = false;
            }
            try {
                reference = Pattern.compile("([gs])+etProperty[\\w]*\\(\\s*\"([^\\)\"]*)\"\\s*\\)");
                findReference = reference.matcher(this.file);
                findReference.find(propertyIndex);
                propertyIndex = findReference.start(1);
                String property = this.file.substring(findReference.start(2), findReference.end(2));
                if (this.blackList.contains(property)) {
                    propertyIndex = findReference.end(2);
                    continue;
                }
                this.writeToLog("\t[property] " + property + "\t occurs at position " + propertyIndex + " (line " + this.getLineNumber(propertyIndex) + ")\n");
                propertyIndex = findReference.end(2);
                todoPosition = this.getPositionOfNextLineFeed(propertyIndex);
                start = this.file.substring(0, todoPosition);
                end = this.file.substring(todoPosition);
                this.file = String.valueOf(start) + " // TODO [property]" + end;
                ++this.numberProperty;
                this.containsTODOs = true;
            }
            catch (RuntimeException e) {
                propertyMatch = false;
            }
        }
    }

    private int getPositionOfNextLineFeed(int currentPos) {
        int index = this.file.indexOf(10, currentPos);
        if (index >= 0) {
            return index;
        }
        return this.file.length() - 1;
    }

    private void setDeclarations(String className) {
        Pattern headOfClass = Pattern.compile("(class\\s+" + className + "\\s[\\w\\s,]*\\{\\s*)\n");
        Matcher findClassDeclaration = headOfClass.matcher(this.file);
        if (this.newEntries.length() > 0) {
            this.file = findClassDeclaration.replaceFirst("$1" + this.newEntries.toString() + "\n");
        }
    }

    private int findOccurranceOf(String name, int pos) {
        int nextIndex = -1;
        try {
            Pattern parameterTypeDeclaration = Pattern.compile("(\\()\\s*" + name + "\\s*\\)");
            Matcher findParameterDeclaration = parameterTypeDeclaration.matcher(this.file);
            findParameterDeclaration.find(pos);
            nextIndex = findParameterDeclaration.end(1) + 1;
        }
        catch (RuntimeException e) {
            return -1;
        }
        return nextIndex;
    }

    private int getLineNumber(int pos) {
        int lineNumber = 0;
        int currentIndex = 0;
        while (currentIndex <= pos) {
            currentIndex = this.file.indexOf("\n", currentIndex + 1);
            ++lineNumber;
        }
        return lineNumber;
    }

    private void writeOutput() {
        try {
            this.dstFile.write(this.file);
            this.dstFile.flush();
            this.dstFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToLog(String logOutput) {
        try {
            this.logFile.write(logOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BufferedWriter openOutputWriter(File path) {
        BufferedWriter newFile = null;
        try {
            newFile = new BufferedWriter(new FileWriter(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newFile;
    }

    private BufferedReader openSourceFile(File path) {
        BufferedReader file = null;
        try {
            file = new BufferedReader(new FileReader(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private void closeSourceFile() {
        try {
            this.srcFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fillBuffer() {
        try {
            while (this.srcFile.ready()) {
                this.file = String.valueOf(this.file) + this.srcFile.readLine() + "\n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.srcFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getAllFiles(File root) {
        if (root.isFile()) {
            this.files.add(root);
        }
        if (root.isDirectory()) {
            JAVAFilter filter = new JAVAFilter();
            File[] innerFiles = root.listFiles(filter);
            int i = 0;
            while (i < innerFiles.length) {
                this.files.add(innerFiles[i]);
                ++i;
            }
            File[] innerDirectories = root.listFiles();
            int i2 = 0;
            while (i2 < innerDirectories.length) {
                if (innerDirectories[i2].isDirectory()) {
                    this.getAllFiles(innerDirectories[i2]);
                }
                ++i2;
            }
        }
    }

    public static void main(String[] args) {
        if (args[0] != null && args[1] != null) {
            ParameterRefactoring pM = new ParameterRefactoring(args[0], args[1]);
            pM.transformFiles();
        } else {
            System.out.println("Please specify two directories (working and logging directory) to perform parameter refactoring.");
        }
    }

    private static class JAVAFilter
    implements FilenameFilter {
        private JAVAFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".java");
        }
    }
}

