/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeTransformation;
import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.table.NominalMapping;

public class AttributeTransformationRemapping
implements AttributeTransformation {
    private NominalMapping overlayedMapping;

    public AttributeTransformationRemapping(NominalMapping overlayedMapping) {
        this.overlayedMapping = overlayedMapping;
    }

    public AttributeTransformationRemapping(AttributeTransformationRemapping other) {
        this.overlayedMapping = (NominalMapping)other.overlayedMapping.clone();
    }

    public Object clone() {
        return new AttributeTransformationRemapping(this);
    }

    public void setNominalMapping(NominalMapping mapping) {
        this.overlayedMapping = mapping;
    }

    public double transform(Attribute attribute, double value) {
        if (Double.isNaN(value)) {
            return value;
        }
        if (attribute.isNominal()) {
            try {
                String nominalValue = attribute.getMapping().mapIndex((int)value);
                int index = this.overlayedMapping.getIndex(nominalValue);
                if (index < 0) {
                    return value;
                }
                return index;
            }
            catch (AttributeTypeException e) {
                return value;
            }
        }
        return value;
    }

    public double inverseTransform(Attribute attribute, double value) {
        if (Double.isNaN(value)) {
            return value;
        }
        if (attribute.isNominal()) {
            try {
                String nominalValue = this.overlayedMapping.mapIndex((int)value);
                int newValue = attribute.getMapping().getIndex(nominalValue);
                if (newValue < 0) {
                    return value;
                }
                return newValue;
            }
            catch (AttributeTypeException e) {
                return value;
            }
        }
        return value;
    }

    public boolean isReversable() {
        return true;
    }
}

