/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.gui.graphs.GraphCreatorAdaptor;
import com.rapidminer.gui.graphs.TreeModelEdgeLabelRenderer;
import com.rapidminer.gui.graphs.TreeModelNodeLabelRenderer;
import com.rapidminer.gui.graphs.TreeModelNodeRenderer;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.learner.tree.Edge;
import com.rapidminer.operator.learner.tree.SplitCondition;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.TreeModel;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedOrderedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModelGraphCreator
extends GraphCreatorAdaptor {
    private Factory<String> edgeFactory = new Factory<String>(){
        int i = 0;

        public String create() {
            return "E" + this.i++;
        }
    };
    private Factory<String> vertexFactory = new Factory<String>(){
        int i = 0;

        public String create() {
            return "V" + this.i++;
        }
    };
    private TreeModel model;
    private Map<String, Tree> vertexMap = new HashMap<String, Tree>();
    private Map<String, SplitCondition> edgeMap = new HashMap<String, SplitCondition>();
    private Map<String, Double> edgeStrengthMap = new HashMap<String, Double>();

    public TreeModelGraphCreator(TreeModel model) {
        this.model = model;
    }

    public Tree getTree(String id) {
        return this.vertexMap.get(id);
    }

    @Override
    public String getVertexName(String object) {
        Tree node = this.vertexMap.get(object);
        String name = "";
        if (node != null) {
            if (node.isLeaf()) {
                name = node.getLabel();
            } else {
                Iterator<Edge> e = node.childIterator();
                if (e.hasNext()) {
                    SplitCondition condition = e.next().getCondition();
                    name = condition.getAttributeName();
                }
            }
        }
        return name;
    }

    @Override
    public String getVertexToolTip(String object) {
        Tree tree = this.vertexMap.get(object);
        if (tree != null) {
            StringBuffer result = new StringBuffer();
            if (tree.isLeaf()) {
                String labelString = tree.getLabel();
                if (labelString != null) {
                    result.append("<html><b>Class:</b>&nbsp;" + labelString + "<br>");
                    result.append("<b>Size:</b>&nbsp;" + tree.getFrequencySum() + "<br>");
                    result.append(String.valueOf(SwingTools.transformToolTipText("<b>Class Frequencies:</b>&nbsp;" + tree.getCounterMap().toString())) + "</html>");
                }
            } else {
                result.append("<html><b>Subtree Size:</b>&nbsp;" + tree.getSubtreeFrequencySum() + "</html>");
            }
            return result.toString();
        }
        return null;
    }

    @Override
    public String getEdgeName(String object) {
        SplitCondition condition = this.edgeMap.get(object);
        if (condition != null) {
            return String.valueOf(condition.getRelation()) + " " + condition.getValueString();
        }
        return null;
    }

    @Override
    public boolean isLeaf(String object) {
        Tree tree = this.vertexMap.get(object);
        if (tree != null) {
            return tree.isLeaf();
        }
        return false;
    }

    @Override
    public Graph<String, String> createGraph() {
        DirectedOrderedSparseMultigraph treeGraph = new DirectedOrderedSparseMultigraph();
        Tree root = this.model.getRoot();
        treeGraph.addVertex((Object)"Root");
        this.vertexMap.put("Root", root);
        this.addTree((DirectedOrderedSparseMultigraph<String, String>)treeGraph, root, "Root");
        return new DelegateForest((DirectedGraph)treeGraph);
    }

    private void addTree(DirectedOrderedSparseMultigraph<String, String> treeGraph, Tree node, String parentName) {
        Tree child;
        Edge edge;
        Iterator<Edge> e = node.childIterator();
        double edgeWeightSum = 0.0;
        while (e.hasNext()) {
            edge = e.next();
            child = edge.getChild();
            edgeWeightSum += (double)child.getSubtreeFrequencySum();
        }
        e = node.childIterator();
        while (e.hasNext()) {
            edge = e.next();
            child = edge.getChild();
            SplitCondition condition = edge.getCondition();
            String childName = (String)this.vertexFactory.create();
            String edgeName = (String)this.edgeFactory.create();
            this.vertexMap.put(childName, child);
            this.edgeMap.put(edgeName, condition);
            this.edgeStrengthMap.put(edgeName, (double)child.getSubtreeFrequencySum() / edgeWeightSum);
            treeGraph.addEdge((Object)edgeName, (Object)parentName, (Object)childName);
            this.addTree(treeGraph, child, childName);
        }
    }

    @Override
    public Renderer.Vertex<String, String> getVertexRenderer() {
        int maxSize = -1;
        Tree root = this.model.getRoot();
        maxSize = this.getMaximumLeafSize(root, maxSize);
        return new TreeModelNodeRenderer<String, String>(this, maxSize);
    }

    private int getMaximumLeafSize(Tree tree, int max) {
        if (tree.isLeaf()) {
            return Math.max(max, tree.getFrequencySum());
        }
        Iterator<Edge> e = tree.childIterator();
        int maximum = max;
        while (e.hasNext()) {
            Edge edge = e.next();
            Tree child = edge.getChild();
            maximum = Math.max(maximum, this.getMaximumLeafSize(child, maximum));
        }
        return maximum;
    }

    @Override
    public Renderer.EdgeLabel<String, String> getEdgeLabelRenderer() {
        return new TreeModelEdgeLabelRenderer<String, String>();
    }

    @Override
    public Renderer.VertexLabel<String, String> getVertexLabelRenderer() {
        return new TreeModelNodeLabelRenderer<String, String>(this);
    }

    @Override
    public boolean isEdgeLabelDecorating() {
        return true;
    }

    @Override
    public int getMinLeafHeight() {
        return 26;
    }

    @Override
    public int getMinLeafWidth() {
        return 40;
    }

    @Override
    public boolean isBold(String id) {
        return this.isLeaf(id);
    }

    @Override
    public boolean isRotatingEdgeLabels() {
        return false;
    }

    @Override
    public double getEdgeStrength(String id) {
        Double value = this.edgeStrengthMap.get(id);
        if (value == null) {
            return 1.0;
        }
        if (Double.isNaN(value)) {
            return 1.0;
        }
        return value;
    }

    @Override
    public Object getObject(String id) {
        return this.vertexMap.get(id);
    }

    @Override
    public int getLabelOffset() {
        return 0;
    }
}

