/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.processeditor;

import com.rapidminer.LoggingListener;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.gui.tools.RadioCardPanel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.UpdateQueue;
import com.rapidminer.gui.viewer.DataTableViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.ResultObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultDisplay
extends JPanel {
    private static final long serialVersionUID = 1970923271834221630L;
    private static final String OPERATOR_TREE_ICON_NAME = "table.png";
    private static final String DEFAULT_RESULT_ICON_NAME = "presentation_chart.png";
    private static Icon dataTableIcon = null;
    private static Icon defaultResultIcon = null;
    private List<ResultObject> results = new LinkedList<ResultObject>();
    private final JTabbedPane tabs = new ExtendedJTabbedPane();
    private final JLabel label = new JLabel("Results");
    private final Collection<DataTable> dataTables = new LinkedList<DataTable>();
    private final UpdateQueue tableUpdateQueue = new UpdateQueue("ResultDisplayDataTableViewUpdater");
    private final LoggingListener logListener = new LoggingListener(){

        public void addDataTable(DataTable dataTable) {
            ResultDisplay.this.dataTables.add(dataTable);
            ResultDisplay.this.updateDataTables(ResultDisplay.this.dataTables);
        }

        public void removeDataTable(DataTable dataTable) {
            ResultDisplay.this.dataTables.remove(dataTable);
            ResultDisplay.this.updateDataTables(ResultDisplay.this.dataTables);
        }
    };

    static {
        dataTableIcon = SwingTools.createIcon("16/table.png");
        defaultResultIcon = SwingTools.createIcon("16/presentation_chart.png");
    }

    public ResultDisplay() {
        super(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.label, "North");
        this.setData(null, "Results");
        this.tableUpdateQueue.start();
    }

    public void clear() {
        this.tabs.removeAll();
        this.results.clear();
        this.dataTables.clear();
        this.label.setText("No results produced.");
        this.repaint();
    }

    private void updateDataTables(Collection<DataTable> newTableList) {
        final LinkedList<DataTable> copy = new LinkedList<DataTable>(newTableList);
        this.tableUpdateQueue.execute(new Runnable(){

            public void run() {
                LinkedList<DataTableViewer> viewers = new LinkedList<DataTableViewer>();
                for (DataTable table : copy) {
                    viewers.add(new DataTableViewer(table, true, 1));
                }
                ResultDisplay.this.installDataTableViewers(viewers);
            }

            public String toString() {
                return "Update data table list to size " + copy.size();
            }
        });
    }

    private void installDataTableViewers(final Collection<DataTableViewer> viewers) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i = ResultDisplay.this.tabs.getTabCount() - 1;
                while (i >= 0) {
                    Component c = ResultDisplay.this.tabs.getComponentAt(i);
                    if (c instanceof DataTableViewer) {
                        ResultDisplay.this.tabs.removeTabAt(i);
                    }
                    --i;
                }
                int pos = 0;
                for (DataTableViewer viewer : viewers) {
                    ResultDisplay.this.tabs.insertTab(viewer.getDataTable().getName(), dataTableIcon, viewer, "The data table '" + viewer.getDataTable().getName() + "'.", pos);
                    ++pos;
                }
            }
        });
    }

    public void setData(IOContainer resultContainer, String message) {
        final int selectedIndex = this.tabs.getSelectedIndex();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i = ResultDisplay.this.tabs.getTabCount() - 1;
                while (i >= 0) {
                    Component c = ResultDisplay.this.tabs.getComponentAt(i);
                    if (!(c instanceof DataTableViewer)) {
                        ResultDisplay.this.tabs.removeTabAt(i);
                    }
                    --i;
                }
            }
        });
        this.results = ResultDisplay.convertToList(resultContainer);
        if (this.results.size() == 0) {
            this.label.setText("No results produced.");
        } else {
            TreeSet<String> doubleUsedNames = new TreeSet<String>();
            TreeSet<String> usedResultNames = new TreeSet<String>();
            for (ResultObject resultObject : this.results) {
                String resultName = RendererService.getName(resultObject.getClass());
                String usedResultName = resultName;
                if (usedResultName == null) {
                    usedResultName = resultObject.getName();
                }
                if (usedResultNames.contains(usedResultName)) {
                    doubleUsedNames.add(usedResultName);
                }
                usedResultNames.add(usedResultName);
            }
            this.label.setText(null);
            for (final ResultObject result : this.results) {
                Component visualisationComponent;
                String resultName = RendererService.getName(result.getClass());
                if (resultName != null) {
                    List<Renderer> renderers = RendererService.getRenderers(resultName);
                    if (renderers.size() > 0) {
                        visualisationComponent = new RadioCardPanel();
                        for (Renderer renderer : renderers) {
                            ((RadioCardPanel)visualisationComponent).addCard(renderer.getName(), renderer.getVisualizationComponent(result, resultContainer));
                        }
                    } else {
                        visualisationComponent = result.getVisualizationComponent(resultContainer);
                        if (visualisationComponent instanceof JLabel) {
                            visualisationComponent = new ExtendedJScrollPane(visualisationComponent);
                        }
                    }
                } else {
                    visualisationComponent = result.getVisualizationComponent(resultContainer);
                    if (visualisationComponent instanceof JLabel) {
                        visualisationComponent = new ExtendedJScrollPane(visualisationComponent);
                    }
                }
                final JPanel resultPanel = new JPanel(new BorderLayout());
                resultPanel.putClientProperty("main.component", visualisationComponent);
                resultPanel.add(visualisationComponent, "Center");
                JPanel buttonPanel = new JPanel(new FlowLayout(2));
                Iterator action = result.getActions().iterator();
                while (action.hasNext()) {
                    buttonPanel.add(new JButton((Action)action.next()));
                }
                resultPanel.add((Component)buttonPanel, "South");
                String tabName = resultName;
                if (resultName == null) {
                    tabName = result.getName();
                }
                if (doubleUsedNames.contains(tabName)) {
                    tabName = String.valueOf(tabName) + " (" + result.getSource() + ")";
                }
                final String finalTabName = tabName;
                final Icon resultIcon = result.getResultIcon() != null ? result.getResultIcon() : defaultResultIcon;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ResultDisplay.this.tabs.addTab("<html>" + result.getName() + "<br><small>" + result.getSource() + "</small></html>", resultIcon, resultPanel, "Show the result '" + finalTabName + "'.");
                        if (ResultDisplay.this.tabs.getTabCount() - 1 == selectedIndex) {
                            ResultDisplay.this.tabs.setSelectedIndex(selectedIndex);
                        }
                    }
                });
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ResultDisplay.this.tabs.getSelectedIndex() == -1 && ResultDisplay.this.tabs.getTabCount() > 0) {
                    ResultDisplay.this.tabs.setSelectedIndex(0);
                }
            }
        });
    }

    public Component getCurrentlyDisplayedComponent() {
        if (this.tabs.getTabCount() == 0) {
            return this.tabs;
        }
        return this.tabs.getSelectedComponent();
    }

    private static List<ResultObject> convertToList(IOContainer container) {
        LinkedList<ResultObject> list = new LinkedList<ResultObject>();
        if (container != null) {
            ResultObject result = null;
            do {
                try {
                    result = container.get(ResultObject.class, list.size());
                    list.add(result);
                }
                catch (MissingIOObjectException e) {
                    break;
                }
            } while (result != null);
        }
        return list;
    }

    public List<ResultObject> getResult() {
        return this.results;
    }

    public LoggingListener getLoggingListener() {
        return this.logListener;
    }
}

